/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.hud.traditionalhud;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.engine.core.control.ActionManager;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.core.gui.hud.HUD;
import es.eucm.eadventure.engine.core.gui.hud.traditionalhud.ActionButtons;
import es.eucm.eadventure.engine.core.gui.hud.traditionalhud.Inventory;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class TraditionalHUD
extends HUD {
    private final int GAME_AREA_WIDTH = 800;
    private final int GAME_AREA_HEIGHT = 400;
    private static final int HUD_WIDTH = 800;
    private static final int HUD_HEIGHT = 200;
    private static final int HUD_X = 0;
    private static final int HUD_Y = 400;
    private static final int RESPONSE_TEXT_X = 10;
    private static final int RESPONSE_TEXT_Y = 405;
    private static final int RESPONSE_TEXT_NUMBER_LINES = 9;
    public static final int ACTIONTEXT_PANEL_X = 0;
    public static final int ACTIONTEXT_PANEL_Y = 400;
    private static final int ACTIONTEXT_PANEL_WIDTH = 800;
    private static final int ACTIONTEXT_PANEL_HEIGHT = 35;
    private static final int ACTIONBUTTONS_PANEL_X = 0;
    private static final int ACTIONBUTTONS_PANEL_Y = 435;
    private static final int ACTIONBUTTONS_PANEL_WIDTH = 339;
    private static final int ACTIONBUTTONS_PANEL_HEIGHT = 165;
    public static final int FIRST_ACTIONBUTTON_X = 6;
    public static final int FIRST_ACTIONBUTTON_Y = 442;
    public static final int ACTIONBUTTON_WIDTH = 109;
    public static final int ACTIONBUTTON_HEIGHT = 76;
    public static final int ACTIONBUTTON_SPACING_X = 109;
    public static final int ACTIONBUTTON_SPACING_Y = 76;
    private static final int INVENTORY_PANEL_X = 339;
    private static final int INVENTORY_PANEL_Y = 435;
    private static final int INVENTORY_PANEL_WIDTH = 461;
    private static final int INVENTORY_PANEL_HEIGHT = 165;
    public static final int INVENTORY_LINES = 3;
    public static final int INVENTORY_ITEMS_PER_LINE = 5;
    public static final int SCROLL_WIDTH = 40;
    public static final int SCROLL_HEIGHT = 72;
    public static final int SCROLL_UP_X = 350;
    public static final int SCROLL_UP_Y = 446;
    public static final int SCROLL_DOWN_X = 350;
    public static final int SCROLL_DOWN_Y = 518;
    public static final int ITEMS_PANEL_X = 390;
    public static final int ITEMS_PANEL_Y = 446;
    public static final int ITEMS_PANEL_WIDTH = 400;
    public static final int ITEMS_PANEL_HEIGHT = 144;
    public static final int FIRST_ITEM_X = 390;
    public static final int FIRST_ITEM_Y = 446;
    public static final int ITEM_WIDTH = 80;
    public static final int ITEM_HEIGHT = 48;
    public static final int ITEM_SPACING_X = 80;
    public static final int ITEM_SPACING_Y = 48;
    private ActionButtons actionButtons;
    private Inventory inventory;
    private Image background;
    private boolean mouseInInventory;
    private Cursor[] actionCursors;

    @Override
    public void init() {
        super.init();
        this.actionCursors = new Cursor[7];
        this.background = MultimediaManager.getInstance().loadImage("gui/hud/traditional/HUD.png", 1);
        DescriptorData descriptorData = Game.getInstance().getGameDescriptor();
        this.actionCursors[0] = descriptorData.getCursorPath("use") == null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/use.png", 1), new Point(0, 0), "useCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("use"), 1), new Point(0, 0), "useCursor");
        this.actionCursors[1] = descriptorData.getCursorPath("look") == null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/look.png", 1), new Point(0, 0), "lookCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("look"), 1), new Point(0, 0), "lookCursor");
        this.actionCursors[2] = descriptorData.getCursorPath("examine") == null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/examine.png", 1), new Point(0, 0), "examineCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("examine"), 1), new Point(0, 0), "examineCursor");
        this.actionCursors[3] = descriptorData.getCursorPath("talk") == null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/talk.png", 1), new Point(0, 0), "talkCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("talk"), 1), new Point(0, 0), "talkCursor");
        this.actionCursors[4] = descriptorData.getCursorPath("grab") == null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/grab.png", 1), new Point(0, 0), "grabCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("grab"), 1), new Point(0, 0), "grabCursor");
        this.actionCursors[5] = descriptorData.getCursorPath("give") == null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/give.png", 1), new Point(0, 0), "giveCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("give"), 1), new Point(0, 0), "giveCursor");
        this.actionCursors[6] = descriptorData.getCursorPath("exit") == null ? null : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath("exit"), 1), new Point(0, 0), "exitCursor");
        this.actionButtons = new ActionButtons(false);
        this.inventory = new Inventory();
        this.mouseInInventory = false;
    }

    @Override
    public int getGameAreaWidth() {
        return 800;
    }

    @Override
    public int getGameAreaHeight() {
        return 400;
    }

    @Override
    public int getResponseTextX() {
        return 10;
    }

    @Override
    public int getResponseTextY() {
        return 405;
    }

    @Override
    public int getResponseTextNumberLines() {
        return 9;
    }

    @Override
    public void newActionSelected() {
        switch (this.game.getActionManager().getActionSelected()) {
            case 6: {
                this.gui.setDefaultCursor();
                this.actionButtons.setButtonPressed(-1);
                break;
            }
            case 4: {
                this.gui.setCursor(this.actionCursors[0]);
                this.actionButtons.setButtonPressed(4);
                break;
            }
            case 0: {
                this.gui.setCursor(this.actionCursors[1]);
                this.actionButtons.setButtonPressed(0);
                break;
            }
            case 3: {
                this.gui.setCursor(this.actionCursors[2]);
                this.actionButtons.setButtonPressed(3);
                break;
            }
            case 2: {
                this.gui.setCursor(this.actionCursors[3]);
                this.actionButtons.setButtonPressed(2);
                break;
            }
            case 1: {
                this.gui.setCursor(this.actionCursors[4]);
                this.actionButtons.setButtonPressed(1);
                break;
            }
            case 5: {
                this.gui.setCursor(this.actionCursors[5]);
                this.actionButtons.setButtonPressed(5);
            }
        }
    }

    @Override
    public boolean mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        ActionManager actionManager = this.game.getActionManager();
        this.actionButtons.mouseMoved(null);
        if (mouseEvent.getX() > 0 && mouseEvent.getX() < 800 && mouseEvent.getY() > 400 && mouseEvent.getY() < 600) {
            bl = true;
            if (mouseEvent.getX() > 0 && mouseEvent.getX() < 339 && mouseEvent.getY() > 435 && mouseEvent.getY() < 600) {
                if (this.mouseInInventory) {
                    if (actionManager.getActionSelected() == 0) {
                        actionManager.setActionSelected(6);
                    }
                    this.mouseInInventory = false;
                }
                this.actionButtons.mouseMoved(mouseEvent);
            } else if (mouseEvent.getX() > 339 && mouseEvent.getX() < 800 && mouseEvent.getY() > 435 && mouseEvent.getY() < 600) {
                if (mouseEvent.getX() > 390 && mouseEvent.getX() < 790 && mouseEvent.getY() > 446 && mouseEvent.getY() < 590) {
                    if (actionManager.getActionSelected() == 6) {
                        actionManager.setActionSelected(0);
                    }
                } else if (actionManager.getActionSelected() == 0) {
                    actionManager.setActionSelected(6);
                }
                if (!this.mouseInInventory) {
                    this.mouseInInventory = true;
                }
                this.inventory.mouseMoved(mouseEvent);
            } else if (this.mouseInInventory) {
                if (actionManager.getActionSelected() == 0) {
                    actionManager.setActionSelected(6);
                }
                this.mouseInInventory = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean mouseClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        ActionManager actionManager = this.game.getActionManager();
        if (mouseEvent.getButton() == 3) {
            if (mouseEvent.getX() > 0 && mouseEvent.getX() < 800 && mouseEvent.getY() > 400 && mouseEvent.getY() < 600) {
                if (mouseEvent.getX() > 339 && mouseEvent.getX() < 800 && mouseEvent.getY() > 435 && mouseEvent.getY() < 600) {
                    if (mouseEvent.getX() > 390 && mouseEvent.getY() > 446) {
                        actionManager.setActionSelected(0);
                    }
                    this.mouseInInventory = true;
                }
                bl = true;
            } else {
                actionManager.setActionSelected(6);
                bl = false;
            }
        } else if (mouseEvent.getX() > 0 && mouseEvent.getX() < 800 && mouseEvent.getY() > 400 && mouseEvent.getY() < 600) {
            this.actionButtons.mouseClicked(null);
            if (mouseEvent.getX() > 0 && mouseEvent.getX() < 339 && mouseEvent.getY() > 435 && mouseEvent.getY() < 600) {
                this.actionButtons.mouseClicked(mouseEvent);
                if (this.actionButtons.getActionPressed() != -1) {
                    actionManager.setActionSelected(this.actionButtons.getActionPressed());
                }
            } else if (mouseEvent.getX() > 339 && mouseEvent.getX() < 800 && mouseEvent.getY() > 435 && mouseEvent.getY() < 600) {
                this.inventory.mouseClicked(mouseEvent);
                if (actionManager.getActionSelected() != 7 && actionManager.getActionSelected() != 8 && mouseEvent.getX() > 390 && mouseEvent.getX() < 790 && mouseEvent.getY() > 446 && mouseEvent.getY() < 590) {
                    actionManager.setActionSelected(0);
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.clearRect(0, 400, 800, 200);
        ActionManager actionManager = this.game.getActionManager();
        graphics2D.setFont(new Font(null, 1, 16));
        String string = "";
        switch (actionManager.getActionSelected()) {
            case 6: {
                string = GameText.TEXT_GO;
                if (actionManager.getElementOver() != null) {
                    string = string + " " + GameText.TEXT_TO + " " + actionManager.getElementOver().getElement().getName();
                    break;
                }
                if (!actionManager.getExit().equals("")) {
                    string = string + " " + GameText.TEXT_TO + " " + actionManager.getExit();
                    if (actionManager.getExitCursor() != null) {
                        GUI.getInstance().setCursor(actionManager.getExitCursor());
                        break;
                    }
                    if (this.actionCursors[6] != null) {
                        GUI.getInstance().setCursor(this.actionCursors[6]);
                        break;
                    }
                    GUI.getInstance().setDefaultCursor();
                    break;
                }
                GUI.getInstance().setDefaultCursor();
                break;
            }
            case 3: {
                string = GameText.TEXT_EXAMINE;
                if (actionManager.getElementOver() == null) break;
                string = string + " " + actionManager.getElementOver().getElement().getName();
                break;
            }
            case 1: {
                string = GameText.TEXT_GRAB;
                if (actionManager.getElementOver() == null) break;
                string = string + " " + actionManager.getElementOver().getElement().getName();
                break;
            }
            case 2: {
                string = GameText.TEXT_TALK;
                if (actionManager.getElementOver() == null) break;
                string = string + " " + GameText.TEXT_TO + " " + actionManager.getElementOver().getElement().getName();
                break;
            }
            case 5: {
                string = GameText.TEXT_GIVE;
                if (actionManager.getElementOver() == null) break;
                string = string + " " + actionManager.getElementOver().getElement().getName();
                break;
            }
            case 8: {
                string = GameText.TEXT_GIVE;
                if (this.game.getFunctionalPlayer().getCurrentAction().getAnotherElement() == null) break;
                string = string + " " + this.game.getFunctionalPlayer().getCurrentAction().getAnotherElement().getElement().getName();
                if (actionManager.getElementOver() == null) break;
                string = string + " " + GameText.TEXT_TO + " " + actionManager.getElementOver().getElement().getName();
                break;
            }
            case 4: {
                string = GameText.TEXT_USE;
                if (actionManager.getElementOver() != null) {
                    string = string + " " + actionManager.getElementOver().getElement().getName();
                }
            }
            case 7: {
                string = GameText.TEXT_USE;
                if (this.game.getFunctionalPlayer().getCurrentAction().getAnotherElement() == null) break;
                string = string + " " + this.game.getFunctionalPlayer().getCurrentAction().getAnotherElement().getElement().getName();
                if (actionManager.getElementOver() == null) break;
                string = string + " " + GameText.TEXT_WITH + " " + actionManager.getElementOver().getElement().getName();
                break;
            }
            case 0: {
                string = GameText.TEXT_LOOK;
                if (actionManager.getElementOver() == null) break;
                string = string + " " + GameText.TEXT_AT + " " + actionManager.getElementOver().getElement().getName();
            }
        }
        graphics2D.setColor(Color.WHITE);
        GUI.drawString(graphics2D, string, 400, 417);
        graphics2D.drawImage(this.background, 0, 435, null);
        this.actionButtons.draw(graphics2D);
        this.inventory.draw(graphics2D);
    }

    @Override
    public void update(long l) {
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent) {
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent) {
        return false;
    }

    @Override
    public boolean keyTyped(KeyEvent keyEvent) {
        return false;
    }
}

