/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.hud.contextualhud;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class Inventory {
    public static final int INVENTORY_PANEL_WIDTH = 800;
    public static final int INVENTORY_PANEL_HEIGHT = 48;
    public static final int UPPER_INVENTORY_PANEL_Y = 0;
    public static final int BOTTOM_INVENTORY_PANEL_Y = 552;
    public static final int INVENTORY_ITEMS_PER_LINE = 8;
    public static final int SCROLL_WIDTH = 80;
    public static final int SCROLL_HEIGHT = 48;
    public static final int SCROLL_LEFT_X = 0;
    public static final int SCROLL_RIGHT_X = 720;
    public static final int ITEMS_PANEL_X = 80;
    public static final int ITEMS_PANEL_WIDTH = 640;
    public static final int FIRST_ITEM_X = 80;
    public static final int ITEM_WIDTH = 80;
    public static final int ITEM_HEIGHT = 48;
    public static final int ITEM_SPACING_X = 80;
    public static final int MIN_OFFSET = 0;
    private int indexFirstItemDisplayed = 0;
    private Image left;
    private Image right;
    private Image lefthigh;
    private Image righthigh;
    private double dy = 33.0;
    private double dx = 0.0;
    private boolean upperInventory;
    private boolean drawLeft;
    private boolean drawRight;
    private boolean highlightRight;
    private boolean highlightLeft;

    public Inventory() {
        DescriptorData descriptorData = Game.getInstance().getGameDescriptor();
        String string = descriptorData.getArrowPath("normalleft");
        String string2 = descriptorData.getArrowPath("normalright");
        this.left = string == null ? MultimediaManager.getInstance().loadImage("gui/hud/contextual/left.png", 1) : MultimediaManager.getInstance().loadImageFromZip(string, 1);
        this.right = string2 == null ? MultimediaManager.getInstance().loadImage("gui/hud/contextual/right.png", 1) : MultimediaManager.getInstance().loadImageFromZip(string2, 1);
        string = descriptorData.getArrowPath("highlightedleft");
        string2 = descriptorData.getArrowPath("highlightedright");
        this.lefthigh = string == null ? MultimediaManager.getInstance().loadImage("gui/hud/contextual/left.png", 1) : MultimediaManager.getInstance().loadImageFromZip(string, 1);
        this.righthigh = string2 == null ? MultimediaManager.getInstance().loadImage("gui/hud/contextual/right.png", 1) : MultimediaManager.getInstance().loadImageFromZip(string2, 1);
        this.upperInventory = false;
    }

    public boolean isUpperInventory() {
        return this.upperInventory;
    }

    public void setUpperInventory(boolean bl) {
        this.upperInventory = bl;
    }

    private void scrollInventoryLeft() {
        if (this.dx == 0.0 && this.indexFirstItemDisplayed > 0) {
            this.dx = 1.0;
        }
    }

    private void scrollInventoryRight() {
        if (this.dx == 0.0 && Game.getInstance().getInventory().getItemCount() > this.indexFirstItemDisplayed + 8) {
            this.dx = -1.0;
        }
    }

    public void draw(Graphics2D graphics2D) {
        int n;
        if (this.dy == 33.0 || this.dy == 48.0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(800, 48, 6);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        Composite composite = graphics2D2.getComposite();
        Color color = graphics2D2.getColor();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D2.setComposite(alphaComposite);
        graphics2D2.setColor(Color.DARK_GRAY);
        graphics2D2.fillRect(0, 0, 800, 48);
        graphics2D2.setComposite(composite);
        graphics2D2.setColor(color);
        this.drawLeft = false;
        this.drawRight = false;
        int n2 = Game.getInstance().getInventory().getItemCount();
        if (n2 < 8) {
            this.indexFirstItemDisplayed = 0;
            n = Game.getInstance().getInventory().getItemCount() - 1;
        } else {
            if (this.indexFirstItemDisplayed > 0) {
                this.drawLeft = true;
            }
            if (n2 - this.indexFirstItemDisplayed > 8) {
                this.drawRight = true;
                n = this.indexFirstItemDisplayed + 8;
            } else {
                n = n2 - 1;
            }
        }
        int n3 = 80 + (int)this.dx;
        graphics2D2.setClip(80, 0, 640, 48);
        int n4 = this.indexFirstItemDisplayed - 1;
        if (n4 < 0) {
            n4 = 0;
        } else {
            n3 -= 80;
        }
        int n5 = n + 1;
        if (n5 > Game.getInstance().getInventory().getItemCount()) {
            n5 = Game.getInstance().getInventory().getItemCount();
        }
        for (int i = n4; i < n5; ++i) {
            graphics2D2.drawImage(Game.getInstance().getInventory().getItem(i).getIconImage(), n3, 0, null);
            n3 += 80;
        }
        graphics2D2.setClip(0, 0, 800, 48);
        if (this.drawLeft) {
            graphics2D2.drawImage(this.highlightLeft ? this.lefthigh : this.left, 0, 0, null);
        }
        if (this.drawRight) {
            graphics2D2.drawImage(this.highlightRight ? this.righthigh : this.right, 720, 0, null);
        }
        graphics2D2.finalize();
        graphics2D.drawImage((Image)bufferedImage, 0, (int)(this.upperInventory ? -this.dy : 552.0 + this.dy), null);
    }

    public FunctionalElement mouseClicked(MouseEvent mouseEvent) {
        int n;
        FunctionalItem functionalItem = null;
        int n2 = n = !this.upperInventory ? 552 : 0;
        if (mouseEvent.getY() <= n || mouseEvent.getY() >= n + 48) {
            return null;
        }
        if (mouseEvent.getX() > 80 && mouseEvent.getX() < 720) {
            int n3 = this.indexFirstItemDisplayed + 8 > Game.getInstance().getInventory().getItemCount() ? Game.getInstance().getInventory().getItemCount() : this.indexFirstItemDisplayed + 8;
            int n4 = 80;
            for (int i = this.indexFirstItemDisplayed; i < n3; ++i) {
                if (n4 < mouseEvent.getX() && mouseEvent.getX() < n4 + 80) {
                    functionalItem = Game.getInstance().getInventory().getItem(i);
                }
                n4 += 80;
            }
        } else if (mouseEvent.getX() > 0 && mouseEvent.getX() < 80) {
            this.scrollInventoryLeft();
        } else if (mouseEvent.getX() > 720 && mouseEvent.getX() < 800) {
            this.scrollInventoryRight();
        }
        return functionalItem;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        FunctionalItem functionalItem = null;
        int n = !this.upperInventory ? 552 : 0;
        this.highlightLeft = false;
        this.highlightRight = false;
        if (mouseEvent.getY() <= n || mouseEvent.getY() >= n + 48) {
            return;
        }
        if (mouseEvent.getX() > 80 && mouseEvent.getX() < 720) {
            int n2 = this.indexFirstItemDisplayed + 8 > Game.getInstance().getInventory().getItemCount() ? Game.getInstance().getInventory().getItemCount() : this.indexFirstItemDisplayed + 8;
            int n3 = 80;
            for (int i = this.indexFirstItemDisplayed; i < n2; ++i) {
                if (n3 < mouseEvent.getX() && mouseEvent.getX() < n3 + 80) {
                    functionalItem = Game.getInstance().getInventory().getItem(i);
                }
                n3 += 80;
            }
        } else if (mouseEvent.getX() > 0 && mouseEvent.getX() < 80) {
            this.highlightLeft = true;
        } else if (mouseEvent.getX() > 720 && mouseEvent.getX() < 800) {
            this.highlightRight = true;
        }
        Game.getInstance().getActionManager().setElementOver(functionalItem);
    }

    public void setDY(double d) {
        if (d > 48.0) {
            d = 48.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        this.dy = d;
    }

    public double getDY() {
        return this.dy;
    }

    public void setDX(double d) {
        if (d < -80.0) {
            ++this.indexFirstItemDisplayed;
            d = 0.0;
        }
        if (d > 80.0) {
            --this.indexFirstItemDisplayed;
            d = 0.0;
        }
        this.dx = d;
    }

    public void update(long l) {
        if (this.dx > 0.0) {
            this.setDX(this.dx + (double)l / 5.0);
        }
        if (this.dx < 0.0) {
            this.setDX(this.dx - (double)l / 5.0);
        }
    }
}

