/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.hud.contextualhud;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.gui.hud.contextualhud.ActionButton;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ActionButtons {
    public static final int ACTIONBUTTON_HAND = 0;
    public static final int ACTIONBUTTON_EYE = 1;
    public static final int ACTIONBUTTON_MOUTH = 2;
    public static final int ACTIONBUTTON_DRAG = 3;
    public static final int ACTIONBUTTON_CUSTOM = 4;
    public static final int MAX_BUTTON_WIDTH = 50;
    public static final int MAX_BUTTON_HEIGHT = 50;
    public static final int MIN_BUTTON_WIDTH = 35;
    public static final int MIN_BUTTON_HEIGHT = 35;
    private double radius = 50.0;
    private int centerX;
    private int centerY;
    private ActionButton buttonOver = null;
    private ActionButton buttonPressed = null;
    private List<ActionButton> buttons;
    private ActionButton handButton;
    private ActionButton mouthButton;
    private ActionButton eyeButton;
    private long appearedTime = Long.MAX_VALUE;
    private static long appearingTime = 600L;

    public ActionButtons(boolean bl) {
        this.buttons = new ArrayList<ActionButton>();
        this.handButton = new ActionButton(0);
        this.mouthButton = new ActionButton(2);
        this.eyeButton = new ActionButton(1);
    }

    public void recreate(int n, int n2, FunctionalElement functionalElement) {
        this.centerX = n;
        this.centerY = n2;
        this.buttons.clear();
        if (functionalElement instanceof FunctionalItem) {
            FunctionalItem functionalItem = (FunctionalItem)functionalElement;
            this.addDefaultObjectButtons(functionalItem);
            this.addCustomActionButtons(((FunctionalItem)functionalElement).getItem().getActions(), functionalElement);
        }
        if (functionalElement instanceof FunctionalNPC) {
            this.addDefaultCharacterButtons((FunctionalNPC)functionalElement);
            this.addCustomActionButtons(((FunctionalNPC)functionalElement).getNPC().getActions(), functionalElement);
        }
        this.recalculateButtonsPositions();
        this.clearButtons();
        this.appearedTime = System.currentTimeMillis();
    }

    private void addCustomActionButtons(List<Action> list, FunctionalElement functionalElement) {
        ArrayList<CustomAction> arrayList = new ArrayList<CustomAction>();
        boolean bl = false;
        for (Action action : list) {
            boolean bl2;
            if (this.buttons.size() >= 8) {
                return;
            }
            if (action.getType() == 8 && !bl && !functionalElement.isInInventory()) {
                boolean bl3 = bl2 = functionalElement.getFirstValidAction(8) != null;
                if (bl2) {
                    this.buttons.add(new ActionButton(3));
                    bl = true;
                }
            }
            if (action.getType() == 5) {
                bl2 = functionalElement.getFirstValidCustomAction(((CustomAction)action).getName()) != null;
                for (CustomAction customAction : arrayList) {
                    if (!customAction.getName().equals(((CustomAction)action).getName())) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                this.buttons.add(new ActionButton((CustomAction)action));
                arrayList.add((CustomAction)action);
                continue;
            }
            if (action.getType() != 6) continue;
            bl2 = functionalElement.getFirstValidCustomInteraction(((CustomAction)action).getName()) != null;
            for (CustomAction customAction : arrayList) {
                if (!customAction.getName().equals(((CustomAction)action).getName())) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            this.buttons.add(new ActionButton((CustomAction)action));
            arrayList.add((CustomAction)action);
        }
    }

    private void clearButtons() {
        for (ActionButton actionButton : this.buttons) {
            actionButton.setPressed(false);
            actionButton.setOver(false);
        }
        this.buttonOver = null;
        this.buttonPressed = null;
    }

    private void recalculateButtonsPositions() {
        double d = Math.PI / (double)(this.buttons.size() - 1);
        double d2 = Math.PI;
        int n = this.centerY;
        int n2 = this.centerX;
        this.radius = 20 * this.buttons.size();
        if (this.centerY > 300) {
            if (this.centerY > 575) {
                n = 575;
            }
            d = -d;
        } else if (this.centerY < 25) {
            n = 25;
        }
        if (this.centerX > 775) {
            n2 = 775;
        }
        if (this.centerX < 50) {
            n2 = 50;
        }
        if ((double)n2 < this.radius + 25.0) {
            if ((double)n - this.radius < 50.0) {
                d2 /= 2.0;
                d /= 2.0;
                this.radius *= 1.5;
            } else if ((double)n + this.radius > 575.0) {
                d2 += d2 / 2.0;
                d /= 2.0;
                this.radius *= 1.5;
            } else {
                if (this.centerY > 300) {
                    d = -d;
                }
                d2 /= 2.0;
            }
        } else if ((double)n2 > 800.0 - this.radius - 25.0) {
            if ((double)n - this.radius < 50.0) {
                d2 /= 2.0;
                d = -d / 2.0;
                this.radius *= 1.5;
            } else if ((double)n + this.radius > 575.0) {
                d2 += d2 / 2.0;
                d = -d / 2.0;
                this.radius *= 1.5;
            } else {
                if (this.centerY > 300) {
                    d = -d;
                }
                d2 = -d2 / 2.0;
            }
        }
        for (ActionButton actionButton : this.buttons) {
            actionButton.setPosX((int)(Math.cos(d2) * this.radius + (double)n2));
            actionButton.setPosY((int)(Math.sin(d2) * this.radius + (double)n));
            d2 -= d;
        }
    }

    private void addDefaultCharacterButtons(FunctionalNPC functionalNPC) {
        boolean bl;
        this.buttons.add(this.eyeButton);
        this.buttons.add(this.mouthButton);
        boolean bl2 = bl = functionalNPC.getFirstValidAction(4) != null;
        if (bl) {
            this.handButton.setName(TC.get((String)"ActionButton.Use"));
            this.buttons.add(this.handButton);
        }
    }

    private void addDefaultObjectButtons(FunctionalItem functionalItem) {
        this.buttons.add(this.eyeButton);
        boolean bl = false;
        if (!functionalItem.isInInventory()) {
            this.handButton.setName(TC.get((String)"ActionButton.Grab"));
            Action action = functionalItem.getFirstValidAction(1);
            Action action2 = functionalItem.getFirstValidAction(4);
            if (action != null) {
                bl = true;
            }
            if (action2 != null) {
                if (action != null && (action2.isConditionsAreMeet() || !action.isConditionsAreMeet())) {
                    this.handButton.setName(TC.get((String)"ActionButton.Use"));
                }
                bl = true;
            }
        } else {
            boolean bl2 = functionalItem.canBeUsedAlone();
            boolean bl3 = functionalItem.getFirstValidAction(2) != null;
            boolean bl4 = functionalItem.getFirstValidAction(3) != null;
            boolean bl5 = bl = bl2 || bl3 || bl4;
            if (bl2 && !bl3 && !bl4) {
                this.handButton.setName(TC.get((String)"ActionButton.Use"));
            } else if (!bl2 && bl3 && !bl4) {
                this.handButton.setName(TC.get((String)"ActionButton.GiveTo"));
            } else if (!bl2 && !bl3 && bl4) {
                this.handButton.setName(TC.get((String)"ActionButton.UseWith"));
            } else if (!bl2 && bl3 && bl4) {
                this.handButton.setName(TC.get((String)"ActionButton.UseGive"));
            } else {
                this.handButton.setName(TC.get((String)"ActionButton.Use"));
            }
        }
        if (bl) {
            this.buttons.add(this.handButton);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        ActionButton actionButton;
        this.clearButtons();
        if (mouseEvent != null && (actionButton = this.getButton(mouseEvent.getX(), mouseEvent.getY())) != null) {
            actionButton.setOver(true);
            this.buttonOver = actionButton;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ActionButton actionButton;
        this.clearButtons();
        if (mouseEvent != null && (actionButton = this.getButton(mouseEvent.getX(), mouseEvent.getY())) != null) {
            actionButton.setPressed(true);
            this.buttonPressed = actionButton;
        }
    }

    public void draw(Graphics2D graphics2D) {
        float f = (float)(System.currentTimeMillis() - this.appearedTime) / (float)appearingTime;
        if (f > 1.0f) {
            f = 1.0f;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setColor(Color.RED);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillOval(this.centerX - 8, this.centerY - 8, 16, 16);
        for (ActionButton actionButton : this.buttons) {
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(Color.RED);
            int n = (int)((float)(actionButton.getPosX() - this.centerX) * f + (float)this.centerX);
            int n2 = (int)((float)(actionButton.getPosY() - this.centerY) * f + (float)this.centerY);
            if (actionButton.isOver()) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.drawLine(this.centerX, this.centerY, actionButton.getPosX(), actionButton.getPosY());
                graphics2D.setStroke(stroke);
            } else {
                graphics2D.drawLine(this.centerX, this.centerY, n, n2);
            }
            graphics2D.setComposite(composite);
            actionButton.draw(graphics2D, f, n, n2);
        }
        if (this.buttonOver != null) {
            this.buttonOver.drawName(graphics2D);
        }
    }

    public ActionButton getButtonPressed() {
        return this.buttonPressed;
    }

    public ActionButton getButtonOver() {
        return this.buttonOver;
    }

    public ActionButton getButton(int n, int n2) {
        for (ActionButton actionButton : this.buttons) {
            if (!actionButton.isInside(n, n2)) continue;
            return actionButton;
        }
        return null;
    }
}

