/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.hud.contextualhud;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;

public class ActionButton {
    public int button_width = 40;
    public int button_height = 40;
    public static final int HAND_BUTTON = 0;
    public static final int EYE_BUTTON = 1;
    public static final int MOUTH_BUTTON = 2;
    public static final int DRAG_BUTTON = 3;
    public static final int CUSTOM_BUTTON = 4;
    private Image buttonNormal;
    private Image buttonPressed;
    private Image buttonOver;
    private int posX;
    private int posY;
    private boolean over;
    private boolean pressed;
    private CustomAction customAction;
    private String actionName;
    private int type;

    public ActionButton(int n) {
        switch (n) {
            case 0: {
                this.loadButtonImages("use-grab", "btnHand");
                this.actionName = TC.get((String)"ActionButton.GrabGiveUse");
                break;
            }
            case 1: {
                this.loadButtonImages("examine", "btnEye");
                this.actionName = TC.get((String)"ActionButton.Examine");
                break;
            }
            case 2: {
                this.loadButtonImages("talk", "btnMouth");
                this.actionName = TC.get((String)"ActionButton.Talk");
                break;
            }
            case 3: {
                this.loadButtonImages("use-grab", "btnHand");
                this.actionName = TC.get((String)"ActionButton.Drag");
            }
        }
        this.type = n;
    }

    private void loadButtonImages(String string, String string2) {
        DescriptorData descriptorData = Game.getInstance().getGameDescriptor();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string3 = descriptorData.getButtonPath(string, "normal");
        string4 = descriptorData.getButtonPath(string, "highlighted");
        string5 = descriptorData.getButtonPath(string, "pressed");
        this.buttonNormal = this.loadImage(string3, "gui/hud/contextual/" + string2 + ".png");
        this.buttonOver = this.loadImage(string4, "gui/hud/contextual/" + string2 + "Highlighted.png");
        this.buttonPressed = this.loadImage(string5, "gui/hud/contextual/" + string2 + "Pressed.png");
        this.button_width = this.buttonNormal.getWidth(null);
        this.button_height = this.buttonNormal.getHeight(null);
    }

    private Image loadImage(String string, String string2) {
        Image image = null;
        if (string == null) {
            image = MultimediaManager.getInstance().loadImage(string2, 1);
        } else {
            try {
                image = MultimediaManager.getInstance().loadImageFromZip(string, 1);
            }
            catch (Exception exception) {
                image = MultimediaManager.getInstance().loadImage("gui/hud/contextual/btnError.png", 1);
            }
        }
        return image;
    }

    public ActionButton(CustomAction customAction) {
        this.actionName = customAction.getName();
        this.customAction = customAction;
        Resources resources = null;
        for (int i = 0; i < customAction.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)customAction.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)customAction.getResources().get(i);
        }
        this.buttonNormal = this.loadImage(resources.getAssetPath("buttonNormal"), "gui/hud/contextual/btnError.png");
        this.buttonOver = this.loadImage(resources.getAssetPath("buttonOver"), "gui/hud/contextual/btnError.png");
        this.buttonPressed = this.loadImage(resources.getAssetPath("buttonPressed"), "gui/hud/contextual/btnError.png");
        this.buttonNormal = this.scaleButton(this.buttonNormal);
        this.buttonOver = this.scaleButton(this.buttonOver);
        this.buttonPressed = this.scaleButton(this.buttonPressed);
        this.button_width = this.buttonNormal.getWidth(null);
        this.button_height = this.buttonNormal.getHeight(null);
        this.type = 4;
    }

    private Image scaleButton(Image image) {
        return image;
    }

    public Image getButtonNormal() {
        return this.buttonNormal;
    }

    public Image getButtonPressed() {
        return this.buttonPressed;
    }

    public Image getButtonOver() {
        return this.buttonOver;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public void draw(Graphics2D graphics2D, float f, int n, int n2) {
        int n3 = this.posX - this.button_width / 2;
        int n4 = this.posY - this.button_height / 2;
        if (this.pressed) {
            graphics2D.drawImage(this.buttonPressed, n3, n4, null);
        } else if (this.over) {
            graphics2D.drawImage(this.buttonOver, n3, n4, null);
        } else {
            n3 = n - this.button_width / 2;
            n4 = n2 - this.button_height / 2;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.drawImage(this.buttonNormal, n3, n4, null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawName(Graphics2D graphics2D) {
        int n = this.posY - this.button_height / 2;
        String[] stringArray = new String[]{this.actionName};
        GUI.drawStringOnto(graphics2D, stringArray, this.posX, n, Color.BLACK, Color.WHITE);
    }

    public String getName() {
        return this.actionName;
    }

    public int getType() {
        return this.type;
    }

    public boolean isInside(int n, int n2) {
        return n > this.posX - this.button_width / 2 && n < this.posX + this.button_width / 2 && n2 > this.posY - this.button_height / 2 && n2 < this.posY + this.button_height / 2;
    }

    public void setPressed(boolean bl) {
        this.pressed = bl;
    }

    public void setOver(boolean bl) {
        this.over = bl;
    }

    public CustomAction getCustomAction() {
        return this.customAction;
    }

    public void setName(String string) {
        this.actionName = string;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public boolean isOver() {
        return this.over;
    }
}

