/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.ballonfactory;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Random;

public class BallonFactory {
    public static int marginTop = 2;
    public static int padding = 15;
    private static int maxLineWidth = 0;
    private static int linesHeight = 0;
    private static ConversationLine.Type type = ConversationLine.Type.NORMAL;
    private static int roundRadius = 10;
    private static AffineTransform normal = new AffineTransform();
    private static AffineTransform whisper;
    private static final int VERTICAL_MARGIN = 50;
    private static final int HORIZONTAL_MARGIN = 60;
    private static Position position;

    public static ArrayList<String> getLines(FontMetrics fontMetrics, String string, double d, int n) {
        int n2;
        string = BallonFactory.processType(string);
        maxLineWidth = 0;
        linesHeight = 0;
        int n3 = fontMetrics.stringWidth(string);
        double d2 = Math.pow(n3 / (n2 = fontMetrics.getHeight() + marginTop), d) * (double)n2;
        d2 = d2 > (double)n ? (double)n : d2;
        d2 = d2 < (double)(n / 3) ? (double)(n / 3) : d2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(" ");
        String string2 = "";
        int n4 = 0;
        int n5 = 0;
        while (n4 < stringArray.length) {
            int n6 = fontMetrics.stringWidth(stringArray[n4] + " ");
            if ((double)(n5 + n6) <= d2) {
                n5 += n6;
                string2 = string2 + stringArray[n4++] + " ";
                continue;
            }
            if (string2 != "") {
                arrayList.add(string2);
                maxLineWidth = maxLineWidth < n5 ? n5 : maxLineWidth;
                n5 = 0;
                string2 = "";
                continue;
            }
            string2 = BallonFactory.splitLongWord(fontMetrics, arrayList, stringArray[n4++], d2);
        }
        if (string2 != "") {
            arrayList.add(string2);
            maxLineWidth = maxLineWidth < n5 ? n5 : maxLineWidth;
        }
        linesHeight += (fontMetrics.getHeight() + marginTop) * arrayList.size() - marginTop;
        return arrayList;
    }

    private static String processType(String string) {
        if (string != null && !string.equals("") && string.charAt(0) == '#') {
            String string2 = string.substring(0, string.indexOf(32));
            type = ConversationLine.Type.getType((String)string2);
            if (string2 != "") {
                return string.substring(string2.length());
            }
            return string;
        }
        type = ConversationLine.Type.NORMAL;
        return string;
    }

    private static String splitLongWord(FontMetrics fontMetrics, ArrayList<String> arrayList, String string, double d) {
        boolean bl = false;
        String string2 = "";
        int n = 0;
        while (!bl) {
            string2 = "";
            while (n < string.length() && (double)fontMetrics.stringWidth(string2) < d) {
                string2 = string2 + string.charAt(n++);
            }
            if (n == string.length()) {
                bl = true;
                continue;
            }
            arrayList.add(string2);
            int n2 = fontMetrics.stringWidth(string2);
            maxLineWidth = maxLineWidth < n2 ? n2 : maxLineWidth;
        }
        return string2;
    }

    public static Rectangle getTextBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - maxLineWidth / 2, n2 - linesHeight, maxLineWidth, linesHeight);
        if (BallonFactory.correctHorizontally(rectangle, n3, n4) && !rectangle.contains(n, n2)) {
            position = Position.NORTH;
            return BallonFactory.addPadding(rectangle);
        }
        rectangle = new Rectangle(n - rectangle.width - 60, n2, maxLineWidth, linesHeight);
        if (BallonFactory.correctVertically(rectangle, n3, n4) && !rectangle.contains(n, n2)) {
            position = Position.WEST;
            return BallonFactory.addPadding(rectangle);
        }
        rectangle = new Rectangle(n + 60, n2, maxLineWidth, linesHeight);
        if (BallonFactory.correctVertically(rectangle, n3, n4) && !rectangle.contains(n, n2)) {
            position = Position.EAST;
            return BallonFactory.addPadding(rectangle);
        }
        rectangle = new Rectangle(n - maxLineWidth / 2, n2 + linesHeight + 50, maxLineWidth, linesHeight);
        position = Position.SOUTH;
        BallonFactory.correctHorizontally(rectangle, n3, n4);
        return BallonFactory.addPadding(rectangle);
    }

    private static Rectangle addPadding(Rectangle rectangle) {
        rectangle.x -= padding;
        rectangle.y -= padding;
        rectangle.height += padding * 2;
        rectangle.width += padding * 2;
        return rectangle;
    }

    private static boolean correctHorizontally(Rectangle rectangle, int n, int n2) {
        if (rectangle.x < 0) {
            rectangle.x = 2;
        }
        if (rectangle.x + rectangle.width > n) {
            rectangle.x = n - rectangle.width - 2;
        }
        return BallonFactory.isInsideBounds(rectangle, n, n2);
    }

    private static boolean correctVertically(Rectangle rectangle, int n, int n2) {
        if (rectangle.y < 0) {
            rectangle.y = 2;
        }
        if (rectangle.y + rectangle.height > n2) {
            rectangle.y = n2 - rectangle.height - 2;
        }
        return BallonFactory.isInsideBounds(rectangle, n, n2);
    }

    private static boolean isInsideBounds(Rectangle rectangle, int n, int n2) {
        return rectangle.x > 0 && rectangle.y > 0 && rectangle.x + rectangle.width <= n && rectangle.height <= n2;
    }

    public static Shape getPath(Rectangle rectangle, int n, int n2) {
        switch (type) {
            case YELL: 
            case THOUGHT: {
                return BallonFactory.getCirclePath(rectangle);
            }
            case WHISPER: {
                return BallonFactory.getNormalPath(rectangle);
            }
        }
        return BallonFactory.getNormalPath(rectangle);
    }

    private static Shape getCirclePath(Rectangle rectangle) {
        Random random = new Random();
        random.setSeed(0L);
        int n = 5;
        int n2 = 20;
        int n3 = 5;
        int n4 = 20;
        int n5 = 2;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x, rectangle.y);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = false;
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        while (!bl) {
            n6 = random.nextInt(n) + n2;
            n7 = random.nextInt(n3) + n4;
            int n11 = n8 = type == ConversationLine.Type.THOUGHT ? random.nextInt(n5) + 1 : 2;
            if (n9 + n6 > rectangle.x + rectangle.width) {
                bl = true;
                continue;
            }
            f = n9 + n6 / n8;
            f3 = n10 - n7;
            f2 = n9 + n6;
            f4 = n10;
            if (type == ConversationLine.Type.THOUGHT) {
                generalPath.quadTo(f, f3, f2, f4);
            } else if (type == ConversationLine.Type.YELL) {
                generalPath.lineTo(f, f3);
                generalPath.lineTo(f2, f4);
            }
            n9 += n6;
        }
        n9 = rectangle.x + rectangle.width;
        f = n9 + n7;
        f3 = rectangle.y;
        f2 = n9;
        f4 = n10 + n6;
        if (type == ConversationLine.Type.THOUGHT) {
            generalPath.quadTo(f, f3, f2, f4);
        } else if (type == ConversationLine.Type.YELL) {
            generalPath.lineTo(f, f3);
            generalPath.lineTo(f2, f4);
        }
        n10 += n6;
        bl = false;
        while (!bl) {
            n6 = random.nextInt(n) + n2;
            n7 = random.nextInt(n3) + n4;
            int n12 = n8 = type == ConversationLine.Type.THOUGHT ? random.nextInt(n5) + 1 : 2;
            if (n10 + n6 > rectangle.y + rectangle.height) {
                bl = true;
                continue;
            }
            f = n9 + n7;
            f3 = n10 + n6 / n8;
            f2 = n9;
            f4 = n10 + n6;
            if (type == ConversationLine.Type.THOUGHT) {
                generalPath.quadTo(f, f3, f2, f4);
            } else if (type == ConversationLine.Type.YELL) {
                generalPath.lineTo(f, f3);
                generalPath.lineTo(f2, f4);
            }
            n10 += n6;
        }
        n10 = rectangle.y + rectangle.height;
        f = n9;
        f3 = n10 + n7;
        f2 = n9 - n6;
        f4 = n10;
        if (type == ConversationLine.Type.THOUGHT) {
            generalPath.quadTo(f, f3, f2, f4);
        } else if (type == ConversationLine.Type.YELL) {
            generalPath.lineTo(f, f3);
            generalPath.lineTo(f2, f4);
        }
        n9 -= n6;
        bl = false;
        while (!bl) {
            n6 = random.nextInt(n) + n2;
            n7 = random.nextInt(n3) + n4;
            int n13 = n8 = type == ConversationLine.Type.THOUGHT ? random.nextInt(n5) + 1 : 2;
            if (n9 - n6 < rectangle.x) {
                bl = true;
                continue;
            }
            f = n9 - n6 / n8;
            f3 = n10 + n7;
            f2 = n9 - n6;
            f4 = n10;
            if (type == ConversationLine.Type.THOUGHT) {
                generalPath.quadTo(f, f3, f2, f4);
            } else if (type == ConversationLine.Type.YELL) {
                generalPath.lineTo(f, f3);
                generalPath.lineTo(f2, f4);
            }
            n9 -= n6;
        }
        n9 = rectangle.x;
        f = n9 - n7;
        f3 = rectangle.y + rectangle.height;
        f2 = n9;
        f4 = n10 - n6;
        if (type == ConversationLine.Type.THOUGHT) {
            generalPath.quadTo(f, f3, f2, f4);
        } else if (type == ConversationLine.Type.YELL) {
            generalPath.lineTo(f, f3);
            generalPath.lineTo(f2, f4);
        }
        n10 -= n6;
        bl = false;
        while (!bl) {
            n6 = random.nextInt(n) + n2;
            n7 = random.nextInt(n3) + n4;
            int n14 = n8 = type == ConversationLine.Type.THOUGHT ? random.nextInt(n5) + 1 : 2;
            if (n10 - n6 < rectangle.y) {
                bl = true;
                continue;
            }
            f = n9 - n7;
            f3 = n10 - n6 / n8;
            f2 = n9;
            f4 = n10 - n6;
            if (type == ConversationLine.Type.THOUGHT) {
                generalPath.quadTo(f, f3, f2, f4);
            } else if (type == ConversationLine.Type.YELL) {
                generalPath.lineTo(f, f3);
                generalPath.lineTo(f2, f4);
            }
            n10 -= n6;
        }
        f = rectangle.x - n7;
        f3 = rectangle.y;
        f2 = rectangle.x;
        f4 = rectangle.y;
        if (type == ConversationLine.Type.THOUGHT) {
            generalPath.quadTo(f, f3, f2, f4);
        } else if (type == ConversationLine.Type.YELL) {
            generalPath.lineTo(f, f3);
            generalPath.lineTo(f2, f4);
        }
        generalPath.closePath();
        return generalPath;
    }

    private static GeneralPath getNormalPath(Rectangle rectangle) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x + roundRadius, rectangle.y);
        generalPath.lineTo(rectangle.x + rectangle.width - roundRadius, rectangle.y);
        generalPath.quadTo(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + roundRadius);
        generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height - roundRadius);
        generalPath.quadTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width - roundRadius, rectangle.y + rectangle.height);
        generalPath.lineTo(rectangle.x + roundRadius, rectangle.y + rectangle.height);
        generalPath.quadTo(rectangle.x, rectangle.y + rectangle.height, rectangle.x, rectangle.height + rectangle.y - roundRadius);
        generalPath.lineTo(rectangle.x, rectangle.y + roundRadius);
        generalPath.quadTo(rectangle.x, rectangle.y, rectangle.x + roundRadius, rectangle.y);
        generalPath.closePath();
        return generalPath;
    }

    public static Stroke getStroke() {
        switch (type) {
            case WHISPER: {
                return new BasicStroke(1.0f, 1, 0, 5.0f, new float[]{5.0f}, 0.0f);
            }
            case YELL: {
                return new BasicStroke(2.0f);
            }
        }
        return new BasicStroke(1.0f);
    }

    public static AffineTransform getTransformation() {
        switch (type) {
            case WHISPER: {
                if (whisper == null) {
                    whisper = new AffineTransform();
                    whisper.translate(20.0, 0.0);
                    whisper.shear(-0.1f, 0.0);
                }
                return whisper;
            }
        }
        return normal;
    }

    public static Shape[] getArrow(int n, int n2) {
        switch (type) {
            case THOUGHT: {
                float f;
                float f2;
                float f3;
                float f4;
                switch (position) {
                    case WEST: {
                        f4 = (float)n - 40.0f;
                        f3 = n2 + linesHeight / 2;
                        f2 = (float)n - 20.0f;
                        f = n2 + linesHeight / 2;
                        break;
                    }
                    case EAST: {
                        f4 = (float)n + 40.0f;
                        f3 = n2 + linesHeight / 2;
                        f2 = (float)n + 20.0f;
                        f = n2 + linesHeight / 2;
                        break;
                    }
                    case SOUTH: {
                        f4 = n;
                        f3 = (float)n2 + 20.0f + (float)linesHeight;
                        f2 = n;
                        f = (float)n2 + 5.0f + (float)linesHeight;
                        break;
                    }
                    default: {
                        f4 = n;
                        f3 = (float)n2 + 25.0f;
                        f2 = n;
                        f = (float)n2 + 40.0f;
                    }
                }
                return new Shape[]{new Ellipse2D.Float(f4, f3, 12.0f, 12.0f), new Ellipse2D.Float(f2, f, 8.0f, 8.0f)};
            }
            case YELL: {
                GeneralPath generalPath = new GeneralPath();
                if (position == Position.NORTH) {
                    generalPath.moveTo(n - 20, n2 + 13);
                    generalPath.lineTo(n - 15, n2 + 45);
                    generalPath.lineTo(n - 7, n2 + 40);
                    generalPath.lineTo(n, n2 + 60);
                    generalPath.lineTo(n + 2, n2 + 25);
                    generalPath.lineTo(n - 5, n2 + 30);
                    generalPath.lineTo(n, n2 + 13);
                }
                return new Shape[]{generalPath};
            }
        }
        GeneralPath generalPath = new GeneralPath();
        switch (position) {
            case WEST: 
            case NORTH: {
                generalPath.moveTo(n - 15, n2 + 15);
                generalPath.lineTo(n - 3, n2 + 30);
                switch (position) {
                    case NORTH: {
                        generalPath.lineTo(n, n2 + 15);
                        break;
                    }
                    case WEST: {
                        generalPath.lineTo(n - 15, n2 + 32);
                        generalPath.transform(AffineTransform.getTranslateInstance(-30.0, 0.0));
                    }
                }
                break;
            }
            case EAST: {
                generalPath.moveTo(n - 15, n2 + 15);
                generalPath.lineTo(n - 27, n2 + 30);
                generalPath.lineTo(n - 15, n2 + 32);
                generalPath.transform(AffineTransform.getTranslateInstance(61.0, 0.0));
                break;
            }
            case SOUTH: {
                generalPath.moveTo(n - 15, n2 + 15);
                generalPath.lineTo(n - 3, n2 - 15);
                generalPath.lineTo(n, n2 + 15);
                generalPath.transform(AffineTransform.getTranslateInstance(0.0, 50 + linesHeight - 29));
            }
        }
        return new Shape[]{generalPath};
    }

    private static enum Position {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

