/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui;

import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Transition {
    private int totalTime;
    private int type;
    private long elapsedTime;
    private boolean started;
    private Image transitionImage;
    private static BufferedImage tempImage = new BufferedImage(800, 600, 6);

    public Transition(int n, int n2) {
        this.totalTime = n;
        this.type = n2;
        this.elapsedTime = 0L;
        this.started = false;
        this.transitionImage = new BufferedImage(800, 600, 6);
    }

    public boolean hasFinished(long l) {
        this.elapsedTime += l;
        return this.started && this.elapsedTime > (long)this.totalTime;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public Graphics getGraphics() {
        return this.transitionImage.getGraphics();
    }

    public void start(Graphics2D graphics2D) {
        this.started = true;
        graphics2D.drawImage(this.transitionImage, 0, 0, null);
        this.elapsedTime = 0L;
    }

    public void update(Graphics2D graphics2D) {
        if (tempImage == null || this.transitionImage == null || graphics2D == null) {
            this.elapsedTime = this.totalTime + 1;
            return;
        }
        if (this.started) {
            Graphics2D graphics2D2 = tempImage.createGraphics();
            GUI.getInstance().drawToGraphics(graphics2D2);
            graphics2D2.dispose();
            float f = (float)this.elapsedTime / (float)this.totalTime;
            if (this.type == 4) {
                float f2 = 800.0f * f;
                graphics2D.drawImage(this.transitionImage, (int)(-f2), 0, null);
                graphics2D.drawImage((Image)tempImage, (int)(800.0f - f2), 0, null);
            } else if (this.type == 3) {
                float f3 = 800.0f * f;
                graphics2D.drawImage(this.transitionImage, (int)f3, 0, null);
                graphics2D.drawImage((Image)tempImage, (int)(f3 - 800.0f), 0, null);
            } else if (this.type == 1) {
                float f4 = 600.0f * f;
                graphics2D.drawImage(this.transitionImage, 0, (int)f4, null);
                graphics2D.drawImage((Image)tempImage, 0, (int)(f4 - 600.0f), null);
            } else if (this.type == 2) {
                float f5 = 600.0f * f;
                graphics2D.drawImage(this.transitionImage, 0, (int)(-f5), null);
                graphics2D.drawImage((Image)tempImage, 0, (int)(600.0f - f5), null);
            } else if (this.type == 5) {
                graphics2D.drawImage((Image)tempImage, 0, 0, null);
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f - f);
                graphics2D.setComposite(alphaComposite);
                graphics2D.drawImage(this.transitionImage, 0, 0, null);
            }
        }
    }
}

