/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui;

import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.core.gui.hud.contextualhud.ContextualHUD;
import es.eucm.eadventure.engine.core.gui.hud.traditionalhud.TraditionalHUD;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GUIApplet
extends GUI {
    private static JApplet applet;

    @Override
    public Frame getJFrame() {
        return null;
    }

    public static void create() {
        instance = new GUIApplet();
    }

    @Override
    public void initGUI(int n, boolean bl) {
        this.gameFrame = new Canvas();
        this.background = null;
        this.elementsToDraw = new ArrayList();
        this.textToDraw = new ArrayList();
        this.gameFrame.setIgnoreRepaint(true);
        this.gameFrame.setFont(new Font("Dialog", 0, 18));
        Hashtable<TextAttribute, Float> hashtable = new Hashtable<TextAttribute, Float>();
        hashtable.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
        this.gameFrame.setFont(this.gameFrame.getFont().deriveFont(hashtable));
        this.gameFrame.setBackground(Color.black);
        this.gameFrame.setForeground(Color.white);
        this.gameFrame.setSize(new Dimension(800, 600));
        applet.getContentPane().add((Component)this.gameFrame, "Center");
        this.gameFrame.createBufferStrategy(2);
        if (n == 0) {
            this.hud = new TraditionalHUD();
        } else if (n == 1) {
            this.hud = new ContextualHUD();
        }
        this.gameFrame.setEnabled(true);
        this.gameFrame.setVisible(true);
        this.gameFrame.setFocusable(true);
        this.gameFrame.createBufferStrategy(2);
        this.gameFrame.validate();
        this.gameFrame.addFocusListener(this);
        this.gameFrame.requestFocusInWindow();
        this.hud.init();
        this.defaultCursor = Game.getInstance().getGameDescriptor().getCursorPath("default") != null ? Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(Game.getInstance().getGameDescriptor().getCursorPath("default"), 1), new Point(0, 0), "defaultCursor") : Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/default.png", 1), new Point(0, 0), "defaultCursor");
        this.gameFrame.setCursor(this.defaultCursor);
    }

    public static void delete() {
        instance = null;
    }

    @Override
    public void restoreFrame() {
        if (this.component != null) {
            applet.remove(this.component);
        }
        this.component = null;
        applet.setIgnoreRepaint(true);
        applet.repaint();
        this.gameFrame.setVisible(true);
        applet.validate();
    }

    @Override
    public JFrame showComponent(Component component) {
        this.gameFrame.setVisible(false);
        if (this.component != null) {
            applet.remove(this.component);
        }
        this.component = component;
        component.setBackground(Color.BLACK);
        component.setForeground(Color.BLACK);
        applet.add(component, "Center");
        applet.validate();
        component.repaint();
        return null;
    }

    public static void setApplet(JApplet jApplet) {
        applet = jApplet;
    }

    @Override
    public JFrame showComponent(Component component, int n, int n2) {
        this.gameFrame.setVisible(false);
        if (this.component != null) {
            applet.remove(this.component);
        }
        this.component = new JPanel();
        component.setBackground(Color.BLACK);
        component.setForeground(Color.BLACK);
        this.component.setBackground(Color.BLACK);
        this.component.setForeground(Color.BLACK);
        ((JPanel)this.component).setLayout(null);
        ((JPanel)this.component).add(component);
        int n3 = n;
        int n4 = n2;
        n = 800;
        n2 = 600;
        if (n3 / n4 >= n / n2) {
            n = 800;
            n2 = (int)((float)n4 / (float)n3 * 800.0f);
        } else {
            n2 = 600;
            n = (int)((float)n3 / (float)n4 * 600.0f);
        }
        int n5 = (800 - n) / 2;
        int n6 = (600 - n2) / 2;
        component.setBounds(n5, n6, n, n2);
        applet.add(component);
        applet.validate();
        component.repaint();
        return this.showComponent(component);
    }
}

