/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui;

import es.eucm.eadventure.engine.core.control.TimerManager;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalhighlights.FunctionalHighlight;
import es.eucm.eadventure.engine.core.gui.GUIApplet;
import es.eucm.eadventure.engine.core.gui.GUIFrame;
import es.eucm.eadventure.engine.core.gui.Transition;
import es.eucm.eadventure.engine.core.gui.ballonfactory.BallonFactory;
import es.eucm.eadventure.engine.core.gui.hud.HUD;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;

public abstract class GUI
implements FocusListener {
    public static final int GUI_APPLET = 1;
    public static final int GUI_FRAME = 0;
    protected static int GUIType = 0;
    public static final int WINDOW_WIDTH = 800;
    public static final int WINDOW_HEIGHT = 600;
    public static final int MAX_WIDTH_IN_TEXT = 300;
    public static final String DEFAULT_CURSOR = "default";
    public boolean ANTIALIASING = true;
    public boolean ANTIALIASING_TEXT = true;
    protected Canvas gameFrame;
    protected HUD hud;
    protected static int graphicConfig;
    protected static GUI instance;
    protected Cursor defaultCursor;
    protected SceneImage background;
    protected SceneImage foreground;
    protected ArrayList<ElementImage> elementsToDraw;
    protected ArrayList<Text> textToDraw;
    protected Component component;
    private Transition transition = null;
    private boolean showsOffsetArrows = false;
    private boolean moveOffsetRight = false;
    private boolean moveOffsetLeft = false;
    private List<FunctionalElement> elementsToInteract = null;
    private Image loadingImage;
    private int loading;
    private Timer loadingTimer;
    private TimerTask loadingTask;

    public static GUI getInstance() {
        if (instance == null) {
            GUI.create();
        }
        return instance;
    }

    public static void create() {
        instance = GUIType == 1 ? new GUIApplet() : new GUIFrame();
    }

    public static void delete() {
        if (instance instanceof GUIFrame) {
            GUIFrame.delete();
        }
        if (instance instanceof GUIApplet) {
            GUIApplet.delete();
        }
    }

    public abstract void initGUI(int var1, boolean var2);

    public abstract JFrame showComponent(Component var1);

    public abstract JFrame showComponent(Component var1, int var2, int var3);

    public abstract void restoreFrame();

    public int getGameAreaWidth() {
        return this.hud.getGameAreaWidth();
    }

    public int getGameAreaHeight() {
        return this.hud.getGameAreaHeight();
    }

    public void componentRepaint() {
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public int getResponseTextX() {
        return this.hud.getResponseTextX();
    }

    public int getResponseTextY() {
        return this.hud.getResponseTextY();
    }

    public int getResponseTextNumberLines() {
        return this.hud.getResponseTextNumberLines();
    }

    public static RenderingHints getOptimumRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return renderingHints;
    }

    public Graphics2D getGraphics() {
        BufferStrategy bufferStrategy = this.gameFrame.getBufferStrategy();
        Graphics2D graphics2D = (Graphics2D)bufferStrategy.getDrawGraphics();
        if (graphics2D != null) {
            if (this.ANTIALIASING && !graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_ANTIALIAS_ON)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (!this.ANTIALIASING && !graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_ANTIALIAS_OFF)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (this.ANTIALIASING_TEXT && !graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_TEXT_ANTIALIAS_ON)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (!this.ANTIALIASING_TEXT && !graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
        return graphics2D;
    }

    public void endDraw() {
        BufferStrategy bufferStrategy = this.gameFrame.getBufferStrategy();
        bufferStrategy.show();
        Toolkit.getDefaultToolkit().sync();
    }

    public void update(long l) {
        this.hud.update(l);
    }

    public Canvas getFrame() {
        return this.gameFrame;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.gameFrame.getGraphicsConfiguration();
    }

    public static void drawStringOnto(Graphics2D graphics2D, String string, int n, int n2, boolean bl, Color color, Color color2, boolean bl2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.stringWidth(string);
        double d2 = fontMetrics.getAscent();
        int n3 = n;
        int n4 = n2;
        if (bl) {
            if ((double)n3 + d / 2.0 > 800.0) {
                n3 = (int)(800.0 - d / 2.0);
            } else if ((double)n3 - d / 2.0 < 0.0) {
                n3 = (int)(d / 2.0);
            }
            n3 = (int)((double)n3 - d / 2.0);
            if (n4 > 600) {
                n4 = 600;
            } else if ((double)n4 - d2 < 0.0) {
                n4 = (int)d2;
            }
        } else {
            if ((double)n3 + d > 800.0) {
                n3 = 0;
                double d3 = fontMetrics.stringWidth(new String("A"));
                int n5 = (int)(800.0 / d3) + 18;
                string = string.substring(0, n5);
                string = string + "...";
            }
            if (n4 > 600) {
                n4 = 600;
            } else if ((double)n4 - d2 < 0.0) {
                n4 = (int)d2;
            }
        }
        if (bl2) {
            graphics2D.setColor(color2);
            graphics2D.drawString(string, n3 - 1, n4 - 1);
            graphics2D.drawString(string, n3 - 1, n4 + 1);
            graphics2D.drawString(string, n3 + 1, n4 - 1);
            graphics2D.drawString(string, n3 + 1, n4 + 1);
            graphics2D.setColor(color);
        }
        graphics2D.drawString(string, n3, n4);
    }

    public static void drawStringOnto(Graphics2D graphics2D, String[] stringArray, int n, int n2, Color color, Color color2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getHeight() * stringArray.length - fontMetrics.getLeading();
        int n4 = n2 - n3 + fontMetrics.getAscent();
        if (n4 < fontMetrics.getAscent()) {
            n4 = fontMetrics.getAscent();
        }
        for (String string : stringArray) {
            GUI.drawStringOnto(graphics2D, string, n, n4, true, color, color2, true);
            n4 += fontMetrics.getHeight();
        }
    }

    public static void drawStringOnto(Graphics2D graphics2D, String[] stringArray, int n, int n2, Color color, Color color2, Color color3, Color color4, boolean bl) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getHeight() * stringArray.length - fontMetrics.getLeading();
        int n4 = 25;
        for (String object2 : stringArray) {
            n4 = fontMetrics.stringWidth(object2) > n4 ? fontMetrics.stringWidth(object2) : n4;
        }
        int n5 = n;
        int n6 = n2;
        if (n5 - n4 / 2 < 0) {
            n5 = n4 / 2;
        }
        if (n6 - n3 < 0) {
            n6 = n3;
        }
        if (n5 + n4 / 2 > 800) {
            n5 = 800 - n4 / 2;
        }
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.8f);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(color3);
        graphics2D.fillRoundRect(n5 - n4 / 2 - 5, n6 - n3 - 5, n4 + 10, n3 + 10, 20, 20);
        graphics2D.setComposite(composite);
        graphics2D.setColor(color4);
        graphics2D.drawRoundRect(n5 - n4 / 2 - 5, n6 - n3 - 5, n4 + 10, n3 + 10, 20, 20);
        if (bl) {
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color3);
            int[] nArray = new int[]{n5 - 10, n5 + 10, n5};
            int[] nArray2 = new int[]{n6 + 5, n6 + 5, n6 + 15};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.setComposite(composite);
            graphics2D.setColor(color4);
            graphics2D.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
            graphics2D.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
        }
        GUI.drawStringOnto(graphics2D, stringArray, n, n2, color, color2);
    }

    public static void drawString(Graphics2D graphics2D, String string, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.stringWidth(string);
        double d2 = fontMetrics.getAscent();
        int n3 = n;
        int n4 = n2;
        if ((double)n3 + d / 2.0 > 800.0) {
            n3 = (int)(800.0 - d / 2.0);
        } else if ((double)n3 - d / 2.0 < 0.0) {
            n3 = (int)(d / 2.0);
        }
        n3 = (int)((double)n3 - d / 2.0);
        if ((double)n4 + d2 / 2.0 > 600.0) {
            n4 = (int)(600.0 - d2 / 2.0);
        } else if (n4 < 0) {
            n4 = 0;
        }
        n4 = (int)((double)n4 + d2 / 2.0);
        graphics2D.drawString(string, n3, n4);
    }

    public static void drawString(Graphics2D graphics2D, String[] stringArray, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getHeight() * stringArray.length - fontMetrics.getLeading() - fontMetrics.getDescent();
        int n4 = n2 - n3 / 2 + fontMetrics.getAscent() / 2;
        for (String string : stringArray) {
            GUI.drawString(graphics2D, string, n, n4);
            n4 += fontMetrics.getHeight();
        }
    }

    public String[] splitText(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        boolean bl = false;
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        do {
            String string3;
            int n;
            if ((n = fontMetrics.stringWidth(string2)) > 300) {
                int n2 = (int)Math.ceil((double)n / 300.0);
                int n3 = string2.lastIndexOf(32, string.length() / n2);
                if (n3 == -1) {
                    n3 = string2.indexOf(32);
                }
                if (n3 == -1) {
                    n3 = string2.length();
                    bl = true;
                }
                string3 = string2.substring(0, n3);
                string2 = string2.substring(n3).trim();
            } else {
                string3 = string2;
                bl = true;
            }
            arrayList.add(string3);
        } while (!bl);
        return arrayList.toArray(new String[1]);
    }

    public Color getColor(int n, int n2, int n3) {
        float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public void drawScene(Graphics2D graphics2D, long l) {
        if (this.transition != null && !this.transition.hasStarted()) {
            this.drawToGraphics((Graphics2D)this.transition.getGraphics());
            this.transition.start(this.getGraphics());
        } else if (graphics2D != null && (this.transition == null || this.transition.hasFinished(l))) {
            this.transition = null;
            this.drawToGraphics(graphics2D);
        } else if (graphics2D != null) {
            this.transition.update(graphics2D);
        }
    }

    private void recalculateInteractiveElementsOrder() {
        this.elementsToInteract = new ArrayList<FunctionalElement>();
        for (ElementImage elementImage : this.elementsToDraw) {
            if (elementImage.getFunctionalElement() == null) continue;
            this.elementsToInteract.add(elementImage.getFunctionalElement());
        }
    }

    public void drawToGraphics(Graphics2D graphics2D) {
        RenderingHints renderingHints = GUI.getOptimumRenderingHints();
        graphics2D.setRenderingHints(renderingHints);
        if (this.background != null) {
            this.background.draw(graphics2D);
        }
        Object object = this.elementsToDraw.iterator();
        while (object.hasNext()) {
            ElementImage elementImage = object.next();
            elementImage.draw(graphics2D);
        }
        this.recalculateInteractiveElementsOrder();
        this.elementsToDraw.clear();
        if (this.foreground != null) {
            this.foreground.draw(graphics2D);
            this.foreground = null;
        }
        if ((object = TimerManager.getInstance()) != null) {
            ((TimerManager)object).draw(graphics2D);
        }
        if (this.showsOffsetArrows) {
            graphics2D.setColor(Color.BLACK);
            int n = 300;
            Composite object2 = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            if (!this.moveOffsetLeft) {
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.fillOval(-30, n - 30, 60, 60);
            if (this.moveOffsetRight) {
                graphics2D.setComposite(object2);
            } else {
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.fillOval(770, n - 30, 60, 60);
            graphics2D.setComposite(object2);
            graphics2D.setColor(Color.WHITE);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(5.0f));
            graphics2D.drawLine(5, n, 15, n - 15);
            graphics2D.drawLine(5, n, 15, n + 15);
            graphics2D.drawLine(795, n, 785, n - 15);
            graphics2D.drawLine(795, n, 785, n + 15);
            graphics2D.setStroke(stroke);
        }
        for (Text text : this.textToDraw) {
            text.draw(graphics2D);
        }
        this.textToDraw.clear();
    }

    public void clearBackground() {
        this.background = null;
    }

    public void drawHUD(Graphics2D graphics2D) {
        this.hud.draw(graphics2D);
    }

    public void setCursor(Cursor cursor) {
        this.gameFrame.setCursor(cursor);
    }

    public void setDefaultCursor() {
        this.gameFrame.setCursor(this.defaultCursor);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.gameFrame.requestFocusInWindow();
    }

    public boolean mouseClickedInHud(MouseEvent mouseEvent) {
        return this.hud.mouseClicked(mouseEvent);
    }

    public boolean mouseMovedinHud(MouseEvent mouseEvent) {
        return this.hud.mouseMoved(mouseEvent);
    }

    public boolean keyInHud(KeyEvent keyEvent) {
        return this.hud.keyTyped(keyEvent);
    }

    public void newActionSelected() {
        this.hud.newActionSelected();
    }

    public void toggleHud(boolean bl) {
        this.hud.toggleHud(bl);
    }

    public void addBackgroundToDraw(Image image, int n) {
        this.background = new SceneImage(image, n);
    }

    public void addForegroundToDraw(Image image, int n) {
        this.foreground = new SceneImage(image, n);
    }

    public void addElementToDraw(Image image, int n, int n2, int n3, int n4, FunctionalHighlight functionalHighlight, FunctionalElement functionalElement) {
        boolean bl = false;
        ElementImage elementImage = new ElementImage(image, n, n2, n3, n4, functionalHighlight, functionalElement);
        for (int i = 0; !bl && i < this.elementsToDraw.size(); ++i) {
            if (n3 > this.elementsToDraw.get(i).getDepth()) continue;
            this.elementsToDraw.add(i, elementImage);
            bl = true;
        }
        if (!bl) {
            this.elementsToDraw.add(elementImage);
        }
    }

    public void addPlayerToDraw(Image image, int n, int n2, int n3, int n4) {
        boolean bl = false;
        ElementImage elementImage = new ElementImage(image, n, n2, n3, n4);
        for (int i = 0; !bl && i < this.elementsToDraw.size(); ++i) {
            if (n3 > this.elementsToDraw.get(i).getOriginalY()) continue;
            elementImage.setDepth(i);
            this.elementsToDraw.add(i, elementImage);
            bl = true;
        }
        if (!bl) {
            elementImage.setDepth(this.elementsToDraw.size() - 1);
            this.elementsToDraw.add(elementImage);
        }
    }

    public int getRealMinY(ElementImage elementImage, int n) {
        boolean bl = false;
        int n2 = elementImage.image.getWidth(null);
        int n3 = n - elementImage.x;
        int n4 = elementImage.originalY;
        if (n3 >= 0 && n3 < n2) {
            n4 = elementImage.image.getHeight(null) - 1;
            try {
                BufferedImage bufferedImage = (BufferedImage)elementImage.image;
                do {
                    int n5 = bufferedImage.getRGB(n3, n4) >>> 24;
                    boolean bl2 = bl = n5 > 128;
                } while (!bl && --n4 > 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n4;
    }

    public void addTextToDraw(String string, int n, int n2, Color color, Color color2) {
        boolean bl = false;
        if (!string.equals("")) {
            Text text = new Text(string, n, n2, color, color2);
            for (int i = 0; !bl && i < this.textToDraw.size(); ++i) {
                if (n2 > this.textToDraw.get(i).getY()) continue;
                this.textToDraw.add(i, text);
                bl = true;
            }
            if (!bl) {
                this.textToDraw.add(text);
            }
        }
    }

    public void addTextToDraw(String string, int n, int n2, Color color, Color color2, Color color3, Color color4, boolean bl) {
        boolean bl2 = false;
        if (!string.equals("")) {
            Text text = new Text(string, n, n2, color, color2, color3, color4, bl);
            for (int i = 0; !bl2 && i < this.textToDraw.size(); ++i) {
                if (n2 > this.textToDraw.get(i).getY()) continue;
                this.textToDraw.add(i, text);
                bl2 = true;
            }
            if (!bl2) {
                this.textToDraw.add(text);
            }
        }
    }

    public static void setGraphicConfig(int n) {
        graphicConfig = n;
    }

    public abstract Frame getJFrame();

    public static void setGUIType(int n) {
        GUIType = n;
    }

    public boolean mouseReleasedinHud(MouseEvent mouseEvent) {
        return this.hud.mouseReleased(mouseEvent);
    }

    public boolean mousePressedinHud(MouseEvent mouseEvent) {
        return this.hud.mousePressed(mouseEvent);
    }

    public boolean mouseDraggedinHud(MouseEvent mouseEvent) {
        return this.hud.mouseDragged(mouseEvent);
    }

    public void setTransition(int n, int n2, long l) {
        if (n > 0 && n2 > 0) {
            this.transition = new Transition(n, n2);
        }
    }

    public boolean hasTransition() {
        return this.transition != null && !this.transition.hasFinished(0L);
    }

    public void setShowsOffestArrows(boolean bl, boolean bl2, boolean bl3) {
        this.showsOffsetArrows = bl;
        this.moveOffsetRight = bl2;
        this.moveOffsetLeft = bl3;
    }

    public void setLastMouseMove(MouseEvent mouseEvent) {
        this.hud.setLastMouseMove(mouseEvent);
    }

    public void setDragElement(FunctionalElement functionalElement) {
    }

    public ArrayList<ElementImage> getElementsToDraw() {
        return this.elementsToDraw;
    }

    public List<FunctionalElement> getElementsToInteract() {
        return this.elementsToInteract;
    }

    public void loading(int n) {
        if (n == 0) {
            this.loadingImage = MultimediaManager.getInstance().loadImage("gui/loading.jpg", 1);
            if (this.loadingImage == null) {
                this.loadingImage = MultimediaManager.getInstance().loadImageFromZip("gui/loading.jpg", 1);
            }
            this.loading = n;
            this.loadingTimer = new Timer();
            this.loadingTask = new TimerTask(){
                private int cont = 20;
                private boolean contracting = false;

                @Override
                public void run() {
                    Graphics2D graphics2D = GUI.this.getGraphics();
                    graphics2D.drawImage(GUI.this.loadingImage, 0, 0, null);
                    graphics2D.setColor(new Color(250, 173, 6));
                    graphics2D.fillRoundRect(200, 300, GUI.this.loading * 4, 50, 10, 10);
                    graphics2D.setStroke(new BasicStroke(4.0f));
                    graphics2D.setColor(new Color(90, 32, 2));
                    graphics2D.drawRoundRect(200, 300, 400, 50, 10, 10);
                    graphics2D.setColor(new Color(247, 215, 105));
                    graphics2D.fillOval(400 - this.cont / 2, 100 - this.cont / 2, this.cont, this.cont);
                    if (!this.contracting) {
                        ++this.cont;
                        if (this.cont > 60) {
                            this.contracting = true;
                        }
                    } else {
                        --this.cont;
                        if (this.cont < 10) {
                            this.contracting = false;
                        }
                    }
                    GUI.this.endDraw();
                }
            };
            this.loadingTimer.scheduleAtFixedRate(this.loadingTask, 20L, 20L);
        }
        if (n == 100) {
            this.loadingTimer.cancel();
        }
        this.loading = n;
        Graphics2D graphics2D = this.getGraphics();
        graphics2D.drawImage(this.loadingImage, 0, 0, null);
        graphics2D.setColor(new Color(250, 173, 6));
        graphics2D.fillRoundRect(200, 300, this.loading * 4, 50, 10, 10);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.setColor(new Color(90, 32, 2));
        graphics2D.drawRoundRect(200, 300, 400, 50, 10, 10);
        this.endDraw();
    }

    static {
        instance = null;
    }

    protected class Text {
        private String text;
        private ArrayList<String> lines;
        private Shape bubbleShape;
        private Rectangle textBounds;
        private int x;
        private int y;
        private Color textColor;
        private Color borderColor;
        private Color bubbleBkgColor;
        private Color bubbleBorderColor;
        private boolean showArrow = true;
        private boolean showBubble = false;
        private Stroke stroke;
        private AffineTransform af;
        private Shape[] arrow;

        public Text(String string, int n, int n2, Color color, Color color2) {
            this.text = string;
            this.lines = null;
            this.x = n;
            this.y = n2;
            this.textColor = color;
            this.borderColor = color2;
            this.init();
        }

        public Text(String string, int n, int n2, Color color, Color color2, Color color3, Color color4, boolean bl) {
            this.text = string;
            this.lines = null;
            this.x = n;
            this.y = n2;
            this.textColor = color;
            this.borderColor = color2;
            this.showBubble = true;
            this.bubbleBkgColor = color3;
            this.bubbleBorderColor = color4;
            this.showArrow = bl;
            this.init();
        }

        private void init() {
            FontMetrics fontMetrics = GUI.getInstance().getGraphics().getFontMetrics();
            this.lines = BallonFactory.getLines(fontMetrics, this.text, 0.66f, 800);
            this.textBounds = BallonFactory.getTextBounds(this.x, this.y, 800, 600);
            this.bubbleShape = BallonFactory.getPath(this.textBounds, 20, 10);
            this.stroke = BallonFactory.getStroke();
            this.af = BallonFactory.getTransformation();
            this.arrow = BallonFactory.getArrow(this.x, this.y);
        }

        public void draw(Graphics2D graphics2D) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setTransform(this.af);
            if (this.showBubble) {
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.8f);
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(alphaComposite);
                graphics2D.setColor(this.bubbleBkgColor);
                graphics2D.fill(this.bubbleShape);
                graphics2D.setColor(this.bubbleBorderColor);
                Stroke object = graphics2D.getStroke();
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.bubbleShape);
                if (this.showArrow) {
                    graphics2D.setComposite(alphaComposite);
                    for (Shape shape : this.arrow) {
                        graphics2D.setColor(this.bubbleBkgColor);
                        graphics2D.fill(shape);
                        graphics2D.setColor(this.bubbleBorderColor);
                        graphics2D.draw(shape);
                    }
                    graphics2D.setComposite(composite);
                }
                graphics2D.setStroke(object);
                graphics2D.setComposite(composite);
            }
            int n = this.textBounds.y + graphics2D.getFontMetrics().getHeight() + BallonFactory.padding / 2;
            for (String string : this.lines) {
                int n2 = graphics2D.getFontMetrics().stringWidth(string);
                int n3 = this.textBounds.x + (this.textBounds.width - n2) / 2;
                graphics2D.setColor(this.borderColor);
                graphics2D.drawString(string, n3 - 1, n - 1);
                graphics2D.drawString(string, n3 - 1, n + 1);
                graphics2D.drawString(string, n3 + 1, n - 1);
                graphics2D.drawString(string, n3 + 1, n + 1);
                graphics2D.setColor(this.textColor);
                graphics2D.drawString(string, n3, n);
                n += graphics2D.getFontMetrics().getHeight() + BallonFactory.marginTop;
            }
            graphics2D.setTransform(affineTransform);
        }

        public int getY() {
            return this.y;
        }
    }

    protected class ElementImage {
        private Image image;
        private int x;
        private int y;
        private int originalY;
        private int depth;
        private FunctionalHighlight highlight;
        private FunctionalElement functionalElement;

        public ElementImage(Image image, int n, int n2, int n3, int n4) {
            this.image = image;
            this.x = n;
            this.y = n2;
            this.depth = n3;
            this.originalY = n4;
            this.highlight = null;
        }

        public ElementImage(Image image, int n, int n2, int n3, int n4, FunctionalHighlight functionalHighlight, FunctionalElement functionalElement) {
            this(image, n, n2, n3, n4);
            this.highlight = functionalHighlight;
            this.functionalElement = functionalElement;
        }

        public void draw(Graphics2D graphics2D) {
            if (this.highlight != null) {
                graphics2D.drawImage(this.highlight.getHighlightedImage(this.image), this.x + this.highlight.getDisplacementX(), this.y + this.highlight.getDisplacementY(), null);
            } else {
                graphics2D.drawImage(this.image, this.x, this.y, null);
            }
        }

        public int getDepth() {
            return this.depth;
        }

        public int getY() {
            return this.y;
        }

        public void setDepth(int n) {
            this.depth = n;
        }

        public int getOriginalY() {
            return this.originalY;
        }

        public FunctionalElement getFunctionalElement() {
            return this.functionalElement;
        }
    }

    protected class SceneImage {
        private Image background;
        private int offsetX;

        public SceneImage(Image image, int n) {
            this.background = image;
            this.offsetX = n;
        }

        public void draw(Graphics2D graphics2D) {
            graphics2D.drawImage(this.background, -this.offsetX, 0, null);
        }
    }
}

