/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.DebugTableModel;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.VarSummary;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class DebugValuesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FlagSummary flagSummary;
    private VarSummary varSummary;
    private List<GlobalState> globalStates;
    private JTable table;
    private DebugTableModel dtm;
    private DebugTableModel dtmChanges;
    private JTable changeTable;
    private JTable globalTable;
    private DefaultTableModel globalDtm;

    public DebugValuesPanel(FlagSummary flagSummary, VarSummary varSummary, List<GlobalState> list) {
        Object object2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width - 800, 600);
        this.setLocation(0, 0);
        this.setLayout(new BorderLayout());
        this.flagSummary = flagSummary;
        this.varSummary = varSummary;
        this.globalStates = list;
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.table = new JTable();
        this.dtm = new DebugTableModel(flagSummary, varSummary);
        this.table.setModel(this.dtm);
        this.table.setRowHeight(25);
        this.table.setDefaultRenderer(Object.class, this.dtm);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        jTabbedPane.addTab(TC.get((String)"DebugFrame.AllFlagsAndVars"), null, jScrollPane, TC.get((String)"DebugFrame.AllFlagsAndVarsTip"));
        this.globalTable = new JTable();
        this.globalDtm = new DefaultTableModel();
        Object[] objectArray = new String[]{TC.get((String)"DebugFrame.id"), TC.get((String)"DebugFrame.value")};
        this.globalDtm.setColumnIdentifiers(objectArray);
        for (Object object2 : list) {
            FunctionalConditions functionalConditions = new FunctionalConditions((Conditions)object2);
            Object[] objectArray2 = new String[]{object2.getId(), functionalConditions.allConditionsOk() ? "true" : "false"};
            this.globalDtm.addRow(objectArray2);
        }
        this.globalTable.setModel(this.globalDtm);
        this.globalTable.setRowHeight(25);
        this.globalTable.setDefaultRenderer(Object.class, this.dtm);
        JScrollPane jScrollPane2 = new JScrollPane(this.globalTable);
        this.globalTable.setFillsViewportHeight(true);
        jTabbedPane.addTab(TC.get((String)"DebugFrame.GlobalStates"), null, jScrollPane2, TC.get((String)"DebugFrame.GlobalStatesTip"));
        this.changeTable = new JTable();
        this.dtmChanges = new DebugTableModel(flagSummary, varSummary, true);
        this.dtmChanges.addGlobalStates(list);
        this.changeTable.setModel(this.dtmChanges);
        this.changeTable.setRowHeight(25);
        this.changeTable.setDefaultRenderer(Object.class, this.dtmChanges);
        object2 = new JScrollPane(this.changeTable);
        this.changeTable.setFillsViewportHeight(true);
        jTabbedPane.addTab(TC.get((String)"DebugFrame.Changes"), null, (Component)object2, TC.get((String)"DebugFrame.ChangesTip"));
        this.add((Component)jTabbedPane, "Center");
        this.setVisible(true);
    }

    public void setFlagSummary(FlagSummary flagSummary) {
        this.flagSummary = flagSummary;
    }

    public void setVarSummary(VarSummary varSummary) {
        this.varSummary = varSummary;
    }

    public void close() {
        this.setVisible(false);
    }

    public void updateValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.varSummary.getChanges());
        arrayList.addAll(this.flagSummary.getChanges());
        if (!arrayList.isEmpty()) {
            for (int i = 0; i < this.globalStates.size(); ++i) {
                FunctionalConditions functionalConditions = new FunctionalConditions((Conditions)this.globalStates.get(i));
                boolean bl = this.globalDtm.getValueAt(i, 1).equals("true");
                if (!(bl ^ functionalConditions.allConditionsOk())) continue;
                arrayList.add(this.globalStates.get(i).getId());
                this.globalDtm.setValueAt(!bl ? "true" : "false", i, 1);
            }
            this.dtmChanges.setChanges(arrayList);
            this.dtmChanges.fireTableStructureChanged();
            final Rectangle rectangle = this.table.getVisibleRect();
            this.dtm.setChanges(arrayList);
            this.dtm.fireTableStructureChanged();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugValuesPanel.this.table.scrollRectToVisible(rectangle);
                }
            });
            this.changeTable.setModel(this.dtmChanges);
        }
    }
}

