/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.DebugLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class DebugLogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DebugTable all;
    private DebugTable general;
    private DebugTable user;
    private DebugTable player;

    public DebugLogPanel() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width, dimension.height - 600 - 25);
        this.setLocation(0, 600);
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.all = new DebugTable();
        jTabbedPane.addTab(TC.get((String)"DebugFrameLog.All"), null, this.all.getScrollPane(), TC.get((String)"DebugFrameLog.AllTip"));
        this.user = new DebugTable();
        jTabbedPane.addTab(TC.get((String)"DebugFrameLog.User"), null, this.user.getScrollPane(), TC.get((String)"DebugFrameLog.UserTip"));
        this.player = new DebugTable();
        jTabbedPane.addTab(TC.get((String)"DebugFrameLog.Player"), null, this.player.getScrollPane(), TC.get((String)"DebugFrameLog.PlayerTip"));
        this.general = new DebugTable();
        jTabbedPane.addTab(TC.get((String)"DebugFrameLog.General"), null, this.general.getScrollPane(), TC.get((String)"DebugFrameLog.General"));
        this.add((Component)jTabbedPane, "Center");
        DebugLog.getInstance().setDebugFrameLog(this);
        this.setVisible(true);
    }

    public void addLine(int n, String string, String string2) {
        try {
            this.all.addLine(string, string2);
            if (n == 2) {
                this.player.addLine(string, string2);
            }
            if (n == 0) {
                this.general.addLine(string, string2);
            }
            if (n == 1) {
                this.user.addLine(string, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.setVisible(false);
        DebugLog.getInstance().clear();
    }

    private class DebugTable {
        private JTable table = new JTable();
        private DefaultTableModel dtm = new DefaultTableModel();
        private JScrollPane scrollPane;

        public DebugTable() {
            this.dtm.setColumnCount(2);
            Object[] objectArray = new String[]{TC.get((String)"DebugFrameLog.Time"), TC.get((String)"DebugFrameLog.Entry")};
            this.dtm.setColumnIdentifiers(objectArray);
            this.table.setModel(this.dtm);
            this.table.getColumnModel().getColumn(0).setMaxWidth(80);
            this.scrollPane = new JScrollPane(this.table);
            this.table.setFillsViewportHeight(true);
        }

        public JScrollPane getScrollPane() {
            return this.scrollPane;
        }

        public void addLine(String string, String string2) {
            Object[] objectArray = new String[]{string, string2};
            this.dtm.addRow(objectArray);
            this.dtm.fireTableDataChanged();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rectangle rectangle = DebugTable.this.table.getCellRect(DebugTable.this.table.getRowCount() - 1, 0, true);
                    DebugTable.this.table.scrollRectToVisible(rectangle);
                }
            });
        }
    }
}

