/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.data;

import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.ItemSummary;
import es.eucm.eadventure.engine.core.control.TimerManager;
import es.eucm.eadventure.engine.core.control.VarSummary;
import es.eucm.eadventure.engine.core.data.SaveGameException;
import es.eucm.eadventure.engine.core.data.SaveTimer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;

public class SaveGame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NUMBEROFCHECKMARKS = 10;
    private static final String TITLEMARK = "TITLE#";
    private static final String CHAPTERMARK = "CHAPTER#";
    private static final String TOTALTIMEMARK = "TOTALTIME#";
    private static final String SAVETIMEMARK = "SAVETIME#";
    private static final String IDSCENEMARK = "IDSCENE#";
    private static final String FLAGSMARK = "ACTIVEFLAGS#";
    private static final String VARMARK = "VAR#";
    private static final String ITEMSMARK = "ITEMS#";
    private static final String PLAYERPOSMARK = "PLAYERPOS#";
    private static final String TIMERSMARK = "TIMER#";
    private static final String VERSIONNUMBERMARK = "VERSIONNUMBER#";
    private SaveGameData saveGameData = new SaveGameData();
    private boolean[] check = new boolean[10];

    public boolean existSaveFile(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.saveGameData = new SaveGameData();
            String string2 = bufferedReader.readLine().trim();
            if (VERSIONNUMBERMARK.equals(string2.split("#")[0] + "#")) {
                this.saveGameData.versionNumber = Integer.parseInt(string2.split("#")[1].split("&")[0]);
                this.saveGameData.projectName = string2.split("#")[1].split("&")[1];
                string2 = bufferedReader.readLine().trim().split("#")[1].split("&")[0];
            } else {
                string2 = string2.split("#")[1].split("&")[0];
            }
            this.saveGameData.title = string2;
            string2 = bufferedReader.readLine().trim();
            string2 = bufferedReader.readLine().trim().split("#")[1].split("&")[0];
            this.saveGameData.saveTime = string2;
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void initializeCheck() {
        for (int i = 0; i < 10; ++i) {
            this.check[i] = false;
        }
    }

    public boolean loadTxt(String string) throws SaveGameException {
        boolean bl = true;
        boolean bl2 = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.saveGameData = new SaveGameData();
            this.initializeCheck();
            while (!bl2) {
                String string2 = bufferedReader.readLine().trim();
                if (!string2.isEmpty()) {
                    String[] stringArray = string2.split("#");
                    this.analyzeString(stringArray);
                    continue;
                }
                bl2 = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        catch (NullPointerException nullPointerException) {
            this.check();
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private void check() throws SaveGameException {
        for (int i = 0; i < 10; ++i) {
            if (this.check[i]) continue;
            throw new SaveGameException("Error loading");
        }
    }

    private void analyzeString(String[] stringArray) throws SaveGameException, NumberFormatException {
        String string = stringArray[0];
        string = string + "#";
        if (stringArray.length == 2 && stringArray[1].contains("&")) {
            if (string.equals(TITLEMARK)) {
                this.saveGameData.title = stringArray[1].split("&")[0];
                this.check[0] = true;
            } else if (string.equals(CHAPTERMARK)) {
                this.saveGameData.chapter = Integer.parseInt(stringArray[1].split("&")[0]);
                this.check[1] = true;
            } else if (string.equals(TOTALTIMEMARK)) {
                this.saveGameData.totalTime = Long.parseLong(stringArray[1].split("&")[0]);
                this.check[2] = true;
            } else if (string.equals(SAVETIMEMARK)) {
                this.saveGameData.saveTime = stringArray[1].split("&")[0];
                this.check[3] = true;
            } else if (string.equals(IDSCENEMARK)) {
                this.saveGameData.idScene = stringArray[1].split("&")[0];
                this.check[4] = true;
            } else if (string.equals(FLAGSMARK)) {
                this.analiceFlags(stringArray[1]);
                this.check[5] = true;
            } else if (string.equals(VARMARK)) {
                this.analiceVars(stringArray[1]);
                this.check[6] = true;
            } else if (string.equals(ITEMSMARK)) {
                this.analyzeItems(stringArray[1]);
                this.check[7] = true;
            } else if (string.equals(PLAYERPOSMARK)) {
                this.saveGameData.playerX = Float.parseFloat(stringArray[1].split(";")[0]);
                this.saveGameData.playerY = Float.parseFloat(stringArray[1].split(";")[1].split("&")[0]);
                this.check[8] = true;
            } else if (string.equals(TIMERSMARK)) {
                String[] stringArray2 = stringArray[1].split("&");
                if (stringArray2.length != 0) {
                    stringArray[1] = stringArray2[0];
                    SaveGameData.access$1002(this.saveGameData, stringArray[1].split(";"));
                }
                this.check[9] = true;
            } else if (string.equals(VERSIONNUMBERMARK)) {
                String[] stringArray3 = stringArray[1].split("&");
                this.saveGameData.versionNumber = Integer.parseInt(stringArray3[0]);
                this.saveGameData.projectName = stringArray3[1];
            }
        }
    }

    private void analiceFlags(String string) {
        int n;
        String[] stringArray = new String[]{""};
        String[] stringArray2 = string.split("&");
        String[] stringArray3 = stringArray2[0].split(";");
        if (stringArray2.length > 1) {
            stringArray = stringArray2[1].split(";");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray3.length; ++n) {
            if (stringArray3[n].trim().equals("")) continue;
            arrayList.add(stringArray3[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].trim().equals("")) continue;
            arrayList.add(stringArray[n]);
        }
        this.saveGameData.flags = new FlagSummary(arrayList, false);
        for (n = 0; n < stringArray3.length; ++n) {
            if (stringArray3[n].trim().equals("")) continue;
            this.saveGameData.flags.activateFlag(stringArray3[n]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analiceVars(String string) throws SaveGameException {
        int n;
        String[] stringArray = string.split("&");
        if (stringArray.length == 0) return;
        String[] stringArray2 = stringArray[0].split(";");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray2) {
            arrayList.add(string2);
        }
        if (stringArray.length <= 1) throw new SaveGameException("Corrupted load file");
        String[] stringArray3 = stringArray[1].split(";");
        int[] nArray = new int[stringArray3.length];
        for (n = 0; n < stringArray3.length; ++n) {
            nArray[n] = Integer.parseInt(stringArray3[n]);
        }
        this.saveGameData.vars = new VarSummary(arrayList, false);
        if (stringArray3.length != stringArray2.length) throw new SaveGameException("Corrupted load file");
        for (n = 0; n < stringArray2.length; ++n) {
            this.saveGameData.vars.setVarValue(stringArray2[n], nArray[n]);
        }
    }

    private void analyzeItems(String string) {
        int n;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        stringArray[0] = "";
        stringArray3[0] = "";
        stringArray2[0] = "";
        String[] stringArray4 = string.split("&");
        if (stringArray4.length >= 1) {
            stringArray = stringArray4[0].split(";");
        }
        if (stringArray4.length >= 2) {
            stringArray2 = stringArray4[1].split(";");
        }
        if (stringArray4.length >= 3) {
            stringArray3 = stringArray4[2].split(";");
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].trim().equals("")) continue;
            arrayList.add(new Item(stringArray[n]));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray2[n].trim().equals("")) continue;
            arrayList.add(new Item(stringArray2[n]));
        }
        for (n = 0; n < stringArray3.length; ++n) {
            if (stringArray3[n].trim().equals("")) continue;
            arrayList.add(new Item(stringArray3[n]));
        }
        this.saveGameData.itemSummary = new ItemSummary(arrayList);
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray2[n].trim().equals("")) continue;
            this.saveGameData.itemSummary.consumeItem(stringArray2[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            if (stringArray3[n].trim().equals("")) continue;
            this.saveGameData.itemSummary.grabItem(stringArray3[n]);
        }
    }

    public boolean saveTxt(String string) {
        boolean bl = true;
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println(VERSIONNUMBERMARK + this.saveGameData.versionNumber + "&" + this.saveGameData.projectName + "&");
            printStream.println(TITLEMARK + this.saveGameData.title + "&");
            printStream.println(CHAPTERMARK + this.saveGameData.chapter + "&");
            printStream.println(SAVETIMEMARK + this.saveGameData.saveTime + "&");
            printStream.println(TOTALTIMEMARK + this.saveGameData.totalTime + "&");
            printStream.println(IDSCENEMARK + this.saveGameData.idScene + "&");
            printStream.println(PLAYERPOSMARK + this.saveGameData.playerX + ";" + this.saveGameData.playerY + "&");
            printStream.print(ITEMSMARK);
            for (String string2 : this.saveGameData.itemSummary.getNormalItems()) {
                printStream.print(string2 + ";");
            }
            printStream.print("&");
            for (String string2 : this.saveGameData.itemSummary.getConsumedItems()) {
                printStream.print(string2 + ";");
            }
            printStream.print("&");
            for (String string2 : this.saveGameData.itemSummary.getGrabbedItems()) {
                printStream.print(string2 + ";");
            }
            printStream.println();
            printStream.print(FLAGSMARK);
            for (String string2 : this.saveGameData.flags.getActiveFlags()) {
                printStream.print(string2 + ";");
            }
            printStream.print("&");
            for (String string2 : this.saveGameData.flags.getInactiveFlags()) {
                printStream.print(string2 + ";");
            }
            printStream.println();
            printStream.print(VARMARK);
            for (String object : this.saveGameData.vars.getVarNames()) {
                printStream.print(object + ";");
            }
            printStream.print("&");
            for (String string2 : this.saveGameData.vars.getVarValues()) {
                printStream.print(string2 + ";");
            }
            printStream.println();
            printStream.print(TIMERSMARK);
            long l = System.currentTimeMillis();
            for (SaveTimer saveTimer : this.saveGameData.timers.getTimers()) {
                boolean bl2 = saveTimer.isAssessmentRule();
                printStream.print(saveTimer.getState() + "-");
                if (bl2) {
                    printStream.print("assess-");
                } else {
                    printStream.print(saveTimer.getTimeUpdate() + "-");
                }
                printStream.print(l / 1000L - saveTimer.getLastUpdate() + "-");
                if (bl2) {
                    printStream.print("0;");
                    continue;
                }
                printStream.print("1;");
            }
            printStream.print("&");
            printStream.println();
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public FlagSummary getFlags() {
        return this.saveGameData.flags;
    }

    public VarSummary getVars() {
        return this.saveGameData.vars;
    }

    public void setFlags(FlagSummary flagSummary) {
        this.saveGameData.flags = flagSummary;
    }

    public void setVars(VarSummary varSummary) {
        this.saveGameData.vars = varSummary;
    }

    public String getIdScene() {
        return this.saveGameData.idScene;
    }

    public void setIdScene(String string) {
        this.saveGameData.idScene = string;
    }

    public ItemSummary getItemSummary() {
        return this.saveGameData.itemSummary;
    }

    public void setItemSummary(ItemSummary itemSummary) {
        this.saveGameData.itemSummary = itemSummary;
    }

    public float getPlayerX() {
        return this.saveGameData.playerX;
    }

    public void setPlayerX(float f) {
        this.saveGameData.playerX = f;
    }

    public float getPlayerY() {
        return this.saveGameData.playerY;
    }

    public void setPlayerY(float f) {
        this.saveGameData.playerY = f;
    }

    public String getTitle() {
        return this.saveGameData.title;
    }

    public void setTitle(String string) {
        this.saveGameData.title = string;
    }

    public String getSaveTime() {
        return this.saveGameData.saveTime;
    }

    public void setSaveTime(String string) {
        this.saveGameData.saveTime = string;
    }

    public long getTotalTime() {
        return this.saveGameData.totalTime;
    }

    public void setTotalTime(long l) {
        this.saveGameData.totalTime = l;
    }

    public int getChapter() {
        return this.saveGameData.chapter;
    }

    public void setChapter(int n) {
        this.saveGameData.chapter = n;
    }

    public void setTimers(TimerManager timerManager) {
        this.saveGameData.timers = timerManager;
    }

    public String[] getLoadTimers() {
        return this.saveGameData.loadTimers;
    }

    public int getVersionNumber() {
        return this.saveGameData.versionNumber;
    }

    public void setVersionNumber(int n) {
        this.saveGameData.versionNumber = n;
    }

    public void setProjectName(String string) {
        this.saveGameData.projectName = string;
    }

    public String getProjectName() {
        return this.saveGameData.projectName;
    }

    private class SaveGameData {
        private int versionNumber;
        private String projectName;
        private String title;
        private int chapter;
        private long totalTime;
        private String saveTime;
        private String idScene;
        private FlagSummary flags;
        private VarSummary vars;
        private ItemSummary itemSummary;
        private float playerX;
        private float playerY;
        private TimerManager timers;
        private String[] loadTimers;

        private SaveGameData() {
        }

        static /* synthetic */ String[] access$1002(SaveGameData saveGameData, String[] stringArray) {
            saveGameData.loadTimers = stringArray;
            return stringArray;
        }
    }
}

