/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Videoscene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.InputStreamDataSource;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.media.protocol.DataSource;
import javax.swing.JOptionPane;

public class GameStateVideoscene
extends GameState
implements ControllerListener {
    private Videoscene videoscene;
    private Player mediaPlayer;
    private boolean stop;
    private Component video;
    private boolean prefetched;
    private InputStreamDataSource ds;

    public GameStateVideoscene() {
        this.videoscene = (Videoscene)this.game.getCurrentChapterData().getGeneralScene(this.game.getNextScene().getNextSceneId());
        this.stop = true;
        this.prefetched = false;
        try {
            Resources resources = this.createResourcesBlock();
            Runtime.getRuntime().gc();
            System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
            if (Runtime.getRuntime().freeMemory() < 20000000L) {
                Graphics2D graphics2D = GUI.getInstance().getGraphics();
                graphics2D.clearRect(0, 0, 800, 600);
                GUI.drawString(graphics2D, "Appology from <e-Adventure>", 400, 280);
                GUI.drawString(graphics2D, "Sorry, there is not enough memory to show the video", 400, 300);
                GUI.getInstance().endDraw();
                graphics2D.dispose();
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Interrupted while waiting on realize...exiting.");
                    System.exit(1);
                }
                throw new Exception("Not enough memory");
            }
            Graphics2D graphics2D = GUI.getInstance().getGraphics();
            graphics2D.clearRect(0, 0, 800, 600);
            GUI.drawString(graphics2D, "Please wait", 400, 280);
            GUI.drawString(graphics2D, "Loading ...", 400, 300);
            GUI.getInstance().endDraw();
            graphics2D.dispose();
            this.ds = new InputStreamDataSource(resources.getAssetPath("video"));
            this.ds.connect();
            Manager.setHint((int)3, (Object)true);
            this.mediaPlayer = Manager.createRealizedPlayer((DataSource)this.ds);
            this.mediaPlayer.addControllerListener((ControllerListener)this);
            this.blockingPrefetch();
            this.video = this.mediaPlayer.getVisualComponent();
            int n = this.video.getPreferredSize().width;
            int n2 = this.video.getPreferredSize().height - 14;
            if (this.video != null) {
                this.video.addMouseListener(Game.getInstance());
                if (n > 0 && n2 > 0) {
                    GUI.getInstance().showComponent(this.video, n, n2);
                } else {
                    GUI.getInstance().showComponent(this.video);
                }
                this.stop = false;
                this.mediaPlayer.start();
            }
        }
        catch (Exception exception) {
            this.loadNextScene();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.loadNextScene();
        }
    }

    private void loadNextScene() {
        if (this.video != null) {
            this.mediaPlayer.stop();
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.close();
            this.mediaPlayer.deallocate();
            this.mediaPlayer = null;
        }
        if (this.ds != null) {
            this.ds.disconnect();
            this.ds = null;
        }
        System.gc();
        GUI.getInstance().getFrame().createBufferStrategy(2);
        GUI.getInstance().getFrame().validate();
        GUI.getInstance().restoreFrame();
        if (this.videoscene.getNext() == 1) {
            this.game.goToNextChapter();
        } else if (this.videoscene.getNext() == 2) {
            Exit exit = new Exit(this.videoscene.getTargetId());
            exit.setDestinyX(this.videoscene.getPositionX());
            exit.setDestinyY(this.videoscene.getPositionY());
            exit.setPostEffects(this.videoscene.getEffects());
            exit.setTransitionTime(this.videoscene.getTransitionTime());
            exit.setTransitionType(this.videoscene.getTransitionType());
            this.game.setNextScene(exit);
            this.game.setState(3);
        } else {
            if (this.game.getFunctionalScene() == null) {
                JOptionPane.showMessageDialog(null, TC.get((String)"DesignError.Message"), TC.get((String)"DesignError.Title"), 0);
                this.game.goToNextChapter();
            }
            FunctionalEffects.storeAllEffects(new Effects());
        }
    }

    @Override
    public void mainLoop(long l, int n) {
        if (this.stop) {
            this.loadNextScene();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.stop = true;
    }

    public synchronized void blockingPrefetch() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.prefetch();
            while (!this.prefetched) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Interrupted while waiting on realize...exiting.");
                    System.exit(1);
                }
            }
        }
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            System.out.println("RealizeCompleteEvent");
            this.notify();
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            System.out.println("EndOfMediaEvent");
            this.loadNextScene();
        } else if (controllerEvent instanceof StopEvent) {
            System.out.println("StopEvent");
            this.notify();
        } else if (controllerEvent instanceof PrefetchCompleteEvent) {
            System.out.println("PrefetchCompleteEvent");
            this.prefetched = true;
            this.notify();
        }
    }

    public Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.videoscene.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)this.videoscene.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)this.videoscene.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
        }
        return resources;
    }
}

