/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalMoveObjectEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalPlayAnimationEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalRandomEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalShowTextEffect;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

public class GameStateRunEffects
extends GameState {
    private FunctionalEffect currentExecutingEffect = null;
    private boolean fromConversation;
    private int mouseClickedButton = 0;

    public GameStateRunEffects(boolean bl) {
        this.fromConversation = bl;
    }

    @Override
    public void mainLoop(long l, int n) {
        this.game.getActionManager().setElementOver(null);
        this.game.getActionManager().setExitCustomized(null, null);
        GUI.getInstance().toggleHud(false);
        GUI.getInstance().setDefaultCursor();
        if (this.game.getFunctionalScene() != null) {
            this.game.getFunctionalScene().update(l);
        }
        GUI.getInstance().update(l);
        Graphics2D graphics2D = GUI.getInstance().getGraphics();
        graphics2D.clearRect(0, 0, 800, 600);
        if (this.game.getFunctionalScene() != null) {
            this.game.getFunctionalScene().draw();
        }
        if (this.currentExecutingEffect instanceof FunctionalShowTextEffect) {
            ((FunctionalShowTextEffect)this.currentExecutingEffect).draw();
        }
        if (this.currentExecutingEffect instanceof FunctionalRandomEffect && this.currentExecutingEffect.getTriggerEffect() instanceof FunctionalShowTextEffect) {
            ((FunctionalShowTextEffect)this.currentExecutingEffect.getTriggerEffect()).draw();
        }
        GUI.getInstance().drawScene(graphics2D, l);
        GUI.getInstance().drawHUD(graphics2D);
        if (this.currentExecutingEffect == null || !this.currentExecutingEffect.isStillRunning()) {
            this.currentExecutingEffect = null;
            boolean bl = false;
            while (!bl) {
                FunctionalEffect functionalEffect = this.game.getFirstElementOfTop();
                if (functionalEffect == null) {
                    System.gc();
                    GUI.getInstance().toggleHud(true);
                    bl = true;
                    this.game.evaluateState();
                    continue;
                }
                if (!functionalEffect.isAllConditionsOK()) continue;
                functionalEffect.triggerEffect();
                bl = !functionalEffect.isInstantaneous();
                if (!bl) continue;
                this.currentExecutingEffect = functionalEffect;
            }
        } else if (this.currentExecutingEffect != null && this.currentExecutingEffect.isStillRunning()) {
            if ((this.mouseClickedButton == 1 || this.mouseClickedButton == 3) && this.currentExecutingEffect.canSkip()) {
                System.out.println("!!!!! SKIPPING :" + this.currentExecutingEffect.getClass().getName());
                this.currentExecutingEffect.skip();
            }
            if (this.currentExecutingEffect instanceof FunctionalRandomEffect && this.currentExecutingEffect.getTriggerEffect() instanceof FunctionalPlayAnimationEffect) {
                ((FunctionalPlayAnimationEffect)this.currentExecutingEffect.getTriggerEffect()).draw(graphics2D);
                ((FunctionalPlayAnimationEffect)this.currentExecutingEffect.getTriggerEffect()).update(l);
            }
            if (this.currentExecutingEffect instanceof FunctionalPlayAnimationEffect) {
                ((FunctionalPlayAnimationEffect)this.currentExecutingEffect).draw(graphics2D);
                ((FunctionalPlayAnimationEffect)this.currentExecutingEffect).update(l);
            }
            if (this.currentExecutingEffect instanceof FunctionalMoveObjectEffect) {
                ((FunctionalMoveObjectEffect)this.currentExecutingEffect).update(l);
            }
        }
        this.mouseClickedButton = 0;
        GUI.getInstance().endDraw();
        graphics2D.dispose();
    }

    @Override
    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClickedButton = 0;
        if (mouseEvent.getButton() == 1) {
            this.mouseClickedButton = 1;
        } else if (mouseEvent.getButton() == 3) {
            this.mouseClickedButton = 3;
        }
    }
}

