/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GameStatePlaying
extends GameState {
    private Queue<MouseEvent> vMouse = new ConcurrentLinkedQueue<MouseEvent>();

    @Override
    public synchronized void mainLoop(long l, int n) {
        MouseEvent mouseEvent;
        while ((mouseEvent = this.vMouse.poll()) != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this.mouseClickedEvent(mouseEvent);
                    break;
                }
                case 503: {
                    this.mouseMovedEvent(mouseEvent);
                    break;
                }
                case 501: {
                    this.mousePressedEvent(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseReleasedEvent(mouseEvent);
                    break;
                }
                case 506: {
                    this.mouseMovedEvent(mouseEvent);
                }
            }
        }
        this.game.getFunctionalScene().update(l);
        GUI.getInstance().update(l);
        Graphics2D graphics2D = GUI.getInstance().getGraphics();
        this.game.getFunctionalScene().draw();
        GUI.getInstance().drawScene(graphics2D, l);
        GUI.getInstance().drawHUD(graphics2D);
        if (this.game.getAdaptedStateToExecute() != null) {
            Object object2;
            if (this.game.getAdaptedStateToExecute().getTargetId() != null && this.game.getCurrentChapterData().getScenes().contains(this.game.getAdaptedStateToExecute().getTargetId())) {
                this.game.setNextScene(new Exit(this.game.getAdaptedStateToExecute().getTargetId()));
                this.game.setState(3);
                this.game.flushEffectsQueue();
            }
            for (Object object2 : this.game.getAdaptedStateToExecute().getActivatedFlags()) {
                if (!this.game.getFlags().existFlag((String)object2)) continue;
                this.game.getFlags().activateFlag((String)object2);
            }
            for (Object object2 : this.game.getAdaptedStateToExecute().getDeactivatedFlags()) {
                if (!this.game.getFlags().existFlag((String)object2)) continue;
                this.game.getFlags().deactivateFlag((String)object2);
            }
            ArrayList arrayList = new ArrayList();
            object2 = new ArrayList();
            this.game.getAdaptedStateToExecute().getVarsValues((List)arrayList, (List)object2);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                String string2 = (String)object2.get(i);
                if (AdaptedState.isSetValueOp((String)string2)) {
                    String string3 = AdaptedState.getSetValueData((String)string2);
                    if (string3 == null) continue;
                    this.game.getVars().setVarValue(string, Integer.parseInt(string3));
                    continue;
                }
                if (!this.game.getVars().existVar(string)) continue;
                int n2 = this.game.getVars().getValue(string);
                if (AdaptedState.isIncrementOp((String)string2)) {
                    this.game.getVars().setVarValue(string, n2 + 1);
                    continue;
                }
                if (!AdaptedState.isDecrementOp((String)string2)) continue;
                this.game.getVars().setVarValue(string, n2 - 1);
            }
        }
        this.game.updateDataPendingFromState(true);
        GUI.getInstance().endDraw();
        graphics2D.dispose();
    }

    @Override
    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        this.vMouse.add(mouseEvent);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        this.vMouse.add(mouseEvent);
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.vMouse.add(mouseEvent);
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.vMouse.add(mouseEvent);
    }

    @Override
    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        this.vMouse.add(mouseEvent);
    }

    public void mouseClickedEvent(MouseEvent mouseEvent) {
        if (!GUI.getInstance().mouseClickedInHud(mouseEvent)) {
            this.game.getActionManager().mouseClicked(mouseEvent);
        }
    }

    public void mouseMovedEvent(MouseEvent mouseEvent) {
        this.game.getActionManager().setExitCustomized(null, null);
        this.game.getActionManager().setElementOver(null);
        if (!GUI.getInstance().mouseMovedinHud(mouseEvent)) {
            this.game.getActionManager().mouseMoved(mouseEvent);
        }
    }

    private void mouseReleasedEvent(MouseEvent mouseEvent) {
        GUI.getInstance().mouseReleasedinHud(mouseEvent);
    }

    private void mousePressedEvent(MouseEvent mouseEvent) {
        GUI.getInstance().mousePressedinHud(mouseEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                if (GUI.getInstance().keyInHud(keyEvent)) break;
                this.game.setState(8);
            }
        }
    }
}

