/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.auxiliar.CreateImage;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.Options;
import es.eucm.eadventure.engine.core.control.config.ConfigData;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.core.data.SaveGame;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class GameStateOptions
extends GameState {
    private final int GAME_AREA_WIDTH;
    private final int GAME_AREA_HEIGHT;
    private static final float FONT_SIZE = 23.0f;
    private static final float FONT_SIZE_SAVEGAME = 17.0f;
    private static final int FIRST_BUTTON_OFFSET_X = 5;
    private static final int FIRST_BUTTON_OFFSET_Y = 55;
    private static final int BUTTON_WIDTH = 190;
    private static final int BUTTON_HEIGHT = 48;
    private static final int NUMBER_OF_PANELS = 5;
    private static final int OPTIONS_PANEL = 0;
    private static final int SAVELOAD_PANEL = 1;
    private static final int SAVE_PANEL = 2;
    private static final int LOAD_PANEL = 3;
    private static final int CONFIGURATION_PANEL = 4;
    private static final int[] NUMBER_OPTIONS_OF_PANEL = new int[]{5, 3, 5, 5, 4};
    private static final int MAX_NUM_SAVEGAME_SLOTS = 4;
    private static final Color NORMAL_COLOR = new Color(157, 157, 157);
    private static final Color HIGHLIGHTED_COLOR = Color.WHITE;
    private Image[] imgPanel;
    private Image imgButton;
    private Image imgPressedButton;
    private Font optionsFont;
    private Font savegameFont;
    private Options options = this.game.getOptions();
    private BufferedImage gameImage = null;
    private Point panelPosition;
    private int currentPanel = 0;
    private int highlightedOption = -1;
    private int pressedOption = -1;
    private boolean mouseButtonPressed = false;
    private SaveGame[] saveGames;
    private boolean[] existsSaveGame;
    private boolean loadGame = false;
    private int slotGame = -1;
    private boolean mouseDragged = false;

    public GameStateOptions() {
        this.GAME_AREA_WIDTH = GUI.getInstance().getGameAreaWidth();
        this.GAME_AREA_HEIGHT = GUI.getInstance().getGameAreaHeight();
        try {
            InputStream inputStream = ResourceHandler.getInstance().getResourceAsStream("gui/options/optionsFont.ttf");
            Font font = Font.createFont(0, inputStream);
            this.optionsFont = font.deriveFont(1, 23.0f);
            this.savegameFont = font.deriveFont(1, 17.0f);
            inputStream.close();
        }
        catch (FontFormatException fontFormatException) {
            ReportDialog.GenerateErrorReport((Exception)fontFormatException, (boolean)Game.getInstance().isFromEditor(), (String)"UNKNOWERROR");
        }
        catch (IOException iOException) {
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)Game.getInstance().isFromEditor(), (String)"UNKNOWERROR");
        }
        this.imgButton = MultimediaManager.getInstance().loadImage("gui/options/Button.png", 1);
        if (this.imgButton == null) {
            this.imgButton = this.createImage(190, 48, "");
        }
        this.imgPressedButton = MultimediaManager.getInstance().loadImage("gui/options/PressedButton.png", 1);
        if (this.imgPressedButton == null) {
            this.imgPressedButton = this.createImage(190, 48, "");
        }
        this.imgPanel = new Image[5];
        this.imgPanel[0] = MultimediaManager.getInstance().loadImage(this.LoadButton("OptionsPanel"), 1);
        if (this.imgPanel[0] == null) {
            this.imgPanel[0] = this.createImage(200, 300, "Options");
        }
        this.imgPanel[1] = MultimediaManager.getInstance().loadImage(this.LoadButton("SaveLoadPanel"), 1);
        if (this.imgPanel[1] == null) {
            this.imgPanel[1] = this.createImage(200, 204, "Save/Load");
        }
        this.imgPanel[2] = MultimediaManager.getInstance().loadImage(this.LoadButton("SavePanel"), 1);
        if (this.imgPanel[2] == null) {
            this.imgPanel[2] = this.createImage(200, 300, "Save game");
        }
        this.imgPanel[3] = MultimediaManager.getInstance().loadImage(this.LoadButton("LoadPanel"), 1);
        if (this.imgPanel[3] == null) {
            this.imgPanel[3] = this.createImage(200, 300, "Load game");
        }
        this.imgPanel[4] = MultimediaManager.getInstance().loadImage(this.LoadButton("ConfigurationPanel"), 1);
        if (this.imgPanel[4] == null) {
            this.imgPanel[4] = this.createImage(200, 252, "Configuration");
        }
        this.panelPosition = new Point((this.GAME_AREA_WIDTH - this.imgPanel[this.currentPanel].getWidth(null)) / 2, (this.GAME_AREA_HEIGHT - this.imgPanel[this.currentPanel].getHeight(null)) / 2);
        this.saveGames = new SaveGame[4];
        this.existsSaveGame = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.saveGames[i] = new SaveGame();
            this.existsSaveGame[i] = this.saveGames[i].existSaveFile(this.game.getAdventureName() + "_" + i + ".txt");
        }
    }

    private String LoadButton(String string) {
        String string2 = "gui/options/";
        String string3 = null;
        if (Game.getInstance().isFromEditor()) {
            string3 = string2 + Controller.getInstance().getLanguage() + "/" + string + ".png";
            File file = new File(string3);
            if (!file.exists()) {
                string3 = string2 + Controller.getInstance().getDefaultLanguage() + "/" + string + ".png";
            }
        } else {
            try {
                string3 = string2 + ConfigData.getLanguage() + "/" + string + ".png";
                File file = new File(string3);
                if (!file.exists()) {
                    string3 = string2 + ConfigData.getDefaultLanguage() + "/" + string + ".png";
                }
            }
            catch (NullPointerException nullPointerException) {
                string3 = string2 + TC.get((String)"Language.Internationalize") + "/" + string + ".png";
            }
        }
        return string3;
    }

    private void changePanel(int n) {
        this.currentPanel = n;
        this.panelPosition = new Point((this.GAME_AREA_WIDTH - this.imgPanel[n].getWidth(null)) / 2, (this.GAME_AREA_HEIGHT - this.imgPanel[n].getHeight(null)) / 2);
        this.highlightedOption = -1;
    }

    private void saveGame(int n) {
        this.game.save(this.game.getAdventureName() + "_" + n + ".txt");
        this.existsSaveGame[n] = this.saveGames[n].existSaveFile(this.game.getAdventureName() + "_" + n + ".txt");
    }

    private void loadGame(int n) {
        if (this.game.getGameDescriptor().getTitle().equals(this.saveGames[n].getTitle())) {
            this.game.load(this.game.getAdventureName() + "_" + n + ".txt");
        }
    }

    private void switchMusic() {
        if (this.options.isMusicActive()) {
            this.options.setMusicActive(false);
        } else {
            this.options.setMusicActive(true);
        }
    }

    private void switchEffects() {
        if (this.options.isEffectsActive()) {
            this.options.setEffectsActive(false);
        } else {
            this.options.setEffectsActive(true);
        }
    }

    private void changeTextSpeed() {
        int n = this.options.getTextSpeed();
        n = (n + 1) % 3;
        this.options.setTextSpeed(n);
    }

    private void backToGame() {
        this.game.saveOptions();
        if (this.options.isMusicActive()) {
            this.game.getFunctionalScene().playBackgroundMusic();
        } else {
            this.game.getFunctionalScene().stopBackgroundMusic();
        }
        if (!this.options.isEffectsActive()) {
            MultimediaManager.getInstance().stopAllSounds();
        }
        this.game.setState(1);
    }

    @Override
    public void mainLoop(long l, int n) {
        String[] stringArray;
        Graphics2D graphics2D;
        GUI.getInstance().setDefaultCursor();
        if (this.gameImage == null) {
            this.gameImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(800, 600, 1);
            graphics2D = (Graphics2D)this.gameImage.getGraphics();
            this.game.getFunctionalScene().draw();
            GUI.getInstance().drawScene(graphics2D, l);
            GUI.getInstance().drawHUD(graphics2D);
            stringArray = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            stringArray.filter(this.gameImage, this.gameImage);
            graphics2D.dispose();
        }
        graphics2D = GUI.getInstance().getGraphics();
        graphics2D.clearRect(0, 0, 800, 600);
        graphics2D.drawImage((Image)this.gameImage, 0, 0, null);
        graphics2D.drawImage(this.imgPanel[this.currentPanel], this.panelPosition.x, this.panelPosition.y, null);
        if (this.currentPanel == 2 || this.currentPanel == 3) {
            int n2;
            graphics2D.setFont(this.savegameFont);
            for (n2 = 0; n2 < 4; ++n2) {
                boolean bl = this.isValidSlotGame(n2);
                graphics2D.drawImage(this.highlightedOption == n2 && this.mouseButtonPressed && bl ? this.imgPressedButton : this.imgButton, this.panelPosition.x + 5, this.panelPosition.y + 55 + 48 * n2, null);
                graphics2D.setColor(this.highlightedOption == n2 && bl ? HIGHLIGHTED_COLOR : NORMAL_COLOR);
                if (this.existsSaveGame[n2]) {
                    String[] stringArray2 = new String[]{this.saveGames[n2].getTitle(), this.saveGames[n2].getSaveTime()};
                    if (!bl) {
                        stringArray2[0] = TC.get((String)"Options.versionError1");
                        stringArray2[1] = TC.get((String)"Options.versionError2");
                    }
                    GUI.drawString(graphics2D, stringArray2, 400, this.panelPosition.y + 55 + 24 + 48 * n2);
                    continue;
                }
                GUI.drawString(graphics2D, GameText.TEXT_EMPTY, 400, this.panelPosition.y + 55 + 24 + 48 * n2);
            }
            graphics2D.setFont(this.optionsFont);
            graphics2D.drawImage(this.highlightedOption == n2 && this.mouseButtonPressed ? this.imgPressedButton : this.imgButton, this.panelPosition.x + 5, this.panelPosition.y + 55 + 48 * n2, null);
            graphics2D.setColor(this.highlightedOption == n2 ? HIGHLIGHTED_COLOR : NORMAL_COLOR);
            GUI.drawString(graphics2D, GameText.TEXT_BACK, 400, this.panelPosition.y + 55 + 24 + 48 * n2);
        } else {
            stringArray = this.currentPanel == 0 ? new String[]{GameText.TEXT_SAVE_LOAD, GameText.TEXT_CONFIGURATION, GameText.TEXT_GENERATE_REPORT, GameText.TEXT_EXIT_GAME, GameText.TEXT_BACK_TO_GAME} : (this.currentPanel == 1 ? new String[]{GameText.TEXT_SAVE, GameText.TEXT_LOAD, GameText.TEXT_BACK} : new String[]{GameText.TEXT_MUSIC + " " + (this.options.isMusicActive() ? GameText.TEXT_ON : GameText.TEXT_OFF), GameText.TEXT_EFFECTS + " " + (this.options.isEffectsActive() ? GameText.TEXT_ON : GameText.TEXT_OFF), GameText.TEXT_TEXT_SPEED + ": " + Options.TEXT_SPEED_PRINT_VALUES[this.options.getTextSpeed()], GameText.TEXT_BACK});
            graphics2D.setFont(this.optionsFont);
            for (int i = 0; i < NUMBER_OPTIONS_OF_PANEL[this.currentPanel]; ++i) {
                if (Game.getInstance().isAppletMode() && (i == 0 || i == 3)) {
                    graphics2D.drawImage(this.imgPressedButton, this.panelPosition.x + 5, this.panelPosition.y + 55 + 48 * i, null);
                    graphics2D.setColor(NORMAL_COLOR);
                } else {
                    graphics2D.drawImage(this.highlightedOption == i && this.mouseButtonPressed ? this.imgPressedButton : this.imgButton, this.panelPosition.x + 5, this.panelPosition.y + 55 + 48 * i, null);
                    graphics2D.setColor(this.highlightedOption == i ? HIGHLIGHTED_COLOR : NORMAL_COLOR);
                }
                if (stringArray.length <= i) continue;
                GUI.drawString(graphics2D, stringArray[i], 400, this.panelPosition.y + 55 + 24 + 48 * i);
            }
        }
        GUI.getInstance().endDraw();
        graphics2D.dispose();
        if (this.loadGame) {
            this.loadGame(this.slotGame);
        }
    }

    private boolean isValidSlotGame(int n) {
        return this.saveGames[n].getVersionNumber() == Integer.parseInt(Game.getInstance().getGameDescriptor().getVersionNumber()) && (this.saveGames[n].getProjectName() == null || this.saveGames[n].getProjectName().equals(Game.getInstance().getGameDescriptor().getProjectName()));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDragged = false;
        this.pressedOption = this.highlightedOption;
        if (this.highlightedOption != -1) {
            this.mouseButtonPressed = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseDragged = true;
        this.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDragged) {
            if (this.highlightedOption != -1) {
                switch (this.currentPanel) {
                    case 0: {
                        this.mouseReleasedMain(mouseEvent);
                        break;
                    }
                    case 1: {
                        this.mouseReleasedSaveLoad(mouseEvent);
                        break;
                    }
                    case 2: {
                        this.mouseReleasedSave(mouseEvent);
                        break;
                    }
                    case 3: {
                        this.mouseReleasedLoad(mouseEvent);
                        break;
                    }
                    case 4: {
                        this.mouseReleasedConfiguration(mouseEvent);
                    }
                }
                this.pressedOption = -1;
            }
            this.mouseButtonPressed = false;
        }
    }

    private void mouseReleasedMain(MouseEvent mouseEvent) {
        switch (this.highlightedOption) {
            case 0: {
                this.changePanel(1);
                break;
            }
            case 1: {
                this.changePanel(4);
                break;
            }
            case 2: {
                new es.eucm.eadventure.engine.assessment.ReportDialog(GUI.getInstance().getJFrame(), this.game.getAssessmentEngine(), this.game.getAdventureName());
                break;
            }
            case 3: {
                this.game.setGameOver();
                break;
            }
            case 4: {
                this.backToGame();
            }
        }
    }

    private void mouseReleasedSaveLoad(MouseEvent mouseEvent) {
        switch (this.highlightedOption) {
            case 0: {
                this.changePanel(2);
                break;
            }
            case 1: {
                this.changePanel(3);
                break;
            }
            case 2: {
                this.changePanel(0);
            }
        }
    }

    private void mouseReleasedSave(MouseEvent mouseEvent) {
        if (this.highlightedOption == 4) {
            this.changePanel(1);
        } else {
            for (int i = 0; i < 4; ++i) {
                if (i != this.highlightedOption) continue;
                this.saveGame(i);
            }
        }
    }

    private void mouseReleasedLoad(MouseEvent mouseEvent) {
        if (this.highlightedOption == 4) {
            this.changePanel(1);
        } else {
            for (int i = 0; i < 4; ++i) {
                if (i != this.highlightedOption || !this.isValidSlotGame(i)) continue;
                this.loadGame = true;
                this.slotGame = i;
            }
        }
    }

    private void mouseReleasedConfiguration(MouseEvent mouseEvent) {
        switch (this.highlightedOption) {
            case 0: {
                this.switchMusic();
                break;
            }
            case 1: {
                this.switchEffects();
                break;
            }
            case 2: {
                this.changeTextSpeed();
                break;
            }
            case 3: {
                this.changePanel(0);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.highlightedOption = -1;
        if (this.panelPosition.x + 5 < mouseEvent.getX() && mouseEvent.getX() < this.panelPosition.x + 5 + 190) {
            for (int i = 0; i < NUMBER_OPTIONS_OF_PANEL[this.currentPanel]; ++i) {
                if (this.panelPosition.y + 55 + 48 * i >= mouseEvent.getY() || mouseEvent.getY() >= this.panelPosition.y + 55 + 48 * (i + 1)) continue;
                this.highlightedOption = i;
                this.validateOption();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragged = true;
        this.highlightedOption = -1;
        if (this.panelPosition.x + 5 < mouseEvent.getX() && mouseEvent.getX() < this.panelPosition.x + 5 + 190) {
            for (int i = 0; i < NUMBER_OPTIONS_OF_PANEL[this.currentPanel]; ++i) {
                if (this.panelPosition.y + 55 + 48 * i >= mouseEvent.getY() || mouseEvent.getY() >= this.panelPosition.y + 55 + 48 * (i + 1) || this.pressedOption == -1 || this.pressedOption != i) continue;
                this.highlightedOption = i;
                this.validateOption();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            if (this.currentPanel == 0) {
                this.backToGame();
            } else if (this.currentPanel == 2 || this.currentPanel == 3) {
                this.changePanel(1);
            } else {
                this.changePanel(0);
            }
        }
    }

    private void validateOption() {
        switch (this.currentPanel) {
            case 0: {
                if (this.highlightedOption > NUMBER_OPTIONS_OF_PANEL[0]) {
                    this.highlightedOption = -1;
                    break;
                }
                if (this.highlightedOption != 0 && this.highlightedOption != 3 || !Game.getInstance().isAppletMode()) break;
                this.highlightedOption = -1;
                break;
            }
            case 1: {
                if (this.highlightedOption <= NUMBER_OPTIONS_OF_PANEL[1]) break;
                this.highlightedOption = -1;
                break;
            }
            case 2: {
                if (this.highlightedOption <= NUMBER_OPTIONS_OF_PANEL[2]) break;
                this.highlightedOption = -1;
                break;
            }
            case 3: {
                if (this.highlightedOption <= NUMBER_OPTIONS_OF_PANEL[3]) break;
                this.highlightedOption = -1;
                break;
            }
            case 4: {
                if (this.highlightedOption <= NUMBER_OPTIONS_OF_PANEL[4]) break;
                this.highlightedOption = -1;
            }
        }
    }

    private Image createImage(int n, int n2, String string) {
        return CreateImage.createImage((int)n, (int)n2, (String)string, (Font)this.optionsFont);
    }
}

