/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakPlayerEffect;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;

public class FunctionalSpeakPlayerEffect
extends FunctionalEffect {
    public FunctionalSpeakPlayerEffect(SpeakPlayerEffect speakPlayerEffect) {
        super((AbstractEffect)speakPlayerEffect);
    }

    @Override
    public void triggerEffect() {
        FunctionalConditions functionalConditions = new FunctionalConditions(this.effect.getConditions());
        if (functionalConditions.allConditionsOk()) {
            FunctionalPlayer functionalPlayer = Game.getInstance().getFunctionalPlayer();
            if (functionalPlayer.isAlwaysSynthesizer()) {
                functionalPlayer.speakWithFreeTTS(((SpeakPlayerEffect)this.effect).getLine(), functionalPlayer.getPlayerVoice(), Game.getInstance().getGameDescriptor().isKeepShowing());
            } else {
                functionalPlayer.speak(((SpeakPlayerEffect)this.effect).getLine(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
            Game.getInstance().setCharacterCurrentlyTalking(functionalPlayer);
        }
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public boolean isStillRunning() {
        if (Game.getInstance().getCharacterCurrentlyTalking() != null && !Game.getInstance().getCharacterCurrentlyTalking().isTalking()) {
            Game.getInstance().setCharacterCurrentlyTalking(null);
        }
        return Game.getInstance().getCharacterCurrentlyTalking() != null;
    }

    @Override
    public boolean canSkip() {
        return true;
    }

    @Override
    public void skip() {
        if (Game.getInstance().getCharacterCurrentlyTalking() != null && Game.getInstance().getCharacterCurrentlyTalking().isTalking()) {
            Game.getInstance().getCharacterCurrentlyTalking().stopTalking();
        }
        Game.getInstance().setCharacterCurrentlyTalking(null);
    }
}

