/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakCharEffect;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;

public class FunctionalSpeakCharEffect
extends FunctionalEffect {
    public FunctionalSpeakCharEffect(SpeakCharEffect speakCharEffect) {
        super((AbstractEffect)speakCharEffect);
    }

    @Override
    public void triggerEffect() {
        FunctionalNPC functionalNPC = Game.getInstance().getFunctionalScene().getNPC(((SpeakCharEffect)this.effect).getTargetId());
        if (functionalNPC != null) {
            if (functionalNPC.isAlwaysSynthesizer()) {
                functionalNPC.speakWithFreeTTS(((SpeakCharEffect)this.effect).getLine(), functionalNPC.getPlayerVoice(), Game.getInstance().getGameDescriptor().isKeepShowing());
            } else {
                functionalNPC.speak(((SpeakCharEffect)this.effect).getLine(), Game.getInstance().getGameDescriptor().isKeepShowing());
            }
            Game.getInstance().setCharacterCurrentlyTalking(functionalNPC);
        }
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public boolean isStillRunning() {
        if (Game.getInstance().getCharacterCurrentlyTalking() != null && !Game.getInstance().getCharacterCurrentlyTalking().isTalking()) {
            Game.getInstance().setCharacterCurrentlyTalking(null);
        }
        return Game.getInstance().getCharacterCurrentlyTalking() != null;
    }

    @Override
    public boolean canSkip() {
        return true;
    }

    @Override
    public void skip() {
        if (Game.getInstance().getCharacterCurrentlyTalking() != null && Game.getInstance().getCharacterCurrentlyTalking().isTalking()) {
            Game.getInstance().getCharacterCurrentlyTalking().stopTalking();
        }
        Game.getInstance().setCharacterCurrentlyTalking(null);
    }
}

