/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveObjectEffect;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;
import java.util.ArrayList;

public class FunctionalMoveObjectEffect
extends FunctionalEffect {
    private FunctionalItem object;
    private MoveObjectEffect moveObjectEffect;
    private long time;
    private int initialX;
    private int initialY;
    private float scale;
    private boolean finished;

    public FunctionalMoveObjectEffect(MoveObjectEffect moveObjectEffect) {
        super((AbstractEffect)moveObjectEffect);
        this.moveObjectEffect = moveObjectEffect;
    }

    @Override
    public void triggerEffect() {
        ArrayList<FunctionalItem> arrayList = Game.getInstance().getFunctionalScene().getItems();
        for (FunctionalItem functionalItem : arrayList) {
            if (!functionalItem.getItem().getId().equals(this.moveObjectEffect.getTargetId())) continue;
            this.object = functionalItem;
        }
        if (this.object != null) {
            if (this.moveObjectEffect.isAnimated()) {
                this.time = System.currentTimeMillis();
                this.initialX = (int)this.object.getX();
                this.initialY = (int)this.object.getY();
                this.scale = this.object.getScale();
                this.finished = false;
            } else {
                this.object.setX(this.moveObjectEffect.getX());
                this.object.setY(this.moveObjectEffect.getY());
                this.object.setScale(this.moveObjectEffect.getScale());
                this.finished = true;
            }
        } else {
            this.finished = true;
        }
    }

    @Override
    public boolean isInstantaneous() {
        return !this.moveObjectEffect.isAnimated();
    }

    @Override
    public boolean isStillRunning() {
        return !this.finished;
    }

    public void update(long l) {
        float f = (float)(System.currentTimeMillis() - this.time) * (float)this.moveObjectEffect.getTranslateSpeed() / 60000.0f;
        int n = this.initialX + (int)((float)(this.moveObjectEffect.getX() - this.initialX) * f);
        int n2 = this.initialY + (int)((float)(this.moveObjectEffect.getY() - this.initialY) * f);
        f = (float)(System.currentTimeMillis() - this.time) * (float)this.moveObjectEffect.getScaleSpeed() / 60000.0f;
        float f2 = this.scale + (this.moveObjectEffect.getScale() - this.scale) * f;
        if (this.initialX < this.moveObjectEffect.getX() && n > this.moveObjectEffect.getX() || this.initialX > this.moveObjectEffect.getX() && n < this.moveObjectEffect.getX() || this.initialY < this.moveObjectEffect.getY() && n2 > this.moveObjectEffect.getY() || this.initialY > this.moveObjectEffect.getY() && n2 < this.moveObjectEffect.getY() || this.initialX == this.moveObjectEffect.getX() && this.initialY == this.moveObjectEffect.getY()) {
            n = this.moveObjectEffect.getX();
            n2 = this.moveObjectEffect.getY();
            f2 = this.moveObjectEffect.getScale();
            this.finished = true;
        }
        this.object.setX(n);
        this.object.setY(n2);
        this.object.setScale(f2);
    }
}

