/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.ActivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.ConsumeObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.DeactivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DecrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.GenerateObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.HighlightItemEffect;
import es.eucm.eadventure.common.data.chapter.effects.IncrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.MacroReferenceEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveNPCEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.MovePlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlayAnimationEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlaySoundEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.common.data.chapter.effects.SetValueEffect;
import es.eucm.eadventure.common.data.chapter.effects.ShowTextEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakCharEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakPlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerBookEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerCutsceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.WaitTimeEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalActivateEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalConsumeObjectEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalDeactivateEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalDecrementVarEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalGenerateObjectEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalHighlightItemEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalIncrementVarEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalMacroReferenceEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalMoveNPCEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalMoveObjectEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalMovePlayerEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalPlayAnimationEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalPlaySoundEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalRandomEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalSetValueEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalShowTextEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalSpeakCharEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalSpeakPlayerEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalTriggerBookEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalTriggerConversationEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalTriggerCutsceneEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalTriggerLastSceneEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalTriggerSceneEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalWaitTimeEffect;

public abstract class FunctionalEffect {
    protected AbstractEffect effect;

    public FunctionalEffect(AbstractEffect abstractEffect) {
        this.effect = abstractEffect;
    }

    public abstract void triggerEffect();

    public abstract boolean isInstantaneous();

    public abstract boolean isStillRunning();

    public boolean isAllConditionsOK() {
        if (this.effect != null) {
            return new FunctionalConditions(this.effect.getConditions()).allConditionsOk();
        }
        return true;
    }

    public static FunctionalEffect buildFunctionalEffect(AbstractEffect abstractEffect) {
        FunctionalEffect functionalEffect = null;
        switch (abstractEffect.getType()) {
            case 0: {
                functionalEffect = new FunctionalActivateEffect((ActivateEffect)abstractEffect);
                break;
            }
            case 1: {
                functionalEffect = new FunctionalDeactivateEffect((DeactivateEffect)abstractEffect);
                break;
            }
            case 17: {
                functionalEffect = new FunctionalSetValueEffect((SetValueEffect)abstractEffect);
                break;
            }
            case 18: {
                functionalEffect = new FunctionalIncrementVarEffect((IncrementVarEffect)abstractEffect);
                break;
            }
            case 19: {
                functionalEffect = new FunctionalDecrementVarEffect((DecrementVarEffect)abstractEffect);
                break;
            }
            case 20: {
                functionalEffect = new FunctionalMacroReferenceEffect((MacroReferenceEffect)abstractEffect);
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                functionalEffect = new FunctionalConsumeObjectEffect((ConsumeObjectEffect)abstractEffect);
                break;
            }
            case 3: {
                functionalEffect = new FunctionalGenerateObjectEffect((GenerateObjectEffect)abstractEffect);
                break;
            }
            case 11: {
                functionalEffect = new FunctionalMoveNPCEffect((MoveNPCEffect)abstractEffect);
                break;
            }
            case 10: {
                functionalEffect = new FunctionalMovePlayerEffect((MovePlayerEffect)abstractEffect);
                break;
            }
            case 9: {
                functionalEffect = new FunctionalPlayAnimationEffect((PlayAnimationEffect)abstractEffect);
                break;
            }
            case 8: {
                functionalEffect = new FunctionalPlaySoundEffect((PlaySoundEffect)abstractEffect);
                break;
            }
            case 16: {
                functionalEffect = new FunctionalRandomEffect((RandomEffect)abstractEffect);
                break;
            }
            case 6: {
                functionalEffect = new FunctionalSpeakCharEffect((SpeakCharEffect)abstractEffect);
                break;
            }
            case 5: {
                functionalEffect = new FunctionalSpeakPlayerEffect((SpeakPlayerEffect)abstractEffect);
                break;
            }
            case 7: {
                functionalEffect = new FunctionalTriggerBookEffect((TriggerBookEffect)abstractEffect);
                break;
            }
            case 12: {
                functionalEffect = new FunctionalTriggerConversationEffect((TriggerConversationEffect)abstractEffect);
                break;
            }
            case 13: {
                functionalEffect = new FunctionalTriggerCutsceneEffect((TriggerCutsceneEffect)abstractEffect);
                break;
            }
            case 15: {
                functionalEffect = new FunctionalTriggerLastSceneEffect();
                break;
            }
            case 14: {
                functionalEffect = new FunctionalTriggerSceneEffect((TriggerSceneEffect)abstractEffect);
                break;
            }
            case 22: {
                functionalEffect = new FunctionalShowTextEffect((ShowTextEffect)abstractEffect);
                break;
            }
            case 21: {
                functionalEffect = new FunctionalWaitTimeEffect((WaitTimeEffect)abstractEffect);
                break;
            }
            case 23: {
                functionalEffect = new FunctionalHighlightItemEffect((HighlightItemEffect)abstractEffect);
                break;
            }
            case 24: {
                functionalEffect = new FunctionalMoveObjectEffect((MoveObjectEffect)abstractEffect);
            }
        }
        return functionalEffect;
    }

    public boolean canSkip() {
        return false;
    }

    public void skip() {
    }

    public FunctionalEffect getTriggerEffect() {
        return null;
    }
}

