/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.auxiliar.TTask;
import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.util.Timer;
import java.util.TimerTask;

public class FunctionalSpeak
extends FunctionalAction {
    private String text;
    private long audioId = -1L;
    private TTask task;
    private long totalTime;
    private int timeTalking;
    private boolean keepShowing;

    public FunctionalSpeak(Action action, String string, boolean bl) {
        super(action);
        this.type = 2;
        this.setText(string);
        this.task = new TTask();
        this.keepShowing = bl;
    }

    public FunctionalSpeak(Action action, String string, String string2, boolean bl) {
        super(action);
        this.type = 2;
        this.setText(string);
        this.setAudio(string2);
        this.task = new TTask();
        this.keepShowing = bl;
    }

    @Override
    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        this.totalTime = 0L;
        Resources resources = functionalPlayer.getResources();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        Animation[] animationArray = new Animation[4];
        animationArray[2] = resources.getAssetPath("speakright") != null && !resources.getAssetPath("speakright").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("speakright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("speakright"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("speakleft"), true, 2);
        animationArray[3] = resources.getAssetPath("speakleft") != null && !resources.getAssetPath("speakleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("speakleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("speakleft"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("speakright"), true, 2);
        animationArray[0] = multimediaManager.loadAnimation(resources.getAssetPath("speakup"), false, 2);
        animationArray[1] = multimediaManager.loadAnimation(resources.getAssetPath("speakdown"), false, 2);
        functionalPlayer.setAnimation(animationArray, -1);
    }

    @Override
    public void update(long l) {
        this.totalTime += l;
        if (!(this.keepShowing || this.totalTime <= (long)this.timeTalking || this.audioId != -1L && MultimediaManager.getInstance().isPlaying(this.audioId) || !this.task.isEnd())) {
            this.finished = true;
            this.functionalPlayer.popAnimation();
            this.stopTTSTalking();
        }
    }

    public void setText(String string) {
        this.text = Game.getInstance().processText(string);
        float f = 1.0f;
        if (Game.getInstance().getOptions().getTextSpeed() == 0) {
            f = 1.5f;
        }
        if (Game.getInstance().getOptions().getTextSpeed() == 2) {
            f = 0.8f;
        }
        this.timeTalking = (int)((float)(300 * this.text.split(" ").length) * f);
        if (this.timeTalking < (int)(1400.0f * f)) {
            this.timeTalking = (int)(1400.0f * f);
        }
    }

    public void setAudio(String string) {
        if (string == null) {
            if (this.audioId != -1L) {
                MultimediaManager.getInstance().stopPlayingInmediately(this.audioId);
                while (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.audioId = -1L;
            }
        } else {
            if (this.audioId != -1L) {
                MultimediaManager.getInstance().stopPlayingInmediately(this.audioId);
                while (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.audioId = MultimediaManager.getInstance().loadSound(string, false);
            MultimediaManager.getInstance().startPlaying(this.audioId);
            while (!MultimediaManager.getInstance().isPlaying(this.audioId)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setSpeakFreeTTS(String string, String string2) {
        String string3 = Game.getInstance().processText(string);
        this.task = new TTask(string2, string3);
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.task, 0L);
    }

    public void stopTTSTalking() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public void drawAditionalElements() {
        if (this.text != null && this.text != "") {
            int n;
            int n2;
            if (this.functionalPlayer != null && !this.functionalPlayer.isTransparent()) {
                n2 = (int)this.functionalPlayer.getX() - Game.getInstance().getFunctionalScene().getOffsetX();
                n = (int)(this.functionalPlayer.getY() - (float)this.functionalPlayer.getHeight() * this.functionalPlayer.getScale());
            } else {
                n2 = Math.round(400.0f + (float)Game.getInstance().getFunctionalScene().getOffsetX());
                n = Math.round(100.0f + (float)(this.functionalPlayer != null ? this.functionalPlayer.getHeight() : 0));
            }
            if (this.functionalPlayer.getShowsSpeechBubbles()) {
                GUI.getInstance().addTextToDraw(this.text, n2, n - 15, this.functionalPlayer.getTextFrontColor(), this.functionalPlayer.getTextBorderColor(), this.functionalPlayer.getBubbleBkgColor(), this.functionalPlayer.getBubbleBorderColor(), this.functionalPlayer != null && !this.functionalPlayer.isTransparent());
            } else {
                GUI.getInstance().addTextToDraw(this.text, n2, n, this.functionalPlayer.getTextFrontColor(), this.functionalPlayer.getTextBorderColor());
            }
        }
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.stopTTSTalking();
            if (this.audioId != -1L) {
                MultimediaManager.getInstance().stopPlayingInmediately(this.audioId);
            }
        }
    }

    @Override
    public void setAnotherElement(FunctionalElement functionalElement) {
    }
}

