/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;

public class FunctionalGrab
extends FunctionalAction {
    private FunctionalElement element;
    private long totalTime;
    private boolean canGrab = false;

    public FunctionalGrab(Action action, FunctionalElement functionalElement) {
        super(action);
        this.element = functionalElement;
        this.type = 1;
        this.originalAction = functionalElement.getFirstValidAction(1);
        if (this.originalAction != null) {
            this.needsGoTo = this.originalAction.isNeedsGoTo();
            this.keepDistance = this.originalAction.getKeepDistance();
        } else {
            this.needsGoTo = true;
            this.keepDistance = 35;
        }
    }

    @Override
    public void drawAditionalElements() {
    }

    @Override
    public void setAnotherElement(FunctionalElement functionalElement) {
    }

    @Override
    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        Resources resources = functionalPlayer.getResources();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        if (functionalPlayer.getX() < this.element.getX()) {
            functionalPlayer.setDirection(2);
        } else {
            functionalPlayer.setDirection(3);
        }
        Animation[] animationArray = new Animation[4];
        animationArray[2] = resources.getAssetPath("useright") != null && !resources.getAssetPath("useright").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("useleft"), true, 2);
        animationArray[3] = resources.getAssetPath("useleft") != null && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("useleft"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("useright"), true, 2);
        animationArray[0] = multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2);
        animationArray[1] = multimediaManager.loadAnimation(resources.getAssetPath("useright"), true, 2);
        functionalPlayer.setAnimation(animationArray, -1);
        this.finished = false;
        DebugLog.player("Started grab: " + this.element.getElement().getId());
    }

    @Override
    public void stop() {
        this.finished = true;
    }

    @Override
    public void update(long l) {
        this.totalTime += l;
        FunctionalItem functionalItem = (FunctionalItem)this.element;
        if (!this.finished && !this.canGrab) {
            this.canGrab = functionalItem.grab();
            if (!this.canGrab) {
                this.finished = true;
                this.functionalPlayer.popAnimation();
                if (this.functionalPlayer.isAlwaysSynthesizer()) {
                    this.functionalPlayer.speakWithFreeTTS(GameText.getTextGrabCannot(), this.functionalPlayer.getPlayerVoice());
                } else {
                    this.functionalPlayer.speak(GameText.getTextGrabCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
                }
            }
        } else if (!this.finished && this.totalTime > 1000L) {
            this.finished = true;
            this.functionalPlayer.popAnimation();
        }
    }
}

