/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;

public class FunctionalGive
extends FunctionalAction {
    private FunctionalElement element;
    private FunctionalElement anotherElement;
    private long totalTime;
    private boolean canGive = false;

    public FunctionalGive(Action action, FunctionalElement functionalElement) {
        super(action);
        this.element = functionalElement;
        this.type = 5;
        this.originalAction = functionalElement.getFirstValidAction(2);
        this.requiersAnotherElement = true;
    }

    @Override
    public void drawAditionalElements() {
    }

    @Override
    public void setAnotherElement(FunctionalElement functionalElement) {
        this.requiersAnotherElement = false;
        if (this.originalAction != null) {
            this.needsGoTo = this.originalAction.isNeedsGoTo();
            this.keepDistance = this.originalAction.getKeepDistance();
        } else {
            this.needsGoTo = true;
            this.keepDistance = 35;
        }
        this.anotherElement = functionalElement;
    }

    @Override
    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        Resources resources = functionalPlayer.getResources();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        if (this.anotherElement.getX() > functionalPlayer.getX()) {
            functionalPlayer.setDirection(2);
        } else {
            functionalPlayer.setDirection(3);
        }
        Animation[] animationArray = new Animation[4];
        animationArray[2] = resources.getAssetPath("useright") != null && !resources.getAssetPath("useright").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("useleft"), true, 2);
        animationArray[3] = resources.getAssetPath("useleft") != null && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("useleft"), false, 2) : multimediaManager.loadAnimation(resources.getAssetPath("useright"), true, 2);
        animationArray[0] = multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2);
        animationArray[1] = multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2);
        functionalPlayer.setAnimation(animationArray, -1);
    }

    @Override
    public void stop() {
        if (this.functionalPlayer != null && !this.finished) {
            this.functionalPlayer.popAnimation();
        }
        this.finished = true;
    }

    @Override
    public void update(long l) {
        if (this.anotherElement != null) {
            this.totalTime += l;
            if (this.element instanceof FunctionalItem && this.anotherElement instanceof FunctionalNPC) {
                FunctionalItem functionalItem = (FunctionalItem)this.element;
                FunctionalNPC functionalNPC = (FunctionalNPC)this.anotherElement;
                if (!this.finished && !this.canGive) {
                    this.canGive = functionalItem.giveTo(functionalNPC);
                    if (!this.canGive) {
                        DebugLog.player("Can't give: " + functionalItem.getItem().getId() + " to " + functionalNPC.getNPC().getId());
                        if (this.functionalPlayer.isAlwaysSynthesizer()) {
                            this.functionalPlayer.speakWithFreeTTS(GameText.getTextGiveCannot(), this.functionalPlayer.getPlayerVoice());
                        } else {
                            this.functionalPlayer.speak(GameText.getTextGiveCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
                        }
                        this.functionalPlayer.popAnimation();
                        this.finished = true;
                    }
                } else if (!this.finished && this.totalTime > 1000L) {
                    DebugLog.player("Gave: " + functionalItem.getItem().getId() + " to " + functionalNPC.getNPC().getId());
                    this.finished = true;
                    this.functionalPlayer.popAnimation();
                }
            } else {
                DebugLog.player("Invalid give...");
                this.finished = true;
            }
        }
    }

    @Override
    public FunctionalElement getAnotherElement() {
        return this.anotherElement;
    }
}

