/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalAction;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;

public class FunctionalCustom
extends FunctionalAction {
    private FunctionalElement element;
    private String actionName;
    private long totalTime;
    private boolean hasAnimation;

    public FunctionalCustom(FunctionalElement functionalElement, String string) {
        super(null);
        this.element = functionalElement;
        this.actionName = string;
        this.originalAction = functionalElement.getFirstValidCustomAction(string);
        this.needsGoTo = this.originalAction.isNeedsGoTo();
        this.keepDistance = this.originalAction.getKeepDistance();
        this.hasAnimation = false;
    }

    @Override
    public void drawAditionalElements() {
    }

    @Override
    public void setAnotherElement(FunctionalElement functionalElement) {
    }

    @Override
    public void start(FunctionalPlayer functionalPlayer) {
        this.functionalPlayer = functionalPlayer;
        Resources resources = null;
        CustomAction customAction = (CustomAction)this.originalAction;
        for (int i = 0; i < customAction.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)customAction.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)customAction.getResources().get(i);
        }
        Resources resources2 = functionalPlayer.getResources();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        Animation[] animationArray = new Animation[4];
        if (resources.getAssetPath("actionAnimation") != null && !resources.getAssetPath("actionAnimation").equals("")) {
            animationArray[2] = multimediaManager.loadAnimation(resources.getAssetPath("actionAnimation"), true, 2);
            animationArray[3] = multimediaManager.loadAnimation(resources.getAssetPath("actionAnimation"), true, 2);
            animationArray[0] = multimediaManager.loadAnimation(resources.getAssetPath("actionAnimation"), false, 2);
            animationArray[1] = multimediaManager.loadAnimation(resources.getAssetPath("actionAnimation"), false, 2);
        } else {
            animationArray[2] = resources2.getAssetPath("useright") != null && !resources2.getAssetPath("useright").equals("assets/special/EmptyAnimation") && !resources2.getAssetPath("useright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources2.getAssetPath("useright"), false, 2) : multimediaManager.loadAnimation(resources2.getAssetPath("useleft"), true, 2);
            animationArray[3] = resources2.getAssetPath("useleft") != null && !resources2.getAssetPath("useleft").equals("assets/special/EmptyAnimation") && !resources2.getAssetPath("useleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources2.getAssetPath("useleft"), false, 2) : multimediaManager.loadAnimation(resources2.getAssetPath("useright"), true, 2);
            animationArray[0] = multimediaManager.loadAnimation(resources2.getAssetPath("useright"), false, 2);
            animationArray[1] = multimediaManager.loadAnimation(resources2.getAssetPath("useright"), false, 2);
        }
        if (resources.getAssetPath("actionAnimationLeft") != null && !resources.getAssetPath("actionAnimationLeft").equals("")) {
            animationArray[3] = multimediaManager.loadAnimation(resources.getAssetPath("actionAnimationLeft"), true, 2);
        }
        if (this.element.getX() > functionalPlayer.getX()) {
            functionalPlayer.setDirection(2);
        } else {
            functionalPlayer.setDirection(3);
        }
        functionalPlayer.setAnimation(animationArray, -1);
        this.hasAnimation = true;
        this.totalTime = 0L;
        this.finished = false;
        DebugLog.player("Started custom action: " + customAction.getName() + " " + customAction.getTargetId());
    }

    @Override
    public void stop() {
        this.finished = true;
    }

    @Override
    public void update(long l) {
        this.totalTime += l;
        if (this.totalTime > 1000L) {
            FunctionalNPC functionalNPC;
            this.finished = true;
            if (this.hasAnimation) {
                this.functionalPlayer.popAnimation();
            }
            if (this.element instanceof FunctionalItem) {
                FunctionalItem functionalItem = (FunctionalItem)this.element;
                if (!functionalItem.custom(this.actionName)) {
                    if (this.functionalPlayer.isAlwaysSynthesizer()) {
                        this.functionalPlayer.speakWithFreeTTS(GameText.getTextCustomCannot(), this.functionalPlayer.getPlayerVoice());
                    } else {
                        this.functionalPlayer.speak(GameText.getTextCustomCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
                    }
                }
            } else if (this.element instanceof FunctionalNPC && !(functionalNPC = (FunctionalNPC)this.element).custom(this.actionName)) {
                if (this.functionalPlayer.isAlwaysSynthesizer()) {
                    this.functionalPlayer.speakWithFreeTTS(GameText.getTextCustomCannot(), this.functionalPlayer.getPlayerVoice());
                } else {
                    this.functionalPlayer.speak(GameText.getTextCustomCannot(), Game.getInstance().getGameDescriptor().isKeepShowing());
                }
            }
        }
    }
}

