/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata.functionalactions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;

public abstract class FunctionalAction {
    protected Action originalAction;
    protected FunctionalPlayer functionalPlayer;
    protected boolean finished = false;
    protected boolean requiersAnotherElement = false;
    protected boolean needsGoTo = false;
    protected int type;
    protected int keepDistance = 0;
    protected boolean storeClickEffects = false;

    public FunctionalAction(Action action) {
        this.originalAction = action;
    }

    public abstract void start(FunctionalPlayer var1);

    public boolean isStarted() {
        return this.functionalPlayer != null;
    }

    public boolean isRequiersAnotherElement() {
        return this.requiersAnotherElement;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isNeedsGoTo() {
        return this.needsGoTo;
    }

    public abstract void update(long var1);

    public abstract void setAnotherElement(FunctionalElement var1);

    public int getType() {
        return this.type;
    }

    public abstract void stop();

    public abstract void drawAditionalElements();

    public int getKeepDistance() {
        return this.keepDistance;
    }

    public void setKeepDistance(int n) {
        this.keepDistance = n;
    }

    public FunctionalElement getAnotherElement() {
        return null;
    }

    public void launchClickEffects() {
        if (this.storeClickEffects) {
            this.storeClickEffects = false;
            if (this.originalAction.isActivatedClickEffects()) {
                FunctionalEffects.storeAllEffects(this.originalAction.getClickEffects());
            }
        }
    }
}

