/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBook;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBookBullet;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBookImage;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBookParagraph;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBookText;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBookTitle;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class FunctionalTextBook
extends FunctionalBook {
    public static final int TEXT_X_1 = 110;
    public static final int TEXT_X_2 = 445;
    public static final int TEXT_Y = 75;
    public static final int TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH_BULLET = 225;
    public static final int PAGE_TEXT_HEIGHT = 400;
    public static final int LINE_HEIGHT = 25;
    public static final int TITLE_HEIGHT = 50;
    public static final int TEXT_LINES = 16;
    protected Image imgBook;
    protected Image background;
    private int totalHeight;
    private ArrayList<FunctionalBookParagraph> functionalParagraphs = new ArrayList();

    public FunctionalTextBook(Book book) {
        super(book);
        for (BookParagraph object2 : this.book.getParagraphs()) {
            switch (object2.getType()) {
                case 3: {
                    this.functionalParagraphs.add(new FunctionalBookTitle(object2));
                    break;
                }
                case 0: {
                    this.functionalParagraphs.add(new FunctionalBookBullet(object2));
                    break;
                }
                case 1: {
                    this.functionalParagraphs.add(new FunctionalBookImage(object2));
                    break;
                }
                case 2: {
                    this.functionalParagraphs.add(new FunctionalBookText(object2));
                }
            }
        }
        this.totalHeight = 0;
        this.currentPage = 0;
        for (FunctionalBookParagraph functionalBookParagraph : this.functionalParagraphs) {
            this.totalHeight += functionalBookParagraph.getHeight();
        }
        this.numPages = (int)Math.ceil((double)this.totalHeight / 400.0);
        int n = 0;
        this.imgBook = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(250, this.totalHeight + 400, 3);
        Graphics2D graphics2D = (Graphics2D)this.imgBook.getGraphics();
        graphics2D.setFont(new Font("Dialog", 0, 18));
        graphics2D.setColor(Color.DARK_GRAY);
        for (FunctionalBookParagraph functionalBookParagraph : this.functionalParagraphs) {
            if (!functionalBookParagraph.canBeSplitted() && n % 400 + functionalBookParagraph.getHeight() > 400) {
                n += 400 - n % 400;
            }
            functionalBookParagraph.draw(graphics2D, 0, n);
            n += functionalBookParagraph.getHeight();
        }
        graphics2D.dispose();
    }

    @Override
    public boolean isInLastPage() {
        return this.currentPage == this.numPages - 1 || this.currentPage == this.numPages - 2;
    }

    @Override
    public boolean isInFirstPage() {
        return this.currentPage == 0 || this.currentPage == 1;
    }

    @Override
    public void nextPage() {
        if (this.currentPage < this.numPages - 2) {
            this.currentPage += 2;
        }
    }

    @Override
    public void previousPage() {
        if (this.currentPage > 1) {
            this.currentPage -= 2;
        }
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.drawImage(this.imgBook, 110, 75, 360, 475, 0, this.currentPage * 400, 250, (this.currentPage + 1) * 400, null);
        if (this.currentPage < this.numPages - 1) {
            graphics2D.drawImage(this.imgBook, 445, 75, 695, 475, 0, (this.currentPage + 1) * 400, 250, (this.currentPage + 2) * 400, null);
        }
    }
}

