/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBook;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBookPage;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Component;
import java.util.ArrayList;

public class FunctionalStyledBook
extends FunctionalBook {
    private ArrayList<FunctionalBookPage> functionalPages = new ArrayList();

    public FunctionalStyledBook(Book book) {
        super(book);
        Resources resources = null;
        for (int i = 0; i < this.book.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)this.book.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)this.book.getResources().get(i);
        }
        for (BookPage bookPage : this.book.getPageURLs()) {
            FunctionalBookPage functionalBookPage = new FunctionalBookPage(bookPage, this, this.background, this.arrowLeftNormal, this.arrowRightNormal, this.previousPage, this.nextPage, false);
            if (!functionalBookPage.isValid()) continue;
            this.functionalPages.add(functionalBookPage);
        }
        this.numPages = this.functionalPages.size();
        if (this.numPages == 0) {
            this.functionalPages.add(new FunctionalBookPage(this.background));
        }
        this.currentPage = 0;
        GUI.getInstance().showComponent(this.functionalPages.get(this.currentPage));
    }

    @Override
    public boolean isInLastPage() {
        return this.currentPage == this.numPages - 1;
    }

    @Override
    public boolean isInFirstPage() {
        return this.currentPage == 0;
    }

    @Override
    public void nextPage() {
        if (this.currentPage < this.numPages - 1) {
            this.functionalPages.get(this.currentPage).setCurrentArrowRight(this.arrowRightNormal);
            ++this.currentPage;
            GUI.getInstance().showComponent(this.functionalPages.get(this.currentPage));
            this.functionalPages.get(this.currentPage).updateUI();
        }
    }

    @Override
    public void previousPage() {
        if (this.currentPage > 0) {
            this.functionalPages.get(this.currentPage).setCurrentArrowLeft(this.arrowLeftNormal);
            --this.currentPage;
            GUI.getInstance().showComponent(this.functionalPages.get(this.currentPage));
            this.functionalPages.get(this.currentPage).updateUI();
        }
    }

    public Component getPageToDisplay() {
        return this.functionalPages.get(this.currentPage);
    }

    @Override
    public void mouseOverPreviousPage(boolean bl) {
        if (bl) {
            this.functionalPages.get(this.currentPage).setCurrentArrowLeft(this.arrowLeftOver);
        } else {
            this.functionalPages.get(this.currentPage).setCurrentArrowLeft(this.arrowLeftNormal);
        }
    }

    @Override
    public void mouseOverNextPage(boolean bl) {
        if (bl) {
            this.functionalPages.get(this.currentPage).setCurrentArrowRight(this.arrowRightOver);
        } else {
            this.functionalPages.get(this.currentPage).setCurrentArrowRight(this.arrowRightNormal);
        }
    }
}

