/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.common.data.chapter.elements.Atrezzo;
import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.ItemSummary;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalActiveArea;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalAtrezzo;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalBarrier;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalExitArea;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalTrajectory;
import es.eucm.eadventure.engine.core.control.functionaldata.Renderable;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalExit;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalactions.FunctionalGoTo;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FunctionalScene
implements Renderable {
    private static final int MAX_OFFSET_X = 300;
    private static final int OFFSET_ARROW_AREA_RADIUS = 30;
    private Scene scene;
    private Resources resources;
    private Image background;
    private Image foreground;
    private long backgroundMusicId = -1L;
    private FunctionalPlayer player;
    private ArrayList<FunctionalItem> items;
    private ArrayList<FunctionalNPC> npcs;
    private ArrayList<FunctionalActiveArea> areas;
    private ArrayList<FunctionalBarrier> barriers;
    private ArrayList<FunctionalAtrezzo> atrezzo;
    private FunctionalTrajectory trajectory;
    private int offsetX;
    private boolean moveOffsetRight = false;
    private boolean moveOffsetLeft = false;
    private boolean showsOffsetArrows = false;

    public FunctionalScene(Scene scene, FunctionalPlayer functionalPlayer) {
        this(scene, functionalPlayer, -1L);
    }

    public FunctionalScene(Scene scene, FunctionalPlayer functionalPlayer, long l) {
        this.scene = scene;
        this.player = functionalPlayer;
        this.npcs = new ArrayList();
        this.items = new ArrayList();
        this.atrezzo = new ArrayList();
        this.areas = new ArrayList();
        this.barriers = new ArrayList();
        this.trajectory = new FunctionalTrajectory(scene.getTrajectory(), this.barriers);
        Chapter chapter = Game.getInstance().getCurrentChapterData();
        ItemSummary itemSummary = Game.getInstance().getItemSummary();
        this.resources = this.createResourcesBlock();
        this.background = null;
        if (this.resources.existAsset("background")) {
            this.background = MultimediaManager.getInstance().loadImageFromZip(this.resources.getAssetPath("background"), 0);
        }
        if (Game.getInstance().isTransparent() && this.background != null && this.background.getWidth(null) > 800) {
            this.showsOffsetArrows = true;
        }
        this.foreground = null;
        if (this.background != null && this.resources.existAsset("foreground")) {
            Iterator iterator = (BufferedImage)this.background;
            BufferedImage bufferedImage = (BufferedImage)MultimediaManager.getInstance().loadImageFromZip(this.resources.getAssetPath("foreground"), 0);
            Iterator iterator2 = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 3);
            for (int i = 0; i < bufferedImage.getWidth(null); ++i) {
                for (int j = 0; j < bufferedImage.getHeight(null); ++j) {
                    if (bufferedImage.getRGB(i, j) == -1) {
                        ((BufferedImage)((Object)iterator2)).setRGB(i, j, 0);
                        continue;
                    }
                    ((BufferedImage)((Object)iterator2)).setRGB(i, j, ((BufferedImage)((Object)iterator)).getRGB(i, j));
                }
            }
            this.foreground = iterator2;
        }
        this.backgroundMusicId = l;
        if (l == -1L) {
            this.playBackgroundMusic();
        }
        for (BufferedImage bufferedImage : scene.getItemReferences()) {
            if (!new FunctionalConditions(bufferedImage.getConditions()).allConditionsOk() || !itemSummary.isItemNormal(bufferedImage.getTargetId())) continue;
            for (Item item : chapter.getItems()) {
                if (!bufferedImage.getTargetId().equals(item.getId())) continue;
                FunctionalItem functionalItem = new FunctionalItem(item, (ElementReference)bufferedImage);
                this.items.add(functionalItem);
            }
        }
        for (BufferedImage bufferedImage : scene.getCharacterReferences()) {
            if (!new FunctionalConditions(bufferedImage.getConditions()).allConditionsOk()) continue;
            for (NPC nPC : chapter.getCharacters()) {
                if (!bufferedImage.getTargetId().equals(nPC.getId())) continue;
                FunctionalNPC functionalNPC = new FunctionalNPC(nPC, (ElementReference)bufferedImage);
                this.npcs.add(functionalNPC);
            }
        }
        for (BufferedImage bufferedImage : scene.getActiveAreas()) {
            if (!new FunctionalConditions(bufferedImage.getConditions()).allConditionsOk()) continue;
            this.areas.add(new FunctionalActiveArea((ActiveArea)bufferedImage, bufferedImage.getInfluenceArea()));
        }
        for (BufferedImage bufferedImage : scene.getBarriers()) {
            if (!new FunctionalConditions(bufferedImage.getConditions()).allConditionsOk()) continue;
            this.barriers.add(new FunctionalBarrier((Barrier)bufferedImage));
        }
        for (BufferedImage bufferedImage : scene.getAtrezzoReferences()) {
            if (!new FunctionalConditions(bufferedImage.getConditions()).allConditionsOk()) continue;
            for (Atrezzo atrezzo : chapter.getAtrezzo()) {
                if (!bufferedImage.getTargetId().equals(atrezzo.getId())) continue;
                FunctionalAtrezzo functionalAtrezzo = new FunctionalAtrezzo(atrezzo, (ElementReference)bufferedImage);
                this.atrezzo.add(functionalAtrezzo);
            }
        }
        this.updateOffset();
    }

    public FunctionalScene(long l) {
        this.backgroundMusicId = l;
        if (l == -1L) {
            this.playBackgroundMusic();
        }
    }

    public void updateScene() {
        FunctionalElement functionalElement2;
        Object object22;
        this.updateResources();
        this.player.updateResources();
        Chapter chapter = Game.getInstance().getCurrentChapterData();
        for (Object object22 : this.scene.getItemReferences()) {
            if (new FunctionalConditions(object22.getConditions()).allConditionsOk()) {
                boolean bl = false;
                for (FunctionalItem functionalItem : this.items) {
                    if (object22 != functionalItem.getReference()) continue;
                    functionalItem.updateResources();
                    bl = true;
                }
                if (bl || !Game.getInstance().getItemSummary().isItemNormal(object22.getTargetId())) continue;
                for (Item item : chapter.getItems()) {
                    if (!object22.getTargetId().equals(item.getId())) continue;
                    functionalElement2 = new FunctionalItem(item, (ElementReference)object22);
                    this.items.add((FunctionalItem)functionalElement2);
                }
                continue;
            }
            FunctionalItem functionalItem = null;
            for (FunctionalItem functionalItem2 : this.items) {
                if (functionalItem2.getReference() != object22) continue;
                functionalItem = functionalItem2;
            }
            if (functionalItem == null) continue;
            this.items.remove(functionalItem);
        }
        for (Object object22 : this.scene.getCharacterReferences()) {
            if (new FunctionalConditions(object22.getConditions()).allConditionsOk()) {
                boolean bl = false;
                for (FunctionalNPC functionalNPC : this.npcs) {
                    if (object22 != functionalNPC.getReference()) continue;
                    functionalNPC.updateResources();
                    bl = true;
                }
                if (bl) continue;
                for (NPC nPC : chapter.getCharacters()) {
                    if (!object22.getTargetId().equals(nPC.getId())) continue;
                    functionalElement2 = new FunctionalNPC(nPC, (ElementReference)object22);
                    this.npcs.add((FunctionalNPC)functionalElement2);
                }
                continue;
            }
            FunctionalNPC functionalElement2 = null;
            for (FunctionalNPC functionalNPC : this.npcs) {
                if (functionalNPC.getReference() != object22) continue;
                functionalElement2 = functionalNPC;
            }
            if (functionalElement2 == null) continue;
            this.npcs.remove(functionalElement2);
        }
        for (Object object22 : this.scene.getActiveAreas()) {
            if (!new FunctionalConditions(object22.getConditions()).allConditionsOk()) continue;
            boolean bl = false;
            for (FunctionalActiveArea functionalActiveArea : this.areas) {
                if (!object22.getId().equals(functionalActiveArea.getItem().getId())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.areas.add(new FunctionalActiveArea((ActiveArea)object22, object22.getInfluenceArea()));
        }
        this.barriers.clear();
        for (Object object22 : this.scene.getBarriers()) {
            if (!new FunctionalConditions(object22.getConditions()).allConditionsOk()) continue;
            this.barriers.add(new FunctionalBarrier((Barrier)object22));
        }
        for (Object object22 : this.scene.getAtrezzoReferences()) {
            if (new FunctionalConditions(object22.getConditions()).allConditionsOk()) {
                boolean bl = false;
                for (FunctionalAtrezzo functionalAtrezzo : this.atrezzo) {
                    if (object22 != functionalAtrezzo.getReference()) continue;
                    functionalAtrezzo.updateResources();
                    bl = true;
                }
                if (bl) continue;
                for (Atrezzo atrezzo : chapter.getAtrezzo()) {
                    if (!object22.getTargetId().equals(atrezzo.getId())) continue;
                    functionalElement2 = new FunctionalAtrezzo(atrezzo, (ElementReference)object22);
                    this.atrezzo.add((FunctionalAtrezzo)functionalElement2);
                }
                continue;
            }
            FunctionalAtrezzo object4 = null;
            for (FunctionalAtrezzo functionalAtrezzo : this.atrezzo) {
                if (functionalAtrezzo.getReference() != object22) continue;
                object4 = functionalAtrezzo;
            }
            if (object4 == null) continue;
            this.atrezzo.remove(object4);
        }
        ArrayList arrayList = new ArrayList();
        for (FunctionalActiveArea functionalActiveArea : this.areas) {
            boolean bl = false;
            for (FunctionalElement functionalElement2 : this.scene.getActiveAreas()) {
                if (!functionalElement2.getId().equals(functionalActiveArea.getItem().getId()) || !new FunctionalConditions(functionalElement2.getConditions()).allConditionsOk()) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(functionalActiveArea);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            FunctionalActiveArea functionalActiveArea = (FunctionalActiveArea)object22.next();
            this.areas.remove(functionalActiveArea);
        }
    }

    public void updateResources() {
        Resources resources = this.createResourcesBlock();
        if (this.resources != resources) {
            this.resources = resources;
            this.showsOffsetArrows = false;
            if (this.resources.existAsset("background")) {
                this.background = MultimediaManager.getInstance().loadImageFromZip(this.resources.getAssetPath("background"), 0);
            }
            if (Game.getInstance().isTransparent() && this.background != null && this.background.getWidth(null) > 800) {
                this.showsOffsetArrows = true;
            }
            if (this.foreground != null) {
                this.foreground.flush();
            }
            this.foreground = null;
            if (this.background != null && this.resources.existAsset("foreground")) {
                BufferedImage bufferedImage = (BufferedImage)this.background;
                BufferedImage bufferedImage2 = (BufferedImage)MultimediaManager.getInstance().loadImageFromZip(this.resources.getAssetPath("foreground"), 0);
                BufferedImage bufferedImage3 = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(bufferedImage2.getWidth(null), bufferedImage2.getHeight(null), 3);
                for (int i = 0; i < bufferedImage2.getWidth(null); ++i) {
                    for (int j = 0; j < bufferedImage2.getHeight(null); ++j) {
                        if (bufferedImage2.getRGB(i, j) == -1) {
                            bufferedImage3.setRGB(i, j, 0);
                            continue;
                        }
                        bufferedImage3.setRGB(i, j, bufferedImage.getRGB(i, j));
                    }
                }
                this.foreground = bufferedImage3;
            }
            this.playBackgroundMusic();
        }
    }

    public Scene getScene() {
        return this.scene;
    }

    public FunctionalNPC getNPC(String string) {
        FunctionalNPC functionalNPC = null;
        if (string != null) {
            for (FunctionalNPC functionalNPC2 : this.npcs) {
                if (!functionalNPC2.getElement().getId().equals(string)) continue;
                functionalNPC = functionalNPC2;
            }
        }
        return functionalNPC;
    }

    public ArrayList<FunctionalNPC> getNPCs() {
        return this.npcs;
    }

    public ArrayList<FunctionalItem> getItems() {
        return this.items;
    }

    public ArrayList<FunctionalActiveArea> getActiveAreas() {
        return this.areas;
    }

    @Override
    public void update(long l) {
        this.playBackgroundMusic();
        for (FunctionalItem functionalElement : this.items) {
            functionalElement.update(l);
        }
        for (FunctionalActiveArea functionalActiveArea : this.areas) {
            functionalActiveArea.update(l);
        }
        for (FunctionalNPC functionalNPC : this.npcs) {
            functionalNPC.update(l);
        }
        this.player.update(l);
        if (this.updateOffset() && Game.getInstance().getLastMouseEvent() != null && Game.getInstance().getLastMouseEvent().getID() != 506) {
            Game.getInstance().mouseMoved(Game.getInstance().getLastMouseEvent());
        } else if (this.updateOffset() && Game.getInstance().getLastMouseEvent() != null) {
            Game.getInstance().mouseDragged(Game.getInstance().getLastMouseEvent());
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    private boolean updateOffset() {
        if (Game.getInstance().isTransparent()) {
            return false;
        }
        boolean bl = false;
        int n = this.background.getWidth(null);
        if (this.player.getX() - (float)this.offsetX > 500.0f) {
            bl = true;
            this.offsetX = (int)((float)this.offsetX + (this.player.getX() - (float)this.offsetX - 500.0f));
            if (this.offsetX + 800 > n) {
                this.offsetX = n - 800;
            }
        } else if (this.player.getX() - (float)this.offsetX < 300.0f) {
            bl = true;
            this.offsetX = (int)((float)this.offsetX - (300.0f - this.player.getX() + (float)this.offsetX));
            if (this.offsetX < 0) {
                this.offsetX = 0;
            }
        }
        return bl;
    }

    public void updateOffset(boolean bl) {
        int n = this.background.getWidth(null);
        if (bl) {
            this.offsetX += 10;
            if (this.offsetX + 800 > n) {
                this.offsetX = n - 800;
            }
        } else {
            this.offsetX -= 10;
            if (this.offsetX < 0) {
                this.offsetX = 0;
            }
        }
    }

    @Override
    public void draw() {
        GUI.getInstance().addBackgroundToDraw(this.background, this.offsetX);
        for (FunctionalItem functionalElement : this.items) {
            functionalElement.draw();
        }
        for (FunctionalNPC functionalNPC : this.npcs) {
            functionalNPC.draw();
        }
        for (FunctionalAtrezzo functionalAtrezzo : this.atrezzo) {
            functionalAtrezzo.draw();
        }
        this.player.draw();
        if (this.foreground != null) {
            GUI.getInstance().addForegroundToDraw(this.foreground, this.offsetX);
        }
        GUI.getInstance().setShowsOffestArrows(this.showsOffsetArrows, this.moveOffsetRight, this.moveOffsetLeft);
    }

    public FunctionalElement getElementInside(int n, int n2, FunctionalElement functionalElement) {
        Object object;
        Object object2 = null;
        if (this.isInsideOffsetArrow(n, n2)) {
            return null;
        }
        List<FunctionalElement> list = GUI.getInstance().getElementsToInteract();
        for (int i = list.size() - 1; i >= 0 && object2 == null; --i) {
            object = list.get(i);
            if (object == functionalElement || !((FunctionalElement)object).isPointInside(n + Game.getInstance().getFunctionalScene().getOffsetX(), n2)) continue;
            object2 = object;
        }
        object = this.areas.iterator();
        while (object.hasNext() && object2 == null) {
            FunctionalActiveArea functionalActiveArea = (FunctionalActiveArea)object.next();
            if (functionalActiveArea == functionalElement || !functionalActiveArea.isPointInside(n + Game.getInstance().getFunctionalScene().getOffsetX(), n2)) continue;
            object2 = functionalActiveArea;
        }
        return object2;
    }

    public boolean isInsideOffsetArrow(int n, int n2) {
        int n3;
        this.moveOffsetRight = false;
        this.moveOffsetLeft = false;
        if (this.showsOffsetArrows && n2 >= (n3 = 300) - 30 && n2 <= n3 + 30) {
            int n4 = (int)Math.ceil(Math.sqrt(900.0 - Math.pow(n2 - n3, 2.0)));
            if (n <= n4) {
                this.moveOffsetLeft = true;
            }
            if (n >= 800 - n4) {
                this.moveOffsetRight = true;
            }
        }
        return this.moveOffsetLeft || this.moveOffsetRight;
    }

    public FunctionalTrajectory getTrajectory() {
        return this.trajectory;
    }

    public Exit getExitInside(int n, int n2) {
        if (this.isInsideOffsetArrow(n, n2)) {
            return null;
        }
        for (Exit exit : this.scene.getExits()) {
            if (!exit.isPointInside(n + this.offsetX, n2) || !new FunctionalConditions(exit.getConditions()).allConditionsOk() && !exit.isHasNotEffects().booleanValue()) continue;
            return exit;
        }
        return null;
    }

    public void mouseClicked(int n, int n2) {
        if (this.isInsideOffsetArrow(n, n2)) {
            System.out.println("Is inside offset arrow");
            if (this.moveOffsetRight) {
                this.updateOffset(true);
            }
            if (this.moveOffsetLeft) {
                this.updateOffset(false);
            }
        }
        FunctionalElement functionalElement = this.getElementInside(n + this.offsetX, n2, null);
        if (Game.getInstance().getActionManager().getActionSelected() == 6 || functionalElement == null) {
            int n3 = n + this.offsetX;
            int n4 = n2;
            FunctionalGoTo functionalGoTo = new FunctionalGoTo(null, n3, n4);
            int n5 = functionalGoTo.getPosX();
            int n6 = functionalGoTo.getPosY();
            Exit exit = this.getExitInside(n5 - this.offsetX, n6);
            this.player.cancelActions();
            if (exit == null && !this.player.isTransparent()) {
                this.player.addAction(functionalGoTo);
            } else if (!this.player.isTransparent() && this.getTrajectory().hasTrajectory()) {
                functionalGoTo = new FunctionalGoTo(null, n3, n4, Game.getInstance().getFunctionalPlayer(), new FunctionalExitArea(exit, exit.getInfluenceArea()));
                if (functionalGoTo.canGetTo()) {
                    this.player.addAction(new FunctionalExit(exit));
                    this.player.addAction(functionalGoTo);
                }
            } else if (!this.player.isTransparent() && functionalGoTo.canGetTo()) {
                this.player.addAction(new FunctionalExit(exit));
                this.player.addAction(functionalGoTo);
            } else if (this.player.isTransparent()) {
                this.player.addAction(new FunctionalExit(exit));
            }
            Game.getInstance().getActionManager().setActionSelected(6);
        } else {
            Game.getInstance().getFunctionalPlayer().performActionInElement(functionalElement);
        }
    }

    public int[] checkPlayerAgainstBarriers(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        for (FunctionalBarrier functionalBarrier : this.barriers) {
            int[] nArray2 = functionalBarrier.checkPlayerAgainstBarrier(this.player, nArray[0], nArray[1]);
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1];
        }
        return nArray;
    }

    public long getBackgroundMusicId() {
        return this.backgroundMusicId;
    }

    public void stopBackgroundMusic() {
        MultimediaManager.getInstance().stopPlaying(this.backgroundMusicId);
    }

    public void playBackgroundMusic() {
        if (Game.getInstance().getOptions().isMusicActive()) {
            if (this.resources.existAsset("bgmusic")) {
                if (!MultimediaManager.getInstance().isPlaying(this.backgroundMusicId)) {
                    this.backgroundMusicId = MultimediaManager.getInstance().loadMusic(this.resources.getAssetPath("bgmusic"), true);
                    MultimediaManager.getInstance().startPlaying(this.backgroundMusicId);
                }
            } else {
                MultimediaManager.getInstance().stopPlayingMusic();
            }
        }
    }

    @Override
    public Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.scene.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)this.scene.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)this.scene.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("background", "gui/defaultassets/NRB_background.jpg"));
            resources.addAsset(new Asset("foreground", "gui/defaultassets/NRB_foreground.png"));
            resources.addAsset(new Asset("hardmap", "gui/defaultassets/NRB_hardmap.png"));
        }
        return resources;
    }

    public void freeMemory() {
        this.resources = null;
        this.background = null;
        this.foreground = null;
        this.trajectory = null;
        this.areas = null;
        this.atrezzo = null;
        this.barriers = null;
        this.items = null;
        this.npcs = null;
    }
}

