/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalSide;
import java.util.ArrayList;
import java.util.List;

public class FunctionalPath
implements Comparable<FunctionalPath> {
    private float length;
    private List<FunctionalSide> sides;
    private float destX;
    private float destY;
    private boolean getsTo;
    private float distance;

    public FunctionalPath(float f, float f2, List<FunctionalSide> list) {
        this.length = f;
        this.sides = new ArrayList<FunctionalSide>(list);
        this.distance = f2;
        this.getsTo = false;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public void setGetsTo(boolean bl) {
        this.getsTo = bl;
    }

    public boolean isGetsTo() {
        return this.getsTo;
    }

    public void updateUpTo(float f, float f2, float f3) {
        if (f < this.distance) {
            this.destX = f2;
            this.destY = f3;
            this.distance = f;
        }
    }

    public List<FunctionalSide> getSides() {
        return this.sides;
    }

    public List<Trajectory.Side> getNormalSides() {
        ArrayList<Trajectory.Side> arrayList = new ArrayList<Trajectory.Side>();
        for (FunctionalSide functionalSide : this.sides) {
            arrayList.add(functionalSide.getSide());
        }
        return arrayList;
    }

    public float getLength() {
        return this.length;
    }

    public float getDistance() {
        return this.distance;
    }

    public void addSide(float f, float f2, FunctionalSide functionalSide) {
        this.sides.add(functionalSide);
        this.length += f;
        this.distance = f2;
    }

    public FunctionalPath newFunctionalPath(float f, float f2, FunctionalSide functionalSide) {
        if (this.sides.contains(functionalSide)) {
            return null;
        }
        for (FunctionalSide functionalSide2 : this.sides) {
            if (functionalSide2.getSide() != functionalSide.getSide()) continue;
            return null;
        }
        FunctionalPath functionalPath = new FunctionalPath(this.length, this.distance, this.sides);
        functionalPath.addSide(f, f2, functionalSide);
        return functionalPath;
    }

    @Override
    public int compareTo(FunctionalPath functionalPath) {
        if (this.getsTo && !functionalPath.getsTo) {
            return 1;
        }
        if (!this.getsTo && functionalPath.getsTo) {
            return -1;
        }
        int n = (int)(functionalPath.distance - this.distance);
        if (Math.abs(n) < 200) {
            return (int)(functionalPath.length - this.length);
        }
        return n;
    }

    public float getDestX() {
        return this.destX;
    }

    public float getDestY() {
        return this.destY;
    }

    public void print() {
        for (FunctionalSide functionalSide : this.sides) {
            System.out.print(functionalSide.getStartNode().getID() + "->");
        }
        System.out.println(this.sides.get(this.sides.size() - 1).getEndNode().getID());
    }
}

