/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.Element;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.npc.NPCIdle;
import es.eucm.eadventure.engine.core.control.animations.npc.NPCState;
import es.eucm.eadventure.engine.core.control.animations.npc.NPCTalking;
import es.eucm.eadventure.engine.core.control.animations.npc.NPCWalking;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.TalkingElement;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class FunctionalNPC
extends FunctionalElement
implements TalkingElement {
    public static final int IDLE = 0;
    public static final int TALK = 1;
    public static final int WALK = 2;
    public static final float DEFAULT_SPEED = 120.0f;
    protected float speedX;
    protected float speedY;
    private NPC npc;
    private Color textFrontColor;
    private Color textBorderColor;
    private Color bubbleBkgColor;
    private Color bubbleBorderColor;
    private Resources resources;
    private NPCState idleAnimation;
    private NPCTalking talkingAnimation;
    private NPCState walkingAnimation;
    private NPCState currentState;
    private int destX;
    private int destY;
    private int currentDirection = -1;
    private InfluenceArea influenceArea;
    private ElementReference reference;

    public FunctionalNPC(NPC nPC, ElementReference elementReference) {
        this(nPC, elementReference.getInfluenceArea(), elementReference.getX(), elementReference.getY(), elementReference.getLayer());
        this.reference = elementReference;
        this.scale = elementReference.getScale();
    }

    private FunctionalNPC(NPC nPC, InfluenceArea influenceArea, int n, int n2, int n3) {
        super(n, n2);
        this.npc = nPC;
        this.layer = n3;
        this.influenceArea = influenceArea;
        this.textFrontColor = this.generateColor(nPC.getTextFrontColor());
        this.textBorderColor = this.generateColor(nPC.getTextBorderColor());
        this.bubbleBkgColor = this.generateColor(nPC.getBubbleBkgColor());
        this.bubbleBorderColor = this.generateColor(nPC.getBubbleBorderColor());
        this.resources = this.createResourcesBlock();
        this.idleAnimation = new NPCIdle(this);
        this.talkingAnimation = new NPCTalking(this);
        this.walkingAnimation = new NPCWalking(this);
        this.destX = 0;
        this.destY = 0;
        this.currentState = this.idleAnimation;
        this.currentState.initialize();
        this.speedX = 0.0f;
        this.speedY = 0.0f;
    }

    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public boolean isAlwaysSynthesizer() {
        return this.npc.isAlwaysSynthesizer();
    }

    @Override
    public String getPlayerVoice() {
        return this.npc.getVoice();
    }

    public Color getTextFrontColor() {
        return this.textFrontColor;
    }

    public Color getTextBorderColor() {
        return this.textBorderColor;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void updateResources() {
        Resources resources = this.createResourcesBlock();
        if (this.resources != resources) {
            this.resources = resources;
            this.idleAnimation.loadResources();
            this.talkingAnimation.loadResources();
            this.walkingAnimation.loadResources();
        }
    }

    @Override
    public Element getElement() {
        return this.npc;
    }

    @Override
    public int getWidth() {
        return this.currentState.getImage().getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.currentState.getImage().getHeight(null);
    }

    @Override
    public void draw() {
        this.currentState.draw(Math.round(this.x), Math.round(this.y), this.scale, this.layer, this);
    }

    @Override
    public void update(long l) {
        this.currentState.update(l);
        this.currentState.getCurrentAnimation().update(l);
    }

    @Override
    public boolean isPointInside(float f, float f2) {
        boolean bl = false;
        int n = (int)(f - (this.x - (float)this.getWidth() * this.scale / 2.0f));
        int n2 = (int)(f2 - (this.y - (float)this.getHeight() * this.scale));
        if (n >= 0 && (float)n < (float)this.getWidth() * this.scale && n2 >= 0 && (float)n2 < (float)this.getHeight() * this.scale) {
            BufferedImage bufferedImage = (BufferedImage)this.currentState.getImage();
            int n3 = bufferedImage.getRGB((int)((float)n / this.scale), (int)((float)n2 / this.scale)) >>> 24;
            bl = n3 > 128;
        }
        return bl;
    }

    public boolean dragTo(FunctionalNPC functionalNPC) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalNPC.getNPC().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalNPC.getNPC().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public boolean dragTo(FunctionalItem functionalItem) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalItem.getItem().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 8 || !action.getTargetId().equals(functionalItem.getItem().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canPerform(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                bl = true;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                bl = false;
            }
        }
        return bl;
    }

    public void setState(int n) {
        switch (n) {
            case 0: {
                this.currentState = this.idleAnimation;
                break;
            }
            case 1: {
                this.currentState = this.talkingAnimation;
                break;
            }
            case 2: {
                this.currentState = this.walkingAnimation;
            }
        }
        this.currentState.setResetAnimation(true);
        this.currentState.initialize();
    }

    @Override
    public void speak(String string, boolean bl) {
        String string2 = Game.getInstance().processText(string);
        DebugLog.player("NPC " + this.npc.getId() + " says " + string2);
        this.talkingAnimation.setText(string2, bl);
        this.setState(1);
    }

    public void speak(String string) {
        this.speak(string, false);
    }

    @Override
    public void speak(String string, String string2, boolean bl) {
        String string3 = Game.getInstance().processText(string);
        DebugLog.player("NPC " + this.npc.getId() + " says " + string3 + " with audio");
        this.talkingAnimation.setAudio(string2);
        this.talkingAnimation.setText(string3, bl);
        this.setState(1);
    }

    public void speak(String string, String string2) {
        this.speak(string, string2, false);
    }

    @Override
    public void speakWithFreeTTS(String string, String string2, boolean bl) {
        String string3 = Game.getInstance().processText(string);
        DebugLog.player("NPC " + this.npc.getId() + " speaks with text-to-speech");
        this.speak(string3, bl);
        this.draw();
        if (string2 != null && !string2.equals("")) {
            this.talkingAnimation.setSpeakFreeTTS(string3, string2);
        }
    }

    public void speakWithFreeTTS(String string, String string2) {
        this.speakWithFreeTTS(string, string2, false);
    }

    @Override
    public void stopTalking() {
        this.talkingAnimation.setAudio(null);
        this.talkingAnimation.stopTTSTalking();
        this.setState(0);
    }

    @Override
    public boolean isTalking() {
        return this.currentState == this.talkingAnimation;
    }

    @Override
    public boolean examine() {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 0 || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 0 || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean use() {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 4 || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 4 || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    public void setDestiny(int n, int n2) {
        this.destX = n;
        this.destY = n2;
    }

    public int getDestX() {
        return this.destX;
    }

    public int getDestY() {
        return this.destY;
    }

    public boolean isWalking() {
        return this.currentState == this.walkingAnimation;
    }

    public void setDirection(int n) {
        this.currentDirection = n;
    }

    public int getDirection() {
        return this.currentDirection;
    }

    public float getSpeedX() {
        return this.speedX;
    }

    public void setSpeedX(float f) {
        this.speedX = f;
    }

    public float getSpeedY() {
        return this.speedY;
    }

    public void setSpeedY(float f) {
        this.speedY = f;
    }

    @Override
    public Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.npc.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)this.npc.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)this.npc.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("speakdown", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("speakup", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("speakright", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("walkdown", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("walkup", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("walkright", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("useright", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("standup", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("standdown", "gui/defaultassets/NRB_animation_01.png"));
            resources.addAsset(new Asset("standright", "gui/defaultassets/NRB_animation_01.png"));
        }
        return resources;
    }

    @Override
    public Action getFirstValidAction(int n) {
        for (Action action : this.npc.getActions()) {
            if (action.getType() != n || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            return action;
        }
        for (Action action : this.npc.getActions()) {
            if (action.getType() != n || !action.isActivatedNotEffects()) continue;
            return action;
        }
        return null;
    }

    @Override
    public CustomAction getFirstValidCustomAction(String string) {
        for (Action action : this.npc.getActions()) {
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            return (CustomAction)action;
        }
        for (Action action : this.npc.getActions()) {
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !action.isActivatedNotEffects()) continue;
            return (CustomAction)action;
        }
        return null;
    }

    @Override
    public CustomAction getFirstValidCustomInteraction(String string) {
        for (Action action : this.npc.getActions()) {
            if (action.getType() != 6 || !((CustomAction)action).getName().equals(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            return (CustomAction)action;
        }
        for (Action action : this.npc.getActions()) {
            if (action.getType() != 6 || !((CustomAction)action).getName().equals(string) || !action.isActivatedNotEffects()) continue;
            return (CustomAction)action;
        }
        return null;
    }

    public boolean custom(String string) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.npc.getActions().size() && !bl; ++n) {
            action = this.npc.getAction(n);
            if (action.getType() != 5 || !((CustomAction)action).getName().equals(string) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    @Override
    public InfluenceArea getInfluenceArea() {
        return this.influenceArea;
    }

    @Override
    public Color getBubbleBkgColor() {
        return this.bubbleBkgColor;
    }

    @Override
    public Color getBubbleBorderColor() {
        return this.bubbleBorderColor;
    }

    @Override
    public boolean getShowsSpeechBubbles() {
        return this.npc.getShowsSpeechBubbles();
    }

    public ElementReference getReference() {
        return this.reference;
    }

    @Override
    public boolean canBeDragged() {
        boolean bl = false;
        for (int i = 0; i < this.npc.getActions().size() && !bl; ++i) {
            Action action = this.npc.getAction(i);
            if (action.getType() != 8) continue;
            if (new FunctionalConditions(action.getConditions()).allConditionsOk()) {
                bl = true;
                continue;
            }
            if (!action.isActivatedNotEffects()) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canBeUsedAlone() {
        return true;
    }
}

