/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FunctionalExitArea
extends FunctionalItem {
    private Exit exit;
    private Polygon polygon;

    private static Item buildItem(Exit exit) {
        Item item = new Item("", "", "", "");
        item.addResources(new Resources());
        return item;
    }

    private static int calculateX(Exit exit) {
        return exit.getX() + exit.getWidth() / 2;
    }

    private static int calculateY(Exit exit) {
        return exit.getY() + exit.getHeight();
    }

    public FunctionalExitArea(Exit exit, InfluenceArea influenceArea) {
        super(FunctionalExitArea.buildItem(exit), null, FunctionalExitArea.calculateX(exit), FunctionalExitArea.calculateY(exit));
        this.exit = exit;
        this.influenceArea = influenceArea;
        BufferedImage bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(exit.getWidth(), exit.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(0, 0, 0, 0);
        graphics2D.setColor(color);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, exit.getWidth(), exit.getHeight()));
        graphics2D.dispose();
        this.image = bufferedImage;
        if (!exit.isRectangular()) {
            this.polygon = new Polygon();
            for (Point point : exit.getPoints()) {
                this.polygon.addPoint(point.x, point.y);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.exit.getWidth();
    }

    @Override
    public int getHeight() {
        return this.exit.getHeight();
    }

    public Exit getExit() {
        return this.exit;
    }

    @Override
    public boolean isPointInside(float f, float f2) {
        boolean bl = false;
        if (!this.exit.isRectangular()) {
            return this.polygon.contains(f, f2);
        }
        int n = (int)(f - (this.x - (float)(this.getWidth() / 2)));
        int n2 = (int)(f2 - (this.y - (float)this.getHeight()));
        bl = n >= 0 && n < this.getWidth() && n2 >= 0 && n2 < this.getHeight();
        return bl;
    }

    @Override
    public boolean giveTo(FunctionalNPC functionalNPC) {
        return false;
    }

    @Override
    public boolean grab() {
        return false;
    }
}

