/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.Element;
import es.eucm.eadventure.engine.core.control.functionaldata.Renderable;
import es.eucm.eadventure.engine.core.control.functionaldata.functionalhighlights.FunctionalHighlight;
import java.awt.Color;

public abstract class FunctionalElement
implements Renderable {
    protected float x;
    protected float y;
    protected float scale;
    protected int layer;
    protected FunctionalHighlight highlight;

    public FunctionalElement(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scale = 1.0f;
        this.layer = -1;
        this.highlight = null;
    }

    public abstract Element getElement();

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getScale() {
        return this.scale;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public abstract boolean isPointInside(float var1, float var2);

    public abstract boolean canPerform(int var1);

    public boolean canBeUsedAlone() {
        return false;
    }

    public boolean examine() {
        return false;
    }

    public boolean isInInventory() {
        return false;
    }

    protected Color generateColor(String string) {
        return new Color(Integer.valueOf(string.substring(1), 16));
    }

    public abstract Action getFirstValidAction(int var1);

    public abstract CustomAction getFirstValidCustomAction(String var1);

    public abstract CustomAction getFirstValidCustomInteraction(String var1);

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public abstract InfluenceArea getInfluenceArea();

    public boolean use() {
        return false;
    }

    public void setHighlight(FunctionalHighlight functionalHighlight) {
        this.highlight = functionalHighlight;
    }

    public FunctionalHighlight getHighlight() {
        return this.highlight;
    }

    public boolean canBeDragged() {
        return false;
    }
}

