/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.FlagCondition;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalStateCondition;
import es.eucm.eadventure.common.data.chapter.conditions.VarCondition;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.VarSummary;

public class FunctionalConditions {
    private Conditions conditions;

    public FunctionalConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public boolean allConditionsOk() {
        boolean bl = true;
        bl = this.evaluateSimpleConditionsWithAND();
        for (int i = 0; i < this.conditions.getEitherConditionsBlockCount(); ++i) {
            Conditions conditions = this.conditions.getEitherBlock(i);
            if (!bl) continue;
            bl = new FunctionalConditions(conditions).evaluateSimpleConditionsWithOR();
        }
        return bl;
    }

    private boolean evaluateSimpleConditionsWithAND() {
        boolean bl = true;
        FlagSummary flagSummary = Game.getInstance().getFlags();
        VarSummary varSummary = Game.getInstance().getVars();
        for (Condition condition : this.conditions.getSimpleConditions()) {
            Object object;
            if (!bl) continue;
            if (condition.getType() == 1) {
                object = (FlagCondition)condition;
                bl = object.isActiveState() == flagSummary.isActiveFlag(condition.getId());
                continue;
            }
            if (condition.getType() == 0) {
                object = (VarCondition)condition;
                int n = varSummary.getValue(object.getId());
                int n2 = object.getState();
                int n3 = object.getValue();
                bl = this.evaluateVarCondition(n2, n3, n);
                continue;
            }
            if (condition.getType() != 2) continue;
            object = condition.getId();
            GlobalStateCondition globalStateCondition = (GlobalStateCondition)condition;
            GlobalState globalState = Game.getInstance().getCurrentChapterData().getGlobalState((String)object);
            bl = globalStateCondition.getState() == 8 ^ new FunctionalConditions((Conditions)globalState).allConditionsOk();
        }
        return bl;
    }

    private boolean evaluateVarCondition(int n, int n2, int n3) {
        if (n == 4) {
            return n3 == n2;
        }
        if (n == 3) {
            return n3 >= n2;
        }
        if (n == 2) {
            return n3 > n2;
        }
        if (n == 5) {
            return n3 <= n2;
        }
        if (n == 6) {
            return n3 < n2;
        }
        return false;
    }

    private boolean evaluateSimpleConditionsWithOR() {
        boolean bl = false;
        FlagSummary flagSummary = Game.getInstance().getFlags();
        VarSummary varSummary = Game.getInstance().getVars();
        for (Condition condition : this.conditions.getSimpleConditions()) {
            Object object;
            if (bl) continue;
            if (condition.getType() == 1) {
                object = (FlagCondition)condition;
                bl = object.isActiveState() == flagSummary.isActiveFlag(condition.getId());
                continue;
            }
            if (condition.getType() == 0) {
                object = (VarCondition)condition;
                int n = varSummary.getValue(object.getId());
                int n2 = object.getState();
                int n3 = object.getValue();
                bl = this.evaluateVarCondition(n2, n3, n);
                continue;
            }
            if (condition.getType() != 2) continue;
            object = condition.getId();
            GlobalStateCondition globalStateCondition = (GlobalStateCondition)condition;
            GlobalState globalState = Game.getInstance().getCurrentChapterData().getGlobalState((String)object);
            bl = globalStateCondition.getState() == 8 ^ new FunctionalConditions((Conditions)globalState).allConditionsOk();
        }
        return bl;
    }
}

