/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.auxiliar.ImageTransformer;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public abstract class FunctionalBook {
    protected Point nextPage;
    protected Point previousPage;
    protected Dimension nextPageDimension;
    protected Dimension previousPageDimension;
    protected Book book;
    protected int currentPage;
    protected Image background;
    protected BufferedImage currentArrowLeft;
    protected BufferedImage currentArrowRight;
    protected BufferedImage arrowLeftNormal;
    protected BufferedImage arrowLeftOver;
    protected BufferedImage arrowRightNormal;
    protected BufferedImage arrowRightOver;
    protected int numPages;

    protected FunctionalBook(Book book) {
        this.book = book;
        Resources resources = this.createResourcesBlock(this.book);
        this.loadImages(resources);
        this.previousPage = this.book.getPreviousPagePoint();
        this.nextPage = this.book.getNextPagePoint();
        if (this.previousPage == null || this.nextPage == null) {
            this.setDefaultArrowsPosition();
        }
    }

    public boolean isInNextPage(int n, int n2) {
        if (this.nextPage.getX() < (double)n && (double)n < this.nextPage.getX() + this.nextPageDimension.getWidth() && this.nextPage.getY() < (double)n2 && (double)n2 < this.nextPage.getY() + this.nextPageDimension.getHeight()) {
            boolean bl = false;
            int n3 = n - this.nextPage.x;
            int n4 = n2 - this.nextPage.y;
            try {
                int n5 = this.currentArrowRight.getRGB(n3, n4) >>> 24;
                bl = n5 > 128;
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public boolean isInPreviousPage(int n, int n2) {
        if (this.previousPage.x < n && (double)n < (double)this.previousPage.x + this.previousPageDimension.getWidth() && this.previousPage.y < n2 && n2 < this.previousPage.y + this.previousPageDimension.height) {
            boolean bl = false;
            int n3 = n - this.previousPage.x;
            int n4 = n2 - this.previousPage.y;
            try {
                int n5 = this.currentArrowLeft.getRGB(n3, n4) >>> 24;
                bl = n5 > 128;
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Book getBook() {
        return this.book;
    }

    public abstract boolean isInLastPage();

    public abstract boolean isInFirstPage();

    public abstract void nextPage();

    public abstract void previousPage();

    protected void loadImages(Resources resources) {
        this.background = MultimediaManager.getInstance().loadImageFromZip(resources.getAssetPath("background"), 0);
        try {
            this.arrowLeftNormal = this.toBufferedImage(MultimediaManager.getInstance().loadImageFromZip(resources.getAssetPath("arrowLeftNormal"), 0));
        }
        catch (Exception exception) {
            this.arrowLeftNormal = null;
        }
        try {
            this.arrowRightNormal = this.toBufferedImage(MultimediaManager.getInstance().loadImageFromZip(resources.getAssetPath("arrowRightNormal"), 0));
        }
        catch (Exception exception) {
            this.arrowRightNormal = null;
        }
        try {
            this.arrowLeftOver = this.toBufferedImage(MultimediaManager.getInstance().loadImageFromZip(resources.getAssetPath("arrowLeftOver"), 0));
        }
        catch (Exception exception) {
            this.arrowLeftOver = null;
        }
        try {
            this.arrowRightOver = this.toBufferedImage(MultimediaManager.getInstance().loadImageFromZip(resources.getAssetPath("arrowRightOver"), 0));
        }
        catch (Exception exception) {
            this.arrowRightOver = null;
        }
        if (this.arrowLeftNormal == null) {
            if (this.arrowLeftOver != null) {
                this.arrowLeftNormal = this.arrowLeftOver;
            } else if (this.arrowRightNormal != null) {
                this.arrowLeftNormal = (BufferedImage)ImageTransformer.getInstance().getScaledImage((Image)this.arrowRightNormal, -1.0f, 1.0f);
            } else if (this.arrowRightOver != null) {
                this.arrowLeftNormal = (BufferedImage)ImageTransformer.getInstance().getScaledImage((Image)this.arrowRightOver, -1.0f, 1.0f);
            } else {
                this.loadDefaultArrows();
            }
        }
        if (this.arrowRightNormal == null) {
            this.arrowRightNormal = this.arrowRightOver != null ? this.arrowRightOver : (BufferedImage)ImageTransformer.getInstance().getScaledImage((Image)this.arrowLeftNormal, -1.0f, 1.0f);
        }
        if (this.arrowLeftOver == null) {
            this.arrowLeftOver = this.arrowLeftNormal;
        }
        if (this.arrowRightOver == null) {
            this.arrowRightOver = (BufferedImage)ImageTransformer.getInstance().getScaledImage((Image)this.arrowLeftOver, -1.0f, 1.0f);
        }
        this.previousPageDimension = new Dimension(this.arrowLeftNormal.getWidth(null), this.arrowLeftNormal.getHeight(null));
        this.nextPageDimension = new Dimension(this.arrowRightNormal.getWidth(null), this.arrowRightNormal.getHeight(null));
        this.currentArrowLeft = this.arrowLeftNormal;
        this.currentArrowRight = this.arrowRightNormal;
    }

    private void loadDefaultArrows() {
        this.arrowLeftNormal = this.toBufferedImage(MultimediaManager.getInstance().loadImageFromZip("assets/special/DefaultLeftNormalArrow.png", 0));
        if (this.arrowLeftNormal == null) {
            this.arrowLeftNormal = this.toBufferedImage(MultimediaManager.getInstance().loadImage("gui/defaultassets/DefaultLeftNormalArrow.png", 2));
        }
        this.arrowRightNormal = (BufferedImage)ImageTransformer.getInstance().getScaledImage((Image)this.arrowLeftNormal, -1.0f, 1.0f);
        this.arrowLeftOver = (BufferedImage)MultimediaManager.getInstance().loadImageFromZip("assets/special/DefaultLeftOverArrow.png", 0);
        if (this.arrowLeftOver == null) {
            this.arrowLeftOver = this.toBufferedImage(MultimediaManager.getInstance().loadImage("gui/defaultassets/DefaultLeftOverArrow.png", 2));
        }
        this.arrowRightOver = (BufferedImage)ImageTransformer.getInstance().getScaledImage((Image)this.arrowLeftOver, -1.0f, 1.0f);
    }

    private void setDefaultArrowsPosition() {
        int n;
        int n2 = n = 20;
        int n3 = this.background.getHeight(null) - (int)this.previousPageDimension.getHeight() - n;
        int n4 = this.background.getWidth(null) - (int)this.nextPageDimension.getWidth() - n;
        int n5 = this.background.getHeight(null) - (int)this.nextPageDimension.getHeight() - n;
        this.previousPage = new Point(n2, n3);
        this.nextPage = new Point(n4, n5);
    }

    protected Resources createResourcesBlock(Book book) {
        Resources resources = null;
        for (int i = 0; i < book.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)book.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)book.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("background", "gui/defaultassets/NRB_background.jpg"));
        }
        return resources;
    }

    public void draw(Graphics graphics) {
        graphics.drawImage(this.background, 0, 0, this.background.getWidth(null), this.background.getHeight(null), null);
        if (!this.isInFirstPage()) {
            graphics.drawImage(this.currentArrowLeft, this.previousPage.x, this.previousPage.y, this.previousPageDimension.width, this.previousPageDimension.height, null);
        }
        graphics.drawImage(this.currentArrowRight, this.nextPage.x, this.nextPage.y, this.nextPageDimension.width, this.nextPageDimension.height, null);
    }

    public void mouseOverPreviousPage(boolean bl) {
        this.currentArrowLeft = !bl ? this.arrowLeftNormal : this.arrowLeftOver;
    }

    public void mouseOverNextPage(boolean bl) {
        this.currentArrowRight = !bl ? this.arrowRightNormal : this.arrowRightOver;
    }

    public BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = FunctionalBook.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }
}

