/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.Atrezzo;
import es.eucm.eadventure.common.data.chapter.elements.Element;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class FunctionalAtrezzo
extends FunctionalElement {
    protected Resources resources;
    protected Image image;
    private Image oldImage = null;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int width;
    private int height;
    private float oldScale = -1.0f;
    private Image oldOriginalImage = null;
    protected Atrezzo atrezzo;
    private ElementReference reference;

    public FunctionalAtrezzo(Atrezzo atrezzo, ElementReference elementReference) {
        this(atrezzo, elementReference.getX(), elementReference.getY());
        this.reference = elementReference;
        this.layer = elementReference.getLayer();
        this.scale = elementReference.getScale();
    }

    public FunctionalAtrezzo(Atrezzo atrezzo, int n, int n2) {
        super(n, n2);
        this.atrezzo = atrezzo;
        this.scale = 1.0f;
        Image image = null;
        this.resources = this.createResourcesBlock();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        if (this.resources.existAsset("image")) {
            image = multimediaManager.loadImageFromZip(this.resources.getAssetPath("image"), 0);
            this.removeTransparentParts(image);
        }
    }

    private void removeTransparentParts(Image image) {
        this.x1 = image.getWidth(null);
        this.y1 = image.getHeight(null);
        this.x2 = 0;
        this.y2 = 0;
        this.width = this.x1;
        this.height = this.y1;
        for (int i = 0; i < image.getWidth(null); ++i) {
            boolean bl = true;
            for (int j = 0; j < image.getHeight(null); ++j) {
                boolean bl2 = true;
                BufferedImage bufferedImage = (BufferedImage)image;
                int n = bufferedImage.getRGB(i, j) >>> 24;
                if (n <= 0) continue;
                if (bl) {
                    this.x1 = Math.min(this.x1, i);
                }
                if (bl2) {
                    this.y1 = Math.min(this.y1, j);
                }
                bl = false;
                bl2 = false;
                this.x2 = Math.max(this.x2, i);
                this.y2 = Math.max(this.y2, j);
            }
        }
        this.image = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(this.x2 - this.x1, this.y2 - this.y1, 3);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.drawImage(image, 0, 0, this.x2 - this.x1, this.y2 - this.y1, this.x1, this.y1, this.x2, this.y2, null);
        graphics2D.dispose();
    }

    public void updateResources() {
        Resources resources = this.createResourcesBlock();
        if (this.resources != resources) {
            this.resources = resources;
            MultimediaManager multimediaManager = MultimediaManager.getInstance();
            Image image = null;
            if (this.resources.existAsset("image")) {
                image = multimediaManager.loadImageFromZip(this.resources.getAssetPath("image"), 0);
                this.removeTransparentParts(image);
            }
        }
    }

    public Atrezzo getAtrezzo() {
        return this.atrezzo;
    }

    @Override
    public Element getElement() {
        return this.atrezzo;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void update(long l) {
    }

    @Override
    public void draw() {
        int n = Math.round(this.x + (float)this.x1 * this.scale - (float)this.getWidth() * this.scale / 2.0f) - Game.getInstance().getFunctionalScene().getOffsetX();
        int n2 = Math.round(this.y + (float)this.y1 * this.scale - (float)this.getHeight() * this.scale);
        if (this.scale != 1.0f) {
            Image image;
            if (this.image == this.oldOriginalImage && this.scale == this.oldScale) {
                image = this.oldImage;
            } else {
                image = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(Math.round((float)this.image.getWidth(null) * this.scale), Math.round((float)this.image.getHeight(null) * this.scale), 3);
                ((Graphics2D)image.getGraphics()).drawImage(this.image, AffineTransform.getScaleInstance(this.scale, this.scale), null);
                this.oldImage = image;
                this.oldOriginalImage = this.image;
                this.oldScale = this.scale;
            }
            if (this.layer == -1) {
                GUI.getInstance().addElementToDraw(image, n, n2, Math.round(this.y), Math.round(this.y), this.highlight, this);
            } else {
                GUI.getInstance().addElementToDraw(image, n, n2, this.layer, Math.round(this.y), this.highlight, this);
            }
        } else if (this.layer == -1) {
            GUI.getInstance().addElementToDraw(this.image, n, n2, Math.round(this.y), Math.round(this.y), this.highlight, this);
        } else {
            GUI.getInstance().addElementToDraw(this.image, n, n2, this.layer, Math.round(this.y), this.highlight, this);
        }
    }

    @Override
    public boolean isPointInside(float f, float f2) {
        return false;
    }

    @Override
    public boolean isInInventory() {
        return false;
    }

    @Override
    public boolean examine() {
        return false;
    }

    @Override
    public boolean canBeUsedAlone() {
        return false;
    }

    @Override
    public Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.atrezzo.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(((Resources)this.atrezzo.getResources().get(i)).getConditions()).allConditionsOk()) continue;
            resources = (Resources)this.atrezzo.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("image", "gui/defaultassets/NRB_image.png"));
        }
        return resources;
    }

    @Override
    public boolean canPerform(int n) {
        return false;
    }

    @Override
    public Action getFirstValidAction(int n) {
        return null;
    }

    @Override
    public CustomAction getFirstValidCustomAction(String string) {
        return null;
    }

    @Override
    public CustomAction getFirstValidCustomInteraction(String string) {
        return null;
    }

    @Override
    public InfluenceArea getInfluenceArea() {
        return null;
    }

    public ElementReference getReference() {
        return this.reference;
    }
}

