/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.functionaldata;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FunctionalActiveArea
extends FunctionalItem {
    private ActiveArea activeArea;
    private Polygon polygon;

    private static Item buildItem(ActiveArea activeArea) {
        Item item = new Item(activeArea.getId(), activeArea.getName(), activeArea.getDescription(), activeArea.getDetailedDescription());
        for (Action action : activeArea.getActions()) {
            item.addAction(action);
        }
        item.addResources(new Resources());
        return item;
    }

    private static int calculateX(ActiveArea activeArea) {
        return activeArea.getX() + activeArea.getWidth() / 2;
    }

    private static int calculateY(ActiveArea activeArea) {
        return activeArea.getY() + activeArea.getHeight();
    }

    public FunctionalActiveArea(ActiveArea activeArea, InfluenceArea influenceArea) {
        super(FunctionalActiveArea.buildItem(activeArea), null, FunctionalActiveArea.calculateX(activeArea), FunctionalActiveArea.calculateY(activeArea));
        this.activeArea = activeArea;
        this.influenceArea = influenceArea;
        BufferedImage bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(activeArea.getWidth(), activeArea.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(0, 0, 0, 0);
        graphics2D.setColor(color);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, activeArea.getWidth(), activeArea.getHeight()));
        graphics2D.dispose();
        this.image = bufferedImage;
        if (!activeArea.isRectangular()) {
            this.polygon = new Polygon();
            for (Point point : activeArea.getPoints()) {
                this.polygon.addPoint(point.x, point.y);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.activeArea.getWidth();
    }

    @Override
    public int getHeight() {
        return this.activeArea.getHeight();
    }

    public ActiveArea getActiveArea() {
        return this.activeArea;
    }

    @Override
    public boolean isPointInside(float f, float f2) {
        boolean bl = false;
        if (!this.activeArea.isRectangular()) {
            return this.polygon.contains(f, f2);
        }
        int n = (int)(f - (this.x - (float)(this.getWidth() / 2)));
        int n2 = (int)(f2 - (this.y - (float)this.getHeight()));
        bl = n >= 0 && n < this.getWidth() && n2 >= 0 && n2 < this.getHeight();
        return bl;
    }

    @Override
    public boolean giveTo(FunctionalNPC functionalNPC) {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 2 || !action.getTargetId().equals(functionalNPC.getElement().getId()) || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 2 || !action.getTargetId().equals(functionalNPC.getElement().getId()) || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean grab() {
        Action action;
        int n;
        boolean bl = false;
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 1 || !new FunctionalConditions(action.getConditions()).allConditionsOk()) continue;
            FunctionalEffects.storeAllEffects(action.getEffects());
            bl = true;
        }
        for (n = 0; n < this.item.getActions().size() && !bl; ++n) {
            action = this.item.getAction(n);
            if (action.getType() != 1 || !action.isActivatedNotEffects()) continue;
            FunctionalEffects.storeAllEffects(action.getNotEffects());
            bl = true;
        }
        return bl;
    }
}

