/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.config;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class ConfigData {
    private static ConfigData instance;
    private String configFile;
    private String exportsPath;
    private String reportsPath;
    private String languageFile;
    private String aboutFile;

    public static String getLanguangeFile() {
        return ConfigData.instance.languageFile;
    }

    public static String getLanguage() {
        return ConfigData.instance.languageFile.substring(0, ConfigData.instance.languageFile.length() - 4);
    }

    public static String getAboutFile() {
        return ConfigData.instance.aboutFile;
    }

    public static void setLanguangeFile(String string, String string2) {
        ConfigData.instance.languageFile = string;
        ConfigData.instance.aboutFile = string2;
    }

    public static void setAboutFile(String string) {
        ConfigData.instance.aboutFile = string;
    }

    public static void loadFromXML(String string) {
        instance = new ConfigData(string);
    }

    public static void loadFromData(String string, String string2) {
        instance = new ConfigData(string, string2);
    }

    public static void storeToXML() {
        if (ConfigData.instance.configFile != null) {
            Properties properties = new Properties();
            if (ConfigData.instance.languageFile != null) {
                properties.setProperty("LanguageFile", ConfigData.instance.languageFile);
            }
            if (ConfigData.instance.aboutFile != null) {
                properties.setProperty("AboutFile", ConfigData.instance.aboutFile);
            }
            if (ConfigData.instance.exportsPath != null) {
                properties.setProperty("ExportsDirectory", ConfigData.instance.exportsPath);
            }
            if (ConfigData.instance.reportsPath != null) {
                properties.setProperty("ReportsDirectory", ConfigData.instance.reportsPath);
            }
            try {
                properties.storeToXML(new FileOutputStream(ConfigData.instance.configFile), "<e-Adventure> engine configuration");
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ConfigData(String string) {
        this.configFile = string;
        Properties properties = new Properties();
        try {
            properties.loadFromXML(new FileInputStream(this.configFile));
            this.languageFile = properties.getProperty("LanguageFile");
            this.aboutFile = properties.getProperty("AboutFile");
            this.exportsPath = properties.getProperty("ExportsDirectory");
            if (this.exportsPath != null) {
                ReleaseFolders.setExportsPath((String)this.exportsPath);
            }
            this.reportsPath = properties.getProperty("ReportsDirectory");
            if (this.reportsPath != null) {
                ReleaseFolders.setReportsPath((String)this.reportsPath);
            }
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            this.checkConsistency();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.checkConsistency();
        }
        catch (IOException iOException) {
            this.checkConsistency();
        }
    }

    private void checkConsistency() {
        if (this.languageFile == null) {
            this.languageFile = ReleaseFolders.getLanguageFilePath((String)"en_EN");
        }
        if (this.aboutFile == null) {
            this.aboutFile = ReleaseFolders.getAboutFilePath((String)"en_EN");
        }
        if (this.exportsPath == null) {
            // empty if block
        }
        if (this.reportsPath == null) {
            // empty if block
        }
    }

    private ConfigData(String string, String string2) {
        this.configFile = null;
        this.languageFile = string;
        this.aboutFile = string2;
    }

    public static String getDefaultLanguage() {
        return "en_EN";
    }
}

