/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.animations.npc;

import es.eucm.eadventure.common.auxiliar.TTask;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.npc.NPCState;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.util.Timer;
import java.util.TimerTask;

public class NPCTalking
extends NPCState {
    private String text;
    private long audioId = -1L;
    private long totalTime;
    private int timeTalking;
    private TTask task = new TTask();
    private boolean keepShowing;

    public NPCTalking(FunctionalNPC functionalNPC) {
        super(functionalNPC);
    }

    public void setText(String string, boolean bl) {
        this.text = string;
        this.keepShowing = bl;
        float f = 1.0f;
        if (Game.getInstance().getOptions().getTextSpeed() == 0) {
            f = 1.5f;
        }
        if (Game.getInstance().getOptions().getTextSpeed() == 2) {
            f = 0.8f;
        }
        this.timeTalking = (int)((float)(300 * string.split(" ").length) * f);
        if (this.timeTalking < (int)(1400.0f * f)) {
            this.timeTalking = (int)(1400.0f * f);
        }
    }

    public void setAudio(String string) {
        if (string == null) {
            if (this.audioId != -1L) {
                MultimediaManager.getInstance().stopPlayingInmediately(this.audioId);
                while (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.audioId = -1L;
            }
        } else {
            if (this.audioId != -1L) {
                MultimediaManager.getInstance().stopPlayingInmediately(this.audioId);
                while (MultimediaManager.getInstance().isPlaying(this.audioId)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.audioId = MultimediaManager.getInstance().loadSound(string, false);
            MultimediaManager.getInstance().startPlaying(this.audioId);
            while (!MultimediaManager.getInstance().isPlaying(this.audioId)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setSpeakFreeTTS(String string, String string2) {
        this.task = new TTask(string2, string);
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.task, 0L);
    }

    public void stopTTSTalking() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public void update(long l) {
        this.totalTime += l;
        if (!(this.keepShowing || this.totalTime <= (long)this.timeTalking || this.audioId != -1L && MultimediaManager.getInstance().isPlaying(this.audioId) || !this.task.isEnd())) {
            this.npc.setState(0);
            this.stopTTSTalking();
        }
    }

    @Override
    public void draw(int n, int n2, float f, int n3, FunctionalElement functionalElement) {
        super.draw(n, n2, f, n3, functionalElement);
        if (this.text != null && !this.text.equals("")) {
            if (this.npc.getShowsSpeechBubbles()) {
                GUI.getInstance().addTextToDraw(this.text, n - Game.getInstance().getFunctionalScene().getOffsetX(), n2 - Math.round((float)this.npc.getHeight() * f) - 15, this.npc.getTextFrontColor(), this.npc.getTextBorderColor(), this.npc.getBubbleBkgColor(), this.npc.getBubbleBorderColor(), true);
            } else {
                GUI.getInstance().addTextToDraw(this.text, n - Game.getInstance().getFunctionalScene().getOffsetX(), n2 - Math.round((float)this.npc.getHeight() * f), this.npc.getTextFrontColor(), this.npc.getTextBorderColor());
            }
        }
    }

    @Override
    public void initialize() {
        this.totalTime = 0L;
        if (Game.getInstance().getGameDescriptor().getPlayerMode() == 0 || Game.getInstance().getFunctionalPlayer().getX() >= this.npc.getX()) {
            this.setCurrentDirection(2);
        } else {
            this.setCurrentDirection(3);
        }
    }

    @Override
    public void loadResources() {
        Resources resources = this.npc.getResources();
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        this.animations[2] = resources.getAssetPath("speakright") != null && !resources.getAssetPath("speakright").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("speakright").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("speakright"), false, 0) : multimediaManager.loadAnimation(resources.getAssetPath("speakleft"), true, 0);
        this.animations[3] = resources.getAssetPath("speakleft") != null && !resources.getAssetPath("speakleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("speakleft").equals("assets/special/EmptyAnimation.eaa") ? multimediaManager.loadAnimation(resources.getAssetPath("speakleft"), false, 0) : multimediaManager.loadAnimation(resources.getAssetPath("speakright"), true, 0);
        this.animations[0] = multimediaManager.loadAnimation(resources.getAssetPath("speakup"), false, 0);
        this.animations[1] = multimediaManager.loadAnimation(resources.getAssetPath("speakdown"), false, 0);
    }
}

