/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.animations;

import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.gui.GUI;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public abstract class AnimationState {
    protected Animation[] animations = new Animation[4];
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    private float oldScale = -1.0f;
    private Image oldImage = null;
    private Image oldOriginalImage = null;
    protected boolean resetAnimation = false;

    public abstract void update(long var1);

    public abstract void initialize();

    public void updateAnimation() {
        int n = -1;
        if (this.getCurrentDirection() == -1) {
            this.setCurrentDirection(1);
        }
        if (Game.getInstance().isIsometric()) {
            double d = Math.atan2(this.getVelocityY(), this.getVelocityX());
            n = d < -2.6179938779914944 ? 1 : (d < 0.0 ? 2 : (d < 2.6179938779914944 ? 0 : 3));
            n = 3;
        } else if (Math.abs(this.getVelocityY()) > Math.abs(this.getVelocityX())) {
            if (this.getVelocityY() >= 0.0f) {
                n = 1;
            } else if (this.getVelocityY() < 0.0f) {
                n = 0;
            }
        } else if (this.getVelocityX() >= 0.0f) {
            n = 2;
        } else if (this.getVelocityX() < 0.0f) {
            n = 3;
        }
        if (Math.abs(this.getVelocityX()) != 0.0f && Math.abs(this.getVelocityY()) != 0.0f && n != -1 && (n != this.getCurrentDirection() || this.isResetAnimation())) {
            this.setCurrentDirection(n);
            this.animations[this.getCurrentDirection()].start();
            this.resetAnimation = false;
        }
    }

    public Image getImage() {
        return this.getCurrentAnimation().getImage();
    }

    public Animation getCurrentAnimation() {
        return this.animations[this.getCurrentDirection()];
    }

    public void draw(int n, int n2, float f, int n3, FunctionalElement functionalElement) {
        Image image = this.getCurrentAnimation().getImage();
        int n4 = (int)((float)n - (float)image.getWidth(null) * f / 2.0f - (float)Game.getInstance().getFunctionalScene().getOffsetX());
        int n5 = (int)((float)n2 - (float)image.getHeight(null) * f);
        if (image == this.oldOriginalImage && f == this.oldScale) {
            image = this.oldImage;
        } else if (f != 1.0f) {
            this.oldOriginalImage = image;
            BufferedImage bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(Math.round((float)image.getWidth(null) * f), Math.round((float)image.getHeight(null) * f), 3);
            ((Graphics2D)bufferedImage.getGraphics()).drawImage(image, AffineTransform.getScaleInstance(f, f), null);
            image = bufferedImage;
        } else {
            this.oldOriginalImage = image;
        }
        this.oldScale = f;
        this.oldImage = image;
        if (n3 == -1 || n3 == -2) {
            GUI.getInstance().addPlayerToDraw(image, n4, n5, Math.round(n2), Math.round(n2));
        } else {
            GUI.getInstance().addElementToDraw(image, n4, n5, n3, Math.round(n2), null, functionalElement);
        }
    }

    public abstract void loadResources();

    protected abstract void setCurrentDirection(int var1);

    protected abstract int getCurrentDirection();

    protected abstract float getVelocityX();

    protected abstract float getVelocityY();

    public boolean isResetAnimation() {
        return this.resetAnimation;
    }

    public void setResetAnimation(boolean bl) {
        this.resetAnimation = bl;
    }
}

