/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VarSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Var> vars = new HashMap<String, Var>();
    private static final int DEFAULT_VALUE = 0;
    private boolean debug;
    private List<String> changes;

    public VarSummary(List<String> list, boolean bl) {
        if (bl) {
            this.changes = new ArrayList<String>();
        }
        this.debug = bl;
        for (String string : list) {
            Var var = new Var(string, 0, false);
            this.vars.put(string, var);
        }
    }

    public void setVarValue(String string, int n) {
        Var var = this.vars.get(string);
        if (var != null) {
            var.setValue(n);
        }
        if (this.debug) {
            this.changes.add(string);
        }
    }

    public void incrementVar(String string, int n) {
        Var var = this.vars.get(string);
        if (var != null) {
            var.increment(n);
        }
        if (this.debug) {
            this.changes.add(string);
        }
    }

    public void decrementVar(String string, int n) {
        Var var = this.vars.get(string);
        if (var != null) {
            var.decrement(n);
        }
        if (this.debug) {
            this.changes.add(string);
        }
    }

    public boolean existVar(String string) {
        return this.vars.containsKey(string);
    }

    public int getValue(String string) {
        Var var = this.vars.get(string);
        if (var != null) {
            return var.getValue();
        }
        return 0;
    }

    public String[] getVarNames() {
        return this.vars.keySet().toArray(new String[0]);
    }

    public String[] getVarValues() {
        String[] stringArray = this.getVarNames();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.vars.get(stringArray[i]) == null) continue;
            stringArray2[i] = Integer.toString(this.vars.get(stringArray[i]).getValue());
        }
        return stringArray2;
    }

    public Map<String, Var> getVars() {
        return this.vars;
    }

    public int getVarValue(String string) {
        Var var = this.vars.get(string);
        return var.getValue();
    }

    public void addVar(String string) {
        if (!this.vars.containsKey(string)) {
            Var var = new Var(string, 0, false);
            this.vars.put(string, var);
        }
    }

    public List<String> getChanges() {
        if (this.debug) {
            ArrayList<String> arrayList = new ArrayList<String>(this.changes);
            this.changes.clear();
            return arrayList;
        }
        return new ArrayList<String>();
    }

    public String processText(String string) {
        String string2 = "";
        if (string != null) {
            String[] stringArray = string.split("\\(");
            if (stringArray.length == 1) {
                return string;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.length() > 0 && string3.charAt(0) == '#') {
                    String[] stringArray2 = string3.split("\\)");
                    stringArray2[0] = this.evaluateExpression(stringArray2[0]);
                    stringArray[i] = stringArray2[0];
                    for (int j = 1; j < stringArray2.length; ++j) {
                        int n = i;
                        stringArray[n] = stringArray[n] + stringArray2[j];
                    }
                } else if (i > 0) {
                    stringArray[i] = "(" + string3;
                }
                string2 = string2 + stringArray[i];
            }
        }
        return string2;
    }

    public String evaluateExpression(String string) {
        if (string.contains("?") && string.contains(":")) {
            int n;
            String[] stringArray = string.substring(1).split("\\?|\\:");
            if (stringArray.length != 3) {
                return "(" + string + ")";
            }
            int n2 = 0;
            String[] stringArray2 = new String[]{new String(stringArray[0])};
            if (stringArray[0].contains(">=")) {
                n2 = 1;
                stringArray2 = stringArray[0].split(">=");
            } else if (stringArray[0].contains(">")) {
                n2 = 2;
                stringArray2 = stringArray[0].split(">");
            } else if (stringArray[0].contains("<=")) {
                n2 = 3;
                stringArray2 = stringArray[0].split("<=");
            } else if (stringArray[0].contains("<")) {
                n2 = 4;
                stringArray2 = stringArray[0].split("<");
            } else if (stringArray[0].contains("==")) {
                n2 = 5;
                stringArray2 = stringArray[0].split("==");
            }
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray2[n].replaceAll(" ", "");
            }
            if (n2 == 0) {
                return "(" + string + ")";
            }
            n = 0;
            try {
                n = Integer.parseInt(stringArray2[1]);
            }
            catch (NumberFormatException numberFormatException) {
                return "(" + string + ")";
            }
            Var var = this.vars.get(stringArray2[0]);
            if (var == null) {
                return "(" + string + ")";
            }
            int n3 = var.getValue();
            if (n2 == 1) {
                if (n3 >= n) {
                    return stringArray[1];
                }
                return stringArray[2];
            }
            if (n2 == 2) {
                if (n3 > n) {
                    return stringArray[1];
                }
                return stringArray[2];
            }
            if (n2 == 3) {
                if (n3 <= n) {
                    return stringArray[1];
                }
                return stringArray[2];
            }
            if (n2 == 4) {
                if (n3 < n) {
                    return stringArray[1];
                }
                return stringArray[2];
            }
            if (n2 == 5) {
                if (n3 == n) {
                    return stringArray[1];
                }
                return stringArray[2];
            }
            return "(" + string + ")";
        }
        String string2 = string.substring(1);
        Var var = this.vars.get(string2);
        if (var != null) {
            return "" + var.getValue();
        }
        return "(" + string + ")";
    }

    private class Var {
        String name;
        int value;
        boolean external;

        Var(String string, int n, boolean bl) {
            this.name = string;
            this.value = n;
            this.external = bl;
        }

        public int getValue() {
            return this.value;
        }

        void setValue(int n) {
            this.value = n;
        }

        void increment(int n) {
            this.value += n;
        }

        void decrement(int n) {
            this.value -= n;
        }

        boolean isExternal() {
            return this.external;
        }
    }
}

