/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.common.data.chapter.elements.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ItemSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> normalItems = new ArrayList();
    private ArrayList<String> grabbedItems = new ArrayList();
    private ArrayList<String> consumedItems = new ArrayList();

    public ItemSummary(List<Item> list) {
        for (Item item : list) {
            this.normalItems.add(item.getId());
        }
    }

    public ArrayList<String> getNormalItems() {
        return this.normalItems;
    }

    public ArrayList<String> getGrabbedItems() {
        return this.grabbedItems;
    }

    public ArrayList<String> getConsumedItems() {
        return this.consumedItems;
    }

    public boolean isItemNormal(String string) {
        return this.normalItems.contains(string);
    }

    public boolean isItemGrabbed(String string) {
        return this.grabbedItems.contains(string);
    }

    public boolean isItemConsumed(String string) {
        return this.consumedItems.contains(string);
    }

    public void grabItem(String string) {
        if (this.normalItems.contains(string)) {
            this.normalItems.remove(string);
            this.grabbedItems.add(string);
        }
    }

    public void regenerateItem(String string) {
        if (this.consumedItems.contains(string)) {
            this.consumedItems.remove(string);
            this.normalItems.add(string);
        }
    }

    public void consumeItem(String string) {
        if (this.grabbedItems.contains(string)) {
            this.grabbedItems.remove(string);
            this.consumedItems.add(string);
        }
    }
}

