/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;

public class InputStreamDataSource
extends PullDataSource
implements SourceCloneable {
    private PullSourceStream[] pullSourceStreams;
    private String resource;

    public InputStreamDataSource(String string) {
        this.resource = string;
        this.pullSourceStreams = new PullSourceStream[1];
        this.pullSourceStreams[0] = new InputStreamPullSourceStream(string);
    }

    public PullSourceStream[] getStreams() {
        return this.pullSourceStreams;
    }

    public void connect() throws IOException {
    }

    public void disconnect() {
    }

    public String getContentType() {
        return this.pullSourceStreams[0].getContentDescriptor().getContentType();
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public DataSource createClone() {
        InputStreamDataSource inputStreamDataSource = new InputStreamDataSource(this.resource);
        MediaLocator mediaLocator = this.getLocator();
        inputStreamDataSource.setLocator(mediaLocator);
        return inputStreamDataSource;
    }

    private class InputStreamPullSourceStream
    implements PullSourceStream,
    Seekable {
        private static final int BUFFER_SIZE = 100000;
        private byte[] buffer = new byte[100000];
        private int inputStreamOffset = 0;
        private int bufferFill = 0;
        private BufferedInputStream is;
        private String resource;
        private boolean end = false;
        private long currentPosition = 0L;
        private String type = null;

        public InputStreamPullSourceStream(String string) {
            this.resource = string;
            String string2 = ResourceHandler.getExtension(this.resource);
            string2 = string2.toLowerCase();
            this.setTypeFromExtension(string2);
            this.is = new BufferedInputStream(ResourceHandler.getInstance().getResourceAsStreamFromZip(this.resource));
        }

        private void setTypeFromExtension(String string) {
            if (string.equals("mp2") || string.equals("mpa") || string.equals("mpe") || string.equals("mpeg") || string.equals("mpg") || string.equals("mpv2")) {
                this.type = "video.mpeg";
            }
            if (string.equals("mov") || string.equals("qt")) {
                this.type = "video.quicktime";
            }
            if (string.equals("lsf") || string.equals("lsx")) {
                this.type = "video.x_la_asf";
            }
            if (string.equals("asf") || string.equals("asr") || string.equals("asx")) {
                this.type = "video.x_ms_asf";
            }
            if (string.equals("avi")) {
                this.type = "video.x_msvideo";
            }
            if (string.equals("movie")) {
                this.type = "video.x-sgi-movie";
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.bufferFill == 0) {
                this.fillBuffer();
            }
            if (this.bufferFill == -1) {
                return -1;
            }
            if (this.currentPosition < (long)this.inputStreamOffset) {
                this.is = new BufferedInputStream(ResourceHandler.getInstance().getResourceAsStreamFromZip(this.resource));
                this.bufferFill = 0;
                this.inputStreamOffset = 0;
                this.end = false;
                try {
                    while (this.currentPosition > (long)(this.inputStreamOffset + this.bufferFill) && this.bufferFill != -1) {
                        this.fillBuffer();
                    }
                    if (this.bufferFill == -1) {
                        this.currentPosition = Math.min((long)(this.inputStreamOffset + this.bufferFill), this.currentPosition);
                    }
                }
                catch (Exception exception) {
                    return -1;
                }
            }
            int n3 = (int)Math.min((long)n2, (long)(this.inputStreamOffset + this.bufferFill) - this.currentPosition);
            System.arraycopy(this.buffer, (int)(this.currentPosition - (long)this.inputStreamOffset), byArray, n, n3);
            this.currentPosition += (long)n3;
            if (this.currentPosition == (long)(this.inputStreamOffset + this.bufferFill)) {
                this.fillBuffer();
            }
            if (n3 == n2) {
                return n2;
            }
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 != -1) {
                return n4 + n3;
            }
            return n3;
        }

        public boolean willReadBlock() {
            return this.bufferFill != 100000;
        }

        public boolean endOfStream() {
            return this.end;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName((String)this.type));
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public boolean isRandomAccess() {
            return true;
        }

        public long seek(long l) {
            if (l < (long)this.inputStreamOffset) {
                this.is = new BufferedInputStream(ResourceHandler.getInstance().getResourceAsStreamFromZip(this.resource));
                this.bufferFill = 0;
                this.inputStreamOffset = 0;
                this.end = false;
                this.currentPosition = 0L;
            }
            try {
                while (l > (long)(this.inputStreamOffset + this.bufferFill) && this.bufferFill != -1) {
                    this.fillBuffer();
                }
                if (this.bufferFill == -1) {
                    this.currentPosition = Math.min((long)(this.inputStreamOffset + this.bufferFill), l);
                    return this.currentPosition;
                }
                this.currentPosition = l;
                return l;
            }
            catch (Exception exception) {
                return -1L;
            }
        }

        public long tell() {
            return this.currentPosition;
        }

        public void fillBuffer() throws IOException {
            this.inputStreamOffset += this.bufferFill;
            this.bufferFill = 0;
            int n = 0;
            byte[] byArray = new byte[100000];
            while (this.bufferFill < 100000 && n != -1) {
                n = this.is.read(byArray, 0, 100000);
                if (n == -1 && this.bufferFill == 0) {
                    this.bufferFill = -1;
                }
                if (n == -1) continue;
                System.arraycopy(byArray, 0, this.buffer, this.bufferFill, n);
                this.bufferFill += n;
            }
        }
    }
}

