/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.comm.AdventureApplet;
import es.eucm.eadventure.comm.manager.commManager.CommManagerGAMETEL;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.auxiliar.SpecialAssetPaths;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adventure.ChapterSummary;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.engine.adaptation.AdaptationEngine;
import es.eucm.eadventure.engine.assessment.AssessmentEngine;
import es.eucm.eadventure.engine.core.control.ActionManager;
import es.eucm.eadventure.engine.core.control.AtrezzoSummary;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.Inventory;
import es.eucm.eadventure.engine.core.control.ItemSummary;
import es.eucm.eadventure.engine.core.control.Options;
import es.eucm.eadventure.engine.core.control.TimerEventListener;
import es.eucm.eadventure.engine.core.control.TimerManager;
import es.eucm.eadventure.engine.core.control.VarSummary;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalScene;
import es.eucm.eadventure.engine.core.control.functionaldata.TalkingElement;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffect;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateBook;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateConversation;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateLoading;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateNextScene;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateOptions;
import es.eucm.eadventure.engine.core.control.gamestate.GameStatePlaying;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateRunEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateSlidescene;
import es.eucm.eadventure.engine.core.control.gamestate.GameStateVideoscene;
import es.eucm.eadventure.engine.core.data.GameText;
import es.eucm.eadventure.engine.core.data.SaveGame;
import es.eucm.eadventure.engine.core.data.SaveGameException;
import es.eucm.eadventure.engine.core.data.SaveTimer;
import es.eucm.eadventure.engine.core.gui.DebugLogPanel;
import es.eucm.eadventure.engine.core.gui.DebugValuesPanel;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.swing.JOptionPane;

public class Game
implements KeyListener,
MouseListener,
MouseMotionListener,
Runnable,
TimerEventListener,
SpecialAssetPaths {
    public static final int STATE_LOADING = 0;
    public static final int STATE_PLAYING = 1;
    public static final int STATE_SLIDE_SCENE = 2;
    public static final int STATE_NEXT_SCENE = 3;
    public static final int STATE_VIDEO_SCENE = 4;
    public static final int STATE_RUN_EFFECTS = 5;
    public static final int STATE_RUN_EFFECTS_FROM_CONVERSATION = 9;
    public static final int STATE_BOOK = 6;
    public static final int STATE_CONVERSATION = 7;
    public static final int STATE_OPTIONS = 8;
    private String adventurePath;
    private String adventureName;
    private DescriptorData gameDescriptor;
    private Chapter gameData;
    private FlagSummary flags;
    private VarSummary vars;
    private AssessmentEngine assessmentEngine;
    private AdaptationEngine adaptationEngine;
    private AdaptedState adaptedStateToExecute;
    private ItemSummary itemSummary;
    private AtrezzoSummary atrezzoSummary;
    private Inventory inventory;
    private Options options;
    private Exit nextScene;
    private Exit lastNextScene;
    private FunctionalScene functionalScene;
    private FunctionalPlayer functionalPlayer;
    private GameState currentState;
    private Stack<Boolean> isConvEffectsBlock;
    private int numberConv;
    private Stack<List<FunctionalEffect>> effectsQueue;
    private TalkingElement characterCurrentlyTalking;
    private boolean gameOver = false;
    private boolean nextChapter = false;
    private int currentChapter;
    private long totalTime = 0L;
    private Book book;
    private Conversation conversation;
    private FunctionalNPC currentNPC;
    private AdventureApplet comm;
    private static Game instance = new Game();
    private MouseEvent lastMouseEvent;
    private ActionManager actionManager;
    private TimerManager timerManager;
    private HashMap<Integer, Timer> gameTimers;
    private Stack<GameState> stackOfState;
    private MouseEvent lastPressedEvent;
    private String state = "";
    private boolean debug = false;
    private boolean fromEditor = false;
    private DebugValuesPanel debugChangesPanel;
    private DebugLogPanel debugLogPanel;
    public static boolean FINISH = false;

    public static Game getInstance() {
        return instance;
    }

    public static void create() {
        instance = new Game();
    }

    public static void create(boolean bl, boolean bl2) {
        instance = new Game();
        Game.instance.fromEditor = bl;
        Game.instance.debug = bl2;
    }

    public static void delete() {
        Game.staticStop();
        if (Game.instance.debugChangesPanel != null) {
            Game.instance.debugChangesPanel.close();
        }
        if (Game.instance.debugLogPanel != null) {
            Game.instance.debugLogPanel.close();
        }
        instance = null;
    }

    public void setAdventurePath(String string) {
        this.adventurePath = string;
    }

    public void setAdventureName(String string) {
        this.adventureName = string;
    }

    public String getAdventureName() {
        return this.adventureName;
    }

    public boolean isTransparent() {
        return this.getGameDescriptor().getPlayerMode() == 0;
    }

    private void loadCurrentChapter(Graphics2D graphics2D) {
        DebugLog.general("Loading chapter");
        MultimediaManager.getInstance().flushImagePool(0);
        MultimediaManager.getInstance().flushImagePool(2);
        MultimediaManager.getInstance().flushAnimationPool();
        System.gc();
        GameText.reloadStrings();
        MultimediaManager.getInstance().flushImagePool(1);
        ChapterSummary chapterSummary = (ChapterSummary)this.gameDescriptor.getChapterSummaries().get(this.currentChapter);
        this.gameData = Loader.loadChapterData((InputStreamCreator)ResourceHandler.getInstance(), (String)chapterSummary.getChapterPath(), new ArrayList(), (boolean)true);
        GUI.getInstance().loading(60);
        this.preLoadAnimations();
        this.flags = new FlagSummary(this.gameData.getFlags(), this.debug);
        this.vars = new VarSummary(this.gameData.getVars(), this.debug);
        this.timerManager = TimerManager.getInstance();
        this.timerManager.reset();
        if (this.gameData.getAdaptationName() != "") {
            chapterSummary.setAdaptationName(this.gameData.getAdaptationName());
        }
        if (this.gameData.getAssessmentName() != "") {
            chapterSummary.setAssessmentName(this.gameData.getAssessmentName());
        }
        AdaptedState adaptedState = null;
        if (this.gameData.hasAdaptationProfile()) {
            adaptedState = this.adaptationEngine.init(this.gameData.getSelectedAdaptationProfile());
        }
        if (this.gameData.hasAssessmentProfile()) {
            this.assessmentEngine.loadAssessmentRules(this.gameData.getSelectedAssessmentProfile());
        }
        if (!this.gameData.hasAdaptationProfile() && chapterSummary.hasAdaptationProfile()) {
            adaptedState = this.adaptationEngine.init(chapterSummary.getSelectedAdaptationProfile());
        }
        if (!this.gameData.hasAssessmentProfile() && chapterSummary.hasAssessmentProfile()) {
            this.assessmentEngine.loadAssessmentRules(chapterSummary.getSelectedAssessmentProfile());
        }
        this.actionManager = new ActionManager();
        this.itemSummary = new ItemSummary(this.gameData.getItems());
        this.atrezzoSummary = new AtrezzoSummary(this.gameData.getAtrezzo());
        this.inventory = new Inventory();
        this.effectsQueue = new Stack();
        this.effectsQueue.push(new ArrayList());
        this.isConvEffectsBlock = new Stack();
        this.numberConv = 0;
        this.stackOfState = new Stack();
        GUI.getInstance().loading(70);
        new GameStateOptions();
        Exit exit = new Exit(true, 0, 0, 40, 40);
        exit.setNextSceneId(this.gameData.getInitialGeneralScene().getId());
        this.processAdaptedState(exit, adaptedState);
        this.processAdaptedState(exit, this.adaptedStateToExecute);
        this.setNextScene(exit);
        this.functionalPlayer = new FunctionalPlayer(this.gameData.getPlayer());
        this.functionalPlayer.setTransparent(this.gameDescriptor.getPlayerMode() == 0);
        this.gameTimers = new HashMap();
        for (Timer timer : this.gameData.getTimers()) {
            int n = this.timerManager.addTimer(timer, this, timer.getTime());
            this.gameTimers.put(new Integer(n), timer);
        }
        GUI.getInstance().loading(90);
        this.currentState = new GameStateNextScene();
        this.nextChapter = false;
        DebugLog.general("Chapter loaded");
    }

    private void processAdaptedState(Exit exit, AdaptedState adaptedState) {
        if (adaptedState != null) {
            Object object2;
            if (adaptedState.getTargetId() != null) {
                boolean bl = false;
                for (Scene scene : this.gameData.getScenes()) {
                    if (!scene.getId().equals(adaptedState.getTargetId())) continue;
                    exit.setNextSceneId(adaptedState.getTargetId());
                    bl = true;
                }
                if (!bl) {
                    for (Scene scene : this.gameData.getCutscenes()) {
                        if (!scene.getId().equals(adaptedState.getTargetId())) continue;
                        exit.setNextSceneId(adaptedState.getTargetId());
                    }
                }
            }
            for (Object object2 : adaptedState.getActivatedFlags()) {
                if (!this.flags.existFlag((String)object2)) continue;
                this.flags.activateFlag((String)object2);
            }
            for (Object object2 : adaptedState.getDeactivatedFlags()) {
                if (!this.flags.existFlag((String)object2)) continue;
                this.flags.deactivateFlag((String)object2);
            }
            ArrayList arrayList = new ArrayList();
            object2 = new ArrayList();
            adaptedState.getVarsValues((List)arrayList, object2);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                String string2 = (String)object2.get(i);
                if (AdaptedState.isSetValueOp((String)string2)) {
                    String string3 = AdaptedState.getSetValueData((String)string2);
                    if (string3 == null) continue;
                    this.vars.setVarValue(string, Integer.parseInt(string3));
                    continue;
                }
                if (!this.vars.existVar(string)) continue;
                int n = this.vars.getValue(string);
                int n2 = Integer.parseInt(string2.substring(string2.indexOf(" ") + 1));
                if (AdaptedState.isIncrementOp((String)string2.substring(0, string2.indexOf(" ")))) {
                    this.vars.setVarValue(string, n + n2);
                    continue;
                }
                if (!AdaptedState.isDecrementOp((String)string2.substring(0, string2.indexOf(" ")))) continue;
                if (n - n2 >= 0) {
                    this.vars.setVarValue(string, n - n2);
                    continue;
                }
                this.vars.setVarValue(string, 0);
            }
        }
    }

    public void repaintDebug() {
        if (this.debug) {
            this.debugChangesPanel.updateUI();
            this.debugChangesPanel.validate();
            this.debugChangesPanel.repaint();
            this.debugLogPanel.updateUI();
            this.debugLogPanel.validate();
            this.debugLogPanel.repaint();
        }
    }

    public void setPlayerLayer(int n) {
        this.functionalPlayer.setLayer(n);
    }

    private void preLoadAnimations() {
        MultimediaManager multimediaManager = MultimediaManager.getInstance();
        for (Resources resources : this.gameData.getPlayer().getResources()) {
            multimediaManager.loadAnimation(resources.getAssetPath("standright"), false, 2);
            if (resources.getAssetPath("standleft") != null && !resources.getAssetPath("standleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("standleft").equals("assets/special/EmptyAnimation.eaa")) {
                multimediaManager.loadAnimation(resources.getAssetPath("standleft"), false, 2);
            } else {
                multimediaManager.loadAnimation(resources.getAssetPath("standright"), true, 2);
            }
            multimediaManager.loadAnimation(resources.getAssetPath("standup"), false, 2);
            multimediaManager.loadAnimation(resources.getAssetPath("standdown"), false, 2);
            multimediaManager.loadAnimation(resources.getAssetPath("speakright"), false, 2);
            if (resources.getAssetPath("speakleft") != null && !resources.getAssetPath("speakleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("speakleft").equals("assets/special/EmptyAnimation.eaa")) {
                multimediaManager.loadAnimation(resources.getAssetPath("speakleft"), false, 2);
            } else {
                multimediaManager.loadAnimation(resources.getAssetPath("speakright"), true, 2);
            }
            multimediaManager.loadAnimation(resources.getAssetPath("speakup"), false, 2);
            multimediaManager.loadAnimation(resources.getAssetPath("speakdown"), false, 2);
            multimediaManager.loadAnimation(resources.getAssetPath("useright"), false, 2);
            if (resources.getAssetPath("useleft") != null && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("useleft").equals("assets/special/EmptyAnimation.eaa")) {
                multimediaManager.loadAnimation(resources.getAssetPath("useleft"), false, 2);
            } else {
                multimediaManager.loadAnimation(resources.getAssetPath("useright"), true, 2);
            }
            multimediaManager.loadAnimation(resources.getAssetPath("walkright"), false, 2);
            if (resources.getAssetPath("walkleft") != null && !resources.getAssetPath("walkleft").equals("assets/special/EmptyAnimation") && !resources.getAssetPath("walkleft").equals("assets/special/EmptyAnimation.eaa")) {
                multimediaManager.loadAnimation(resources.getAssetPath("walkleft"), false, 2);
            } else {
                multimediaManager.loadAnimation(resources.getAssetPath("walkright"), true, 2);
            }
            multimediaManager.loadAnimation(resources.getAssetPath("walkup"), false, 2);
            multimediaManager.loadAnimation(resources.getAssetPath("walkdown"), false, 2);
        }
        for (Resources resources : this.gameData.getCharacters()) {
            for (Resources resources2 : resources.getResources()) {
                multimediaManager.loadAnimation(resources2.getAssetPath("standright"), false, 0);
                if (resources2.getAssetPath("standleft") != null && !resources2.getAssetPath("standleft").equals("assets/special/EmptyAnimation") && !resources2.getAssetPath("standleft").equals("assets/special/EmptyAnimation.eaa")) {
                    multimediaManager.loadAnimation(resources2.getAssetPath("standleft"), false, 0);
                } else {
                    multimediaManager.loadAnimation(resources2.getAssetPath("standright"), true, 0);
                }
                multimediaManager.loadAnimation(resources2.getAssetPath("standup"), false, 0);
                multimediaManager.loadAnimation(resources2.getAssetPath("standdown"), false, 0);
                multimediaManager.loadAnimation(resources2.getAssetPath("speakright"), false, 0);
                if (resources2.getAssetPath("speakleft") != null && !resources2.getAssetPath("speakleft").equals("assets/special/EmptyAnimation") && !resources2.getAssetPath("speakleft").equals("assets/special/EmptyAnimation.eaa")) {
                    multimediaManager.loadAnimation(resources2.getAssetPath("speakleft"), false, 0);
                } else {
                    multimediaManager.loadAnimation(resources2.getAssetPath("speakright"), true, 0);
                }
                multimediaManager.loadAnimation(resources2.getAssetPath("speakup"), false, 0);
                multimediaManager.loadAnimation(resources2.getAssetPath("speakdown"), false, 0);
                multimediaManager.loadAnimation(resources2.getAssetPath("useright"), false, 0);
                if (resources2.getAssetPath("useleft") != null && !resources2.getAssetPath("useleft").equals("assets/special/EmptyAnimation") && !resources2.getAssetPath("useleft").equals("assets/special/EmptyAnimation.eaa")) {
                    multimediaManager.loadAnimation(resources2.getAssetPath("useleft"), false, 0);
                } else {
                    multimediaManager.loadAnimation(resources2.getAssetPath("useright"), true, 0);
                }
                multimediaManager.loadAnimation(resources2.getAssetPath("walkright"), false, 0);
                if (resources2.getAssetPath("walkleft") != null && !resources2.getAssetPath("walkleft").equals("assets/special/EmptyAnimation") && !resources2.getAssetPath("walkleft").equals("assets/special/EmptyAnimation.eaa")) {
                    multimediaManager.loadAnimation(resources2.getAssetPath("walkleft"), false, 0);
                } else {
                    multimediaManager.loadAnimation(resources2.getAssetPath("walkright"), true, 0);
                }
                multimediaManager.loadAnimation(resources2.getAssetPath("walkup"), false, 0);
                multimediaManager.loadAnimation(resources2.getAssetPath("walkdown"), false, 0);
            }
        }
    }

    @Override
    public void run() {
        FINISH = false;
        if (this.debug) {
            this.debugLogPanel = new DebugLogPanel();
        }
        DebugLog.general("Log started...");
        try {
            Object object;
            this.timerManager = TimerManager.getInstance();
            this.totalTime = 0L;
            long l = 0L;
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            int n = 0;
            int n2 = 0;
            this.gameDescriptor = Loader.loadDescriptorData((InputStreamCreator)ResourceHandler.getInstance());
            if (this.gameDescriptor == null) {
                return;
            }
            this.gameDescriptor.setProjectName(this.adventureName);
            GUI.setGraphicConfig(this.gameDescriptor.getGraphicConfig());
            GUI.create();
            this.currentState = new GameStateLoading();
            if (this.comm != null) {
                object = "javascript:hideText();";
                this.comm.sendJavaScript((String)object);
            }
            GUI.getInstance().initGUI(this.gameDescriptor.getGUIType(), this.gameDescriptor.isGUICustomized());
            if (GUI.getInstance().getFrame() != null) {
                GUI.getInstance().getFrame().addKeyListener(this);
                GUI.getInstance().getFrame().addMouseListener(this);
                GUI.getInstance().getFrame().addMouseMotionListener(this);
            }
            object = GUI.getInstance().getGraphics();
            GUI.getInstance().loading(0);
            this.options = new Options();
            this.options.loadOptions(this.adventurePath, this.adventureName);
            this.adaptationEngine = new AdaptationEngine();
            this.assessmentEngine = new AssessmentEngine();
            this.currentChapter = 0;
            boolean bl = false;
            for (Object object2 : this.gameDescriptor.getChapterSummaries()) {
                AssessmentProfile assessmentProfile = AssessmentEngine.loadAssessmentProfile(object2.getAssessmentName());
                if (bl || assessmentProfile == null || !assessmentProfile.isSendByEmail()) continue;
                bl = true;
            }
            if (bl) {
                DebugLog.general("Asks for player name");
                String string = JOptionPane.showInputDialog(null, TC.get((String)"Reports.InputReportName"), TC.get((String)"Reports.NameInput"), 3);
                this.gameDescriptor.setPlayerName(string);
                this.assessmentEngine.setPlayerName(string);
            }
            GUI.getInstance().loading(10);
            while (!this.gameOver) {
                int n3 = 60;
                this.loadCurrentChapter((Graphics2D)object);
                GUI.getInstance().loading(100);
                if (this.debug) {
                    if (this.debugChangesPanel != null) {
                        GUI.getInstance().getJFrame().remove(this.debugChangesPanel);
                    }
                    this.debugChangesPanel = new DebugValuesPanel(this.flags, this.vars, this.getCurrentChapterData().getGlobalStates());
                    GUI.getInstance().getJFrame().add(this.debugChangesPanel);
                    GUI.getInstance().getJFrame().add(this.debugLogPanel);
                    GUI.getInstance().getJFrame().setAlwaysOnTop(false);
                    GUI.getInstance().getJFrame().validate();
                }
                while (!this.nextChapter && !this.gameOver) {
                    if (this.debug) {
                        this.debugChangesPanel.updateValues();
                    }
                    long l4 = System.currentTimeMillis();
                    l = l4 - l2;
                    l2 = l4;
                    this.totalTime += l;
                    if (l4 - l3 < 1000L) {
                        ++n;
                    } else {
                        l3 = l4;
                        n2 = n;
                        n = 1;
                    }
                    this.currentState.mainLoop(l, n2);
                    MultimediaManager.getInstance().update();
                    if (this.comm != null && this.comm.getCommType() == 3 && this.totalTime / 1000L > (long)n3) {
                        Object object2;
                        n3 += 60;
                        object2 = new ArrayList();
                        ((ArrayList)object2).add(new AssessmentProperty("total-time", String.valueOf(this.getTime())));
                        this.comm.notifyRelevantState((List)object2);
                    }
                    try {
                        Thread.sleep(Math.max(10L - (System.currentTimeMillis() - l4), 0L));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (!this.assessmentEngine.isEndOfChapterFeedbackDone()) {
                    Thread.sleep(100L);
                }
                if (this.getComm() != null && this.getComm().getCommType() == 4) {
                    ((CommManagerGAMETEL)this.getComm()).flush();
                }
                if (this.currentChapter != this.gameDescriptor.getChapterSummaries().size()) continue;
                this.gameOver = true;
            }
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)Game.getInstance().isFromEditor(), (String)"FATAL ERROR. This should not happen.");
        }
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stop() {
        if (this.functionalScene != null) {
            this.functionalScene.stopBackgroundMusic();
        }
        if (this.adaptationEngine != null) {
            this.adaptationEngine.stopAdaptationClock();
        }
        if (this.comm.getCommType() == 3) {
            this.comm.sendHTMLReport(this.assessmentEngine.getHTMLReportStringLAMS());
            this.comm.disconnect(null);
        } else if (this.comm.getCommType() == 0 || this.comm.getCommType() == 1) {
            this.comm.sendHTMLReport(this.assessmentEngine.getHTMLReportString());
            this.comm.disconnect(null);
        }
        Game.staticStop();
    }

    private static void staticStop() {
        if (MultimediaManager.getInstance() != null) {
            MultimediaManager.getInstance().deleteSounds();
        }
        if (GUI.getInstance() != null && GUI.getInstance().getFrame() != null) {
            GUI.getInstance().getFrame().setEnabled(false);
            GUI.getInstance().getFrame().setVisible(false);
            GUI.getInstance().getFrame().setFocusable(false);
            GUI.delete();
        }
    }

    public DescriptorData getGameDescriptor() {
        return this.gameDescriptor;
    }

    public Chapter getCurrentChapterData() {
        return this.gameData;
    }

    public FlagSummary getFlags() {
        return this.flags;
    }

    public VarSummary getVars() {
        return this.vars;
    }

    public AssessmentEngine getAssessmentEngine() {
        return this.assessmentEngine;
    }

    public ItemSummary getItemSummary() {
        return this.itemSummary;
    }

    public AtrezzoSummary getAtrezzoItemSummary() {
        return this.atrezzoSummary;
    }

    public Options getOptions() {
        return this.options;
    }

    public int getTime() {
        return (int)this.totalTime / 1000;
    }

    public void saveOptions() {
        this.options.saveOptions(this.adventurePath, this.adventureName);
    }

    public void grabItem(String string) {
        FunctionalItem functionalItem = null;
        for (FunctionalItem functionalItem2 : this.functionalScene.getItems()) {
            if (!functionalItem2.getItem().getId().equals(string)) continue;
            functionalItem = functionalItem2;
        }
        if (functionalItem == null) {
            functionalItem = new FunctionalItem(this.gameData.getItem(string), (InfluenceArea)null);
        } else {
            this.functionalScene.getItems().remove(functionalItem);
        }
        this.inventory.storeItem(functionalItem);
        this.itemSummary.grabItem(string);
    }

    public void consumeItem(String string) {
        if (this.itemSummary.isItemGrabbed(string)) {
            this.itemSummary.consumeItem(string);
            this.inventory.consumeItem(string);
        }
    }

    public void generateItem(String string) {
        if (this.itemSummary.isItemNormal(string)) {
            this.grabItem(string);
        } else if (this.itemSummary.isItemConsumed(string)) {
            this.itemSummary.regenerateItem(string);
            this.inventory.storeItem(new FunctionalItem(this.gameData.getItem(string), (InfluenceArea)null));
            this.itemSummary.grabItem(string);
        }
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public void pushCurrentState(GameState gameState) {
        this.stackOfState.push(gameState);
        ((GameStateConversation)this.currentState).setConvID(this.conversation.getId());
    }

    public void setState(int n) {
        GUI.getInstance().setDefaultCursor();
        switch (n) {
            case 0: {
                this.currentState = new GameStateLoading();
                break;
            }
            case 1: {
                this.currentState = new GameStatePlaying();
                if (this.lastMouseEvent == null) break;
                this.currentState.mouseMoved(this.lastMouseEvent);
                break;
            }
            case 2: {
                this.currentState = new GameStateSlidescene();
                break;
            }
            case 3: {
                this.currentState = new GameStateNextScene();
                break;
            }
            case 4: {
                this.currentState = new GameStateVideoscene();
                break;
            }
            case 5: {
                this.currentState = new GameStateRunEffects(this.isConvEffectsBlock.peek());
                break;
            }
            case 9: {
                this.currentState = new GameStateRunEffects(true);
                break;
            }
            case 6: {
                this.currentState = new GameStateBook();
                break;
            }
            case 7: {
                this.currentState = new GameStateConversation();
                break;
            }
            case 8: {
                this.currentState = new GameStateOptions();
            }
        }
    }

    public void evaluateState() {
        if (this.numberConv < this.stackOfState.size()) {
            this.currentState = this.stackOfState.pop();
            this.setConversation(((GameStateConversation)this.currentState).getConvID());
        } else if (!this.isEmptyFIFOinStack()) {
            this.setState(5);
        } else {
            this.setState(1);
        }
    }

    public void setGameOver() {
        this.gameOver = true;
    }

    public void goToNextChapter() {
        ++this.currentChapter;
        this.nextChapter = true;
    }

    public void goToChapter(int n) {
        this.currentChapter = n;
        this.nextChapter = true;
    }

    public void setFunctionalScene(FunctionalScene functionalScene) {
        if (this.functionalScene != null) {
            this.functionalScene.freeMemory();
            this.functionalScene = null;
            Runtime.getRuntime().gc();
        }
        this.functionalScene = functionalScene;
    }

    public FunctionalScene getFunctionalScene() {
        return this.functionalScene;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public FunctionalPlayer getFunctionalPlayer() {
        return this.functionalPlayer;
    }

    public void setNextScene(Exit exit) {
        this.lastNextScene = this.nextScene;
        this.nextScene = exit;
    }

    public Exit getNextScene() {
        return this.nextScene;
    }

    public Exit getLastScene() {
        return this.lastNextScene;
    }

    public TalkingElement getCharacterCurrentlyTalking() {
        return this.characterCurrentlyTalking;
    }

    public void setCharacterCurrentlyTalking(TalkingElement talkingElement) {
        this.characterCurrentlyTalking = talkingElement;
    }

    public void flushEffectsQueue() {
        this.effectsQueue.clear();
    }

    public void storeEffectsInQueue(List<FunctionalEffect> list, boolean bl) {
        this.isConvEffectsBlock.push(bl);
        this.effectsQueue.push(new ArrayList());
        for (int i = 0; i < list.size(); ++i) {
            this.effectsQueue.peek().add(i, list.get(i));
        }
        if (bl) {
            ++this.numberConv;
        }
        if (!(this.currentState instanceof GameStateRunEffects)) {
            this.setState(5);
        }
    }

    public FunctionalEffect getFirstElementOfTop() {
        FunctionalEffect functionalEffect = null;
        if (this.effectsQueue.size() > 1 && this.effectsQueue.peek().isEmpty()) {
            this.effectsQueue.pop();
            if (this.isConvEffectsBlock.pop().booleanValue()) {
                --this.numberConv;
            }
        } else if (this.effectsQueue.peek().size() != 0) {
            functionalEffect = this.effectsQueue.peek().remove(0);
            if (this.effectsQueue.size() > 1 && this.effectsQueue.peek().isEmpty()) {
                this.effectsQueue.pop();
                if (this.isConvEffectsBlock.pop().booleanValue()) {
                    --this.numberConv;
                }
            }
        }
        return functionalEffect;
    }

    public boolean isEmptyFIFOinStack() {
        return this.effectsQueue.peek().isEmpty();
    }

    public void endConversation() {
        if (!this.isEmptyFIFOinStack()) {
            this.setState(5);
        } else if (!this.stackOfState.isEmpty()) {
            this.evaluateState();
        } else {
            this.setState(1);
        }
    }

    public void setComm(AdventureApplet adventureApplet) {
        this.comm = adventureApplet;
        if (this.comm != null) {
            System.out.println("comm se instala bien");
        }
    }

    public boolean isAppletMode() {
        return ResourceHandler.getInstance().isRestrictedMode() && ResourceHandler.getInstance().isExtraRestriction();
    }

    public boolean isConnected() {
        if (this.comm != null) {
            return this.comm.isConnected();
        }
        return false;
    }

    public Book getBook() {
        return this.book;
    }

    public void setBook(String string) {
        this.lastNextScene = this.getNextScene();
        this.book = this.gameData.getBook(string);
    }

    public AdaptedState getAdaptedStateToExecute() {
        return this.adaptedStateToExecute;
    }

    public synchronized void setAdaptedStateToExecute(AdaptedState adaptedState) {
        this.adaptedStateToExecute = adaptedState;
    }

    public FunctionalNPC getCurrentNPC() {
        return this.currentNPC;
    }

    public void setCurrentNPC(FunctionalNPC functionalNPC) {
        this.currentNPC = functionalNPC;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public void setConversation(String string) {
        this.conversation = this.gameData.getConversation(string);
    }

    public synchronized void updateDataPendingFromState(boolean bl) {
        this.timerManager.update(bl);
        this.functionalScene.updateScene();
        if (this.gameData.hasAssessmentProfile()) {
            this.assessmentEngine.processRules();
        }
    }

    public void save(String string) {
        SaveGame saveGame = new SaveGame();
        saveGame.setVersionNumber(Integer.parseInt(this.gameDescriptor.getVersionNumber()));
        saveGame.setProjectName(this.gameDescriptor.getProjectName());
        saveGame.setTitle(this.gameDescriptor.getTitle());
        saveGame.setChapter(this.currentChapter);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        saveGame.setSaveTime(gregorianCalendar.get(5) + "/" + (gregorianCalendar.get(2) + 1) + "/" + gregorianCalendar.get(1) + " " + gregorianCalendar.get(11) + ":" + gregorianCalendar.get(12));
        saveGame.setTotalTime(this.totalTime);
        saveGame.setFlags(this.flags);
        saveGame.setVars(this.vars);
        saveGame.setIdScene(this.functionalScene.getScene().getId());
        saveGame.setItemSummary(this.itemSummary);
        saveGame.setPlayerX(this.functionalPlayer.getX());
        saveGame.setPlayerY(this.functionalPlayer.getY());
        saveGame.setTimers(this.timerManager);
        if (!saveGame.saveTxt(string)) {
            System.out.println("* Error: There has been an error, savegame ''savedgame.egame'' not saved.");
        }
    }

    public void load(String string) {
        SaveGame saveGame = new SaveGame();
        try {
            if (saveGame.loadTxt(string)) {
                this.setState(0);
                if (this.gameDescriptor.getTitle().equals(saveGame.getTitle())) {
                    String[] stringArray;
                    Object object;
                    this.currentChapter = saveGame.getChapter();
                    if (this.gameDescriptor.getChapterSummaries().get(this.currentChapter) != null) {
                        object = (ChapterSummary)this.gameDescriptor.getChapterSummaries().get(this.currentChapter);
                        this.gameData = Loader.loadChapterData((InputStreamCreator)ResourceHandler.getInstance(), (String)object.getChapterPath(), new ArrayList(), (boolean)true);
                    }
                    this.totalTime = saveGame.getTotalTime();
                    if (saveGame.getFlags() != null) {
                        this.flags = saveGame.getFlags();
                    }
                    if (saveGame.getVars() != null) {
                        this.vars = saveGame.getVars();
                    }
                    this.itemSummary = saveGame.getItemSummary();
                    this.functionalPlayer.cancelActions();
                    this.functionalPlayer.cancelAnimations();
                    if (this.gameData.getGeneralScene(saveGame.getIdScene()) != null) {
                        this.functionalScene = new FunctionalScene((Scene)this.gameData.getGeneralScene(saveGame.getIdScene()), this.functionalPlayer);
                    }
                    this.functionalPlayer.setX(saveGame.getPlayerX());
                    this.functionalPlayer.setY(saveGame.getPlayerY());
                    this.inventory = new Inventory();
                    object = this.itemSummary.getGrabbedItems();
                    Object object2 = ((ArrayList)object).iterator();
                    while (object2.hasNext()) {
                        stringArray = (String[])object2.next();
                        this.inventory.storeItem(new FunctionalItem(this.gameData.getItem((String)stringArray), (InfluenceArea)null));
                    }
                    object2 = new SaveTimer();
                    stringArray = saveGame.getLoadTimers();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n;
                            String string2 = stringArray[i];
                            String[] stringArray2 = string2.split("-");
                            boolean bl = Integer.valueOf(stringArray2[3]) == 0;
                            ((SaveTimer)object2).setState(Integer.valueOf(stringArray2[0]));
                            if (this.timerManager.isRunningState(Integer.valueOf(stringArray2[0]))) {
                                ((SaveTimer)object2).setLastUpdate(System.currentTimeMillis() / 1000L);
                                if (!bl) {
                                    ((SaveTimer)object2).setTimeUpdate(Integer.valueOf(stringArray2[1]).longValue() - Integer.valueOf(stringArray2[2]).longValue());
                                }
                            } else {
                                ((SaveTimer)object2).setLastUpdate(0L);
                                if (!bl) {
                                    ((SaveTimer)object2).setTimeUpdate(Integer.valueOf(stringArray2[1]).longValue());
                                }
                            }
                            if ((n = this.timerManager.changeValueOfTimer(i, (SaveTimer)object2)) < 0) {
                                System.out.println("* Error: There has been an error, savegame ''savedgame.egame'' not propperly loaded.");
                            }
                            if (!bl || this.assessmentEngine.getTimedAssessmentRule(new Integer(i)) == null) continue;
                            this.assessmentEngine.getTimedAssessmentRule(new Integer(i)).setStartTime(System.currentTimeMillis() / 1000L - Integer.valueOf(stringArray2[2]).longValue());
                        }
                        this.lastMouseEvent = null;
                    }
                    this.setState(1);
                } else {
                    System.out.println("* Error: There has been an error, savegame ''savedgame.egame'' not loaded.");
                }
            }
        }
        catch (SaveGameException saveGameException) {
            JOptionPane.showMessageDialog(null, "There was an error while loading the selected adventure.\nPlease check that no configuration file is missing or incorrect", "Error loading adventure", 0);
            JOptionPane.showMessageDialog(null, "The first chapter will be reloaded", "Error loading adventure", 0);
            Graphics2D graphics2D = GUI.getInstance().getGraphics();
            this.currentChapter = 0;
            this.loadCurrentChapter(graphics2D);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void removeFakeDrags(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.state = "P";
            this.lastPressedEvent = mouseEvent;
        } else if (mouseEvent.getID() == 506 && this.state.equals("P")) {
            this.state = "PD";
        } else if (mouseEvent.getID() == 502 && this.state.equals("PD")) {
            MouseEvent mouseEvent2 = new MouseEvent(this.lastPressedEvent.getComponent(), 500, this.lastPressedEvent.getWhen(), this.lastPressedEvent.getModifiers(), this.lastPressedEvent.getX(), this.lastPressedEvent.getY(), this.lastPressedEvent.getXOnScreen(), this.lastPressedEvent.getYOnScreen(), 1, this.lastPressedEvent.isPopupTrigger(), this.lastPressedEvent.getButton());
            this.currentState.mouseClicked(mouseEvent2);
            this.state = "";
            this.lastPressedEvent = null;
        } else if (mouseEvent.getID() == 500) {
            this.state = "";
            this.lastPressedEvent = null;
        } else if (mouseEvent.getID() == 503) {
            // empty if block
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.currentState.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.currentState.mouseClicked(mouseEvent);
        this.removeFakeDrags(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.currentState.mouseMoved(mouseEvent);
        this.lastMouseEvent = mouseEvent;
        this.removeFakeDrags(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.currentState.mousePressed(mouseEvent);
        this.removeFakeDrags(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.currentState.mouseReleased(mouseEvent);
        this.removeFakeDrags(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.currentState.mouseDragged(mouseEvent);
        this.lastMouseEvent = mouseEvent;
        this.removeFakeDrags(mouseEvent);
    }

    public MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    public AdventureApplet getComm() {
        return this.comm;
    }

    @Override
    public void cycleCompleted(int n, long l) {
        Timer timer = this.gameTimers.get(new Integer(n));
        FunctionalEffects.storeAllEffects(timer.getEffects());
    }

    @Override
    public void timerStarted(int n, long l) {
    }

    @Override
    public void timerStopped(int n, long l) {
        Timer timer = this.gameTimers.get(new Integer(n));
        FunctionalEffects.storeAllEffects(timer.getPostEffects());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFromEditor() {
        return this.fromEditor;
    }

    public String processText(String string) {
        return this.flags.processText(this.vars.processText(string));
    }

    public boolean showTopInventory() {
        return this.gameDescriptor.getInventoryPosition() == 2 || this.gameDescriptor.getInventoryPosition() == 1;
    }

    public boolean showBottomInventory() {
        return this.gameDescriptor.getInventoryPosition() == 3 || this.gameDescriptor.getInventoryPosition() == 1;
    }

    public boolean isShowActions() {
        return this.gameDescriptor.getDefaultClickAction() == DescriptorData.DefaultClickAction.SHOW_ACTIONS;
    }

    public boolean isIsometric() {
        return this.gameDescriptor.getPerspective() == DescriptorData.Perspective.ISOMETRIC;
    }
}

