/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlagSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Flag> flags = new HashMap<String, Flag>();
    private boolean debug;
    private List<String> changes;

    public FlagSummary(List<String> list, boolean bl) {
        if (bl) {
            this.changes = new ArrayList<String>();
        }
        this.debug = bl;
        for (String string : list) {
            Flag flag = new Flag(string, false, false);
            this.flags.put(string, flag);
        }
    }

    public void deactivateFlag(String string) {
        Flag flag = this.flags.get(string);
        if (flag != null) {
            flag.deactivate();
        }
        if (this.debug) {
            this.changes.add(string);
        }
    }

    public void activateFlag(String string) {
        Flag flag = this.flags.get(string);
        if (flag != null) {
            flag.activate();
        }
        if (this.debug) {
            this.changes.add(string);
        }
    }

    public boolean isActiveFlag(String string) {
        boolean bl = false;
        Flag flag = this.flags.get(string);
        if (flag != null) {
            bl = flag.isActive();
        }
        return bl;
    }

    public ArrayList<String> getActiveFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = this.flags.keySet();
        for (String string : set) {
            Flag flag = this.flags.get(string);
            if (flag == null || !flag.isActive()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean existFlag(String string) {
        return this.flags.containsKey(string);
    }

    public ArrayList<String> getInactiveFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = this.flags.keySet();
        for (String string : set) {
            Flag flag = this.flags.get(string);
            if (flag == null || flag.isActive()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Map<String, Flag> getFlags() {
        return this.flags;
    }

    public boolean getFlagValue(String string) {
        Flag flag = this.flags.get(string);
        return flag.active;
    }

    public void addFlag(String string) {
        if (!this.flags.containsKey(string)) {
            Flag flag = new Flag(string, false, false);
            this.flags.put(string, flag);
        }
    }

    public List<String> getChanges() {
        if (this.debug) {
            ArrayList<String> arrayList = new ArrayList<String>(this.changes);
            this.changes.clear();
            return arrayList;
        }
        return new ArrayList<String>();
    }

    public String processText(String string) {
        String string2 = "";
        if (string != null) {
            String[] stringArray = string.split("\\(");
            if (stringArray.length == 1) {
                return string;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.length() > 0 && string3.charAt(0) == '#') {
                    String[] stringArray2 = string3.split("\\)");
                    stringArray2[0] = this.evaluateExpression(stringArray2[0]);
                    stringArray[i] = stringArray2[0];
                    for (int j = 1; j < stringArray2.length; ++j) {
                        int n = i;
                        stringArray[n] = stringArray[n] + stringArray2[j];
                    }
                } else if (i > 0) {
                    stringArray[i] = "(" + string3;
                }
                string2 = string2 + stringArray[i];
            }
        }
        return string2;
    }

    public String evaluateExpression(String string) {
        if (string.contains("?") && string.contains(":")) {
            String[] stringArray = string.substring(1).split("\\?|\\:");
            if (stringArray.length != 3) {
                return "(" + string + ")";
            }
            Flag flag = this.flags.get(stringArray[0]);
            if (flag == null) {
                return "(" + string + ")";
            }
            if (flag.isActive()) {
                return stringArray[1];
            }
            return stringArray[2];
        }
        return "(" + string + ")";
    }

    private class Flag {
        String name;
        boolean active;
        boolean external;

        Flag(String string, boolean bl, boolean bl2) {
            this.name = string;
            this.active = bl;
            this.external = bl2;
        }

        public boolean isActive() {
            return this.active;
        }

        void activate() {
            this.active = true;
        }

        void deactivate() {
            this.active = false;
        }

        boolean isExternal() {
            return this.external;
        }
    }
}

