/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.VarSummary;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class DebugTableModel
extends AbstractTableModel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private FlagSummary flagSummary;
    private VarSummary varSummary;
    private List<String> ids;
    private List<String> changes;
    private List<GlobalState> globalStates;
    private boolean onlyChanges;

    public DebugTableModel(FlagSummary flagSummary, VarSummary varSummary) {
        this.flagSummary = flagSummary;
        this.varSummary = varSummary;
        this.ids = new ArrayList<String>();
        for (String string : flagSummary.getFlags().keySet()) {
            this.ids.add(string);
        }
        for (String string : varSummary.getVars().keySet()) {
            this.ids.add(string);
        }
        Collections.sort(this.ids);
        this.onlyChanges = false;
    }

    public DebugTableModel(FlagSummary flagSummary, VarSummary varSummary, boolean bl) {
        this(flagSummary, varSummary);
        this.onlyChanges = bl;
    }

    public void addGlobalStates(List<GlobalState> list) {
        this.globalStates = list;
        for (GlobalState globalState : list) {
            this.ids.add(globalState.getId());
        }
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return TC.get((String)"DebugFrame.id");
        }
        if (n == 1) {
            return TC.get((String)"DebugFrame.value");
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (!this.onlyChanges) {
            return this.ids.size();
        }
        if (this.changes != null) {
            return this.changes.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getValueAt(int n, int n2) {
        String string = "";
        if (!this.onlyChanges) {
            string = this.ids.get(n);
        } else if (this.changes != null) {
            string = this.changes.get(n);
        }
        if (n2 == 0) {
            return string;
        }
        if (this.flagSummary.getFlags().containsKey(string)) {
            if (this.flagSummary.getFlagValue(string)) {
                return "true";
            }
            return "false";
        }
        if (this.varSummary.getVars().containsKey(string)) {
            return "" + this.varSummary.getValue(string);
        }
        for (GlobalState globalState : this.globalStates) {
            if (!globalState.getId().equals(string)) continue;
            FunctionalConditions functionalConditions = new FunctionalConditions((Conditions)globalState);
            if (functionalConditions.allConditionsOk()) {
                return "true";
            }
            return "false";
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = (String)object;
        JTextArea jTextArea = new JTextArea((String)object);
        if (string.equals("false")) {
            jTextArea.setForeground(Color.RED);
        } else if (string.equals("true")) {
            jTextArea.setForeground(Color.GREEN);
        }
        if (!this.onlyChanges && this.changes != null && this.changes.contains(this.ids.get(n))) {
            jTextArea.setBackground(Color.YELLOW);
        }
        return jTextArea;
    }

    public void setChanges(List<String> list) {
        this.changes = list;
    }
}

