/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.engine.core.gui.DebugLogPanel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DebugLog {
    private static final String DATE_FORMAT_NOW = "HH:mm:ss";
    public static final int GENERAL = 0;
    public static final int USER = 1;
    public static final int PLAYER = 2;
    private static DebugLog instance;
    private List<String> text = new ArrayList<String>();
    private DebugLogPanel debugFrameLog;

    public static DebugLog getInstance() {
        if (instance == null) {
            instance = new DebugLog();
        }
        return instance;
    }

    public static void player(String string) {
        DebugLog.getInstance().logEntry(2, string);
    }

    public static void general(String string) {
        DebugLog.getInstance().logEntry(0, string);
    }

    public static void user(String string) {
        DebugLog.getInstance().logEntry(1, string);
    }

    private void logEntry(int n, String string) {
        this.text.add(string);
        if (this.debugFrameLog != null) {
            this.debugFrameLog.addLine(n, this.now(), string);
        }
    }

    public String now() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    public void setDebugFrameLog(DebugLogPanel debugLogPanel) {
        this.debugFrameLog = debugLogPanel;
    }

    public void clear() {
        this.text.clear();
        this.debugFrameLog = null;
    }
}

