/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalScene;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.HashMap;

public class ActionManager {
    public static final int ACTION_LOOK = 0;
    public static final int ACTION_GRAB = 1;
    public static final int ACTION_TALK = 2;
    public static final int ACTION_EXAMINE = 3;
    public static final int ACTION_USE = 4;
    public static final int ACTION_GIVE = 5;
    public static final int ACTION_GOTO = 6;
    public static final int ACTION_USE_WITH = 7;
    public static final int ACTION_GIVE_TO = 8;
    public static final int ACTION_CUSTOM = 9;
    public static final int ACTION_CUSTOM_INTERACT = 10;
    public static final int ACTION_DRAG_TO = 11;
    private FunctionalElement elementOver = null;
    private int actionSelected = 6;
    private String customActionName;
    private String exit = "";
    private Cursor exitCursor = null;
    private HashMap<Exit, Cursor> cursors = new HashMap();
    private FunctionalElement dragElement = null;

    public FunctionalElement getElementOver() {
        return this.elementOver;
    }

    public void setElementOver(FunctionalElement functionalElement) {
        this.elementOver = functionalElement;
    }

    public int getActionSelected() {
        return this.actionSelected;
    }

    public void setActionSelected(int n) {
        this.actionSelected = n;
        GUI.getInstance().newActionSelected();
    }

    public String getExit() {
        return this.exit;
    }

    public Cursor getExitCursor() {
        return this.exitCursor;
    }

    public void setExit(String string) {
        this.exit = string == null ? "" : string;
    }

    public void setExitCursor(Cursor cursor) {
        this.exitCursor = cursor;
    }

    public void setExitCustomized(String string, Cursor cursor) {
        this.setExit(string);
        this.setExitCursor(cursor);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Game game = Game.getInstance();
        DebugLog.user("Mouse clicked in scene: " + mouseEvent.getX() + " , " + mouseEvent.getY());
        game.getFunctionalScene().mouseClicked(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Game game = Game.getInstance();
        FunctionalScene functionalScene = game.getFunctionalScene();
        if (functionalScene == null) {
            return;
        }
        Exit exit = functionalScene.getExitInside(mouseEvent.getX(), mouseEvent.getY());
        FunctionalElement functionalElement = functionalScene.getElementInside(mouseEvent.getX(), mouseEvent.getY(), this.dragElement);
        if (this.dragElement != null) {
            this.dragElement.setX(mouseEvent.getX());
            this.dragElement.setY(mouseEvent.getY());
        }
        if (exit == null && functionalElement != null) {
            this.setElementOver(functionalElement);
        } else if (exit != null && this.actionSelected == 6) {
            Cursor cursor;
            boolean bl;
            boolean bl2 = bl = this.getCursorPath(exit) != null && !this.getCursorPath(exit).equals("");
            if (bl && !this.cursors.containsKey(exit)) {
                try {
                    cursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(this.getCursorPath(exit), 1), new Point(0, 0), "exitCursor(" + exit + ")");
                }
                catch (Exception exception) {
                    cursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip("gui/cursors/nocursor.png", 1), new Point(0, 0), "exitCursor(" + exit + ")");
                }
                this.cursors.put(exit, cursor);
                this.setExitCursor(cursor);
            } else if (bl && this.cursors.containsKey(exit)) {
                this.setExitCursor(this.cursors.get(exit));
            } else {
                this.setExitCursor(null);
            }
            cursor = null;
            for (int i = 0; i < exit.getNextScenes().size() && cursor == null; ++i) {
                if (!new FunctionalConditions(((NextScene)exit.getNextScenes().get(i)).getConditions()).allConditionsOk()) continue;
                cursor = game.getCurrentChapterData().getGeneralScene(((NextScene)exit.getNextScenes().get(i)).getTargetId());
            }
            if (this.getExitText(exit) != null && !this.getExitText(exit).equals("")) {
                this.setExit(this.getExitText(exit));
            } else if (this.getExitText(exit) != null) {
                this.setExit(" ");
            } else if (cursor != null) {
                this.setExit(cursor.getName());
            }
        }
    }

    public String getExitText(Exit exit) {
        if (exit.getDefaultExitLook() != null) {
            return exit.getDefaultExitLook().getExitText();
        }
        return null;
    }

    public String getCursorPath(Exit exit) {
        if (exit.getDefaultExitLook() != null) {
            return exit.getDefaultExitLook().getCursorPath();
        }
        return null;
    }

    public void setCustomActionName(String string) {
        this.customActionName = string;
    }

    public String getCustomActionName() {
        return this.customActionName;
    }
}

