/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.assessment;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.assessment.AssessmentEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class ReportDialog
extends JDialog {
    public static final String[] IMPORTANCE_VALUES_PRINT = new String[]{TC.get((String)"Report.Importance.VeryLow"), TC.get((String)"Report.Importance.Low"), TC.get((String)"Report.Importance.Normal"), TC.get((String)"Report.Importance.High"), TC.get((String)"Report.Importance.VeryHigh")};
    private static final int WINDOW_WIDTH = 340;
    private static final int WINDOW_HEIGHT = 350;
    private AssessmentEngine assessmentEngine;
    private String adventureID;
    private JTextField txtCurrentDir;
    private JCheckBox chkXMLReport;
    private JCheckBox chkHTMLReport;
    private JLabel lblImportanceFilter;
    private JComboBox cmbImportanceFilter;

    public ReportDialog(Frame frame, AssessmentEngine assessmentEngine, String string) {
        super(frame, TC.get((String)"Report.Title"), true);
        this.assessmentEngine = assessmentEngine;
        this.adventureID = string;
        this.setSize(340, 350);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - 340) / 2, (dimension.height - 350) / 2);
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 10, 2, 10);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel(TC.get((String)"Report.SelectFolder")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 3);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 8.0;
        gridBagConstraints.fill = 2;
        try {
            this.txtCurrentDir = new JTextField(new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.txtCurrentDir.setEditable(false);
        jPanel.add((Component)this.txtCurrentDir, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 3, 10, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        JButton jButton = new JButton(TC.get((String)"Report.BtnExamine"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.examine();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), TC.get((String)"Report.XMLReport"), 1, 2));
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this.chkXMLReport = new JCheckBox(TC.get((String)"Report.GenerateXML"), false);
        jPanel3.add((Component)this.chkXMLReport, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getContentPane().getBackground());
        jTextPane.setText(TC.get((String)"Report.TextXMLReport"));
        jPanel3.add((Component)jTextPane, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), TC.get((String)"Report.HTMLReport"), 1, 2));
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.chkHTMLReport = new JCheckBox(TC.get((String)"Report.GenerateHTML"), false);
        this.chkHTMLReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.lblImportanceFilter.setEnabled(ReportDialog.this.chkHTMLReport.isSelected());
                ReportDialog.this.cmbImportanceFilter.setEnabled(ReportDialog.this.chkHTMLReport.isSelected());
            }
        });
        jPanel4.add((Component)this.chkHTMLReport, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 3, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        this.lblImportanceFilter = new JLabel(TC.get((String)"Report.Importance"));
        this.lblImportanceFilter.setEnabled(this.chkHTMLReport.isSelected());
        jPanel4.add((Component)this.lblImportanceFilter, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 2, 3, 10);
        gridBagConstraints.gridx = 2;
        this.cmbImportanceFilter = new JComboBox<String>(IMPORTANCE_VALUES_PRINT);
        this.cmbImportanceFilter.setSelectedIndex(2);
        this.cmbImportanceFilter.setEnabled(this.chkHTMLReport.isSelected());
        jPanel4.add((Component)this.cmbImportanceFilter, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setBackground(this.getContentPane().getBackground());
        jTextPane2.setText(TC.get((String)"Report.TextHTMLReport"));
        jPanel4.add((Component)jTextPane2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        JButton jButton2 = new JButton(TC.get((String)"Report.GenerateHTMLReport"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.generateReport();
                ReportDialog.this.setVisible(false);
            }
        });
        jPanel5.add(jButton2);
        JButton jButton3 = new JButton(TC.get((String)"Report.Cancel"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.setVisible(false);
            }
        });
        jPanel5.add(jButton3);
        this.add((Component)jPanel2, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        this.add((Component)jPanel6, "South");
        this.setVisible(true);
    }

    private void examine() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileFilter(new FolderFileFilter());
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                this.txtCurrentDir.setText(jFileChooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void generateReport() {
        if (this.chkXMLReport.isSelected()) {
            this.assessmentEngine.generateXMLReport(this.txtCurrentDir.getText() + "/" + this.adventureID + "-report.xml");
        }
        if (this.chkHTMLReport.isSelected()) {
            this.assessmentEngine.generateHTMLReportFile(this.txtCurrentDir.getText() + "/" + this.adventureID + "-report.html", this.cmbImportanceFilter.getSelectedIndex());
        }
    }

    private class FolderFileFilter
    extends FileFilter {
        private FolderFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Folders";
        }
    }
}

