/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.assessment;

import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.engine.assessment.AssessmentEngine;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessedRule {
    private AssessmentRule rule;
    private int time;

    public ProcessedRule(AssessmentRule assessmentRule, int n) {
        this.rule = assessmentRule;
        this.time = n;
    }

    public int getImportance() {
        return this.rule.getImportance();
    }

    public Element getDOMStructure() {
        Element element = null;
        try {
            DocumentBuilder documentBuilder = AssessmentEngine.dbf.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("processed-rule");
            element.setAttribute("id", this.rule.getId());
            if (this.rule instanceof TimedAssessmentRule) {
                element.setAttribute("type", "timed-rule");
            } else {
                element.setAttribute("type", "normal-rule");
            }
            element.setAttribute("importance", AssessmentRule.IMPORTANCE_VALUES[this.rule.getImportance()]);
            element.setAttribute("time", Integer.toString(this.time));
            Element element2 = document.createElement("concept");
            element2.setTextContent(this.rule.getConcept());
            element.appendChild(element2);
            if (this.rule.getText() != null) {
                Element element3 = document.createElement("text");
                element3.setTextContent(this.rule.getText());
                element.appendChild(element3);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return element;
    }

    public String getHTMLCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h3 id=\"" + this.rule.getId() + "\">");
        stringBuffer.append(this.rule.getConcept());
        stringBuffer.append(" (");
        if (this.time / 3600 < 10) {
            stringBuffer.append("0" + Integer.toString(this.time / 3600));
        } else {
            stringBuffer.append(Integer.toString(this.time / 3600));
        }
        stringBuffer.append(":");
        if (this.time / 60 % 60 < 10) {
            stringBuffer.append("0" + this.time / 60 % 60);
        } else {
            stringBuffer.append(this.time / 60 % 60);
        }
        stringBuffer.append(":");
        if (this.time % 60 < 10) {
            stringBuffer.append("0" + this.time % 60);
        } else {
            stringBuffer.append(this.time % 60);
        }
        stringBuffer.append(")");
        stringBuffer.append("</h3>");
        if (this.rule.getText() != null) {
            stringBuffer.append(this.rule.getText());
            stringBuffer.append("<br/>");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "Time: " + this.time + " - " + this.rule.toString();
    }
}

