/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.assessment;

import es.eucm.eadventure.comm.manager.commManager.CommManagerLAMS;
import es.eucm.eadventure.common.auxiliar.SendMail;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.engine.assessment.ProcessedRule;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.TimerEventListener;
import es.eucm.eadventure.engine.core.control.TimerManager;
import es.eucm.eadventure.engine.core.control.VarSummary;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssessmentEngine
implements TimerEventListener {
    public static int STATE_STARTED = 1;
    public static int STATE_NONE = 0;
    public static int STATE_DONE = 2;
    private static String HTML_REPORT_COLOR_0 = "794910";
    private static String HTML_REPORT_COLOR_1 = "F7D769";
    private static String HTML_REPORT_COLOR_2 = "FFFFFF";
    private AssessmentProfile assessmentProfile;
    private List<AssessmentRule> assessmentRules;
    private List<AssessmentRule> repeatedRules;
    private List<ProcessedRule> processedRules = new ArrayList<ProcessedRule>();
    private HashMap<Integer, TimedAssessmentRule> timedRules;
    protected static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private String playerName;
    private int state;

    public AssessmentEngine() {
        this.repeatedRules = new ArrayList<AssessmentRule>();
        this.timedRules = new HashMap();
        this.state = STATE_NONE;
    }

    public void loadAssessmentRules(AssessmentProfile assessmentProfile) {
        if (assessmentProfile != null) {
            this.assessmentProfile = assessmentProfile;
            this.assessmentRules = new ArrayList<AssessmentRule>(this.assessmentProfile.getRules());
            FlagSummary flagSummary = Game.getInstance().getFlags();
            VarSummary varSummary = Game.getInstance().getVars();
            for (String string : this.assessmentProfile.getFlags()) {
                flagSummary.addFlag(string);
            }
            for (String string : this.assessmentProfile.getVars()) {
                varSummary.addVar(string);
            }
            for (AssessmentRule assessmentRule : this.assessmentRules) {
                if (!(assessmentRule instanceof TimedAssessmentRule)) continue;
                TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)assessmentRule;
                int n = TimerManager.getInstance().addTimer(timedAssessmentRule.getInitConditions(), timedAssessmentRule.getEndConditions(), timedAssessmentRule.isUsesEndConditions(), this);
                this.timedRules.put(new Integer(n), timedAssessmentRule);
            }
            this.processRules();
        }
    }

    public static AssessmentProfile loadAssessmentProfile(String string) {
        if (string != null && !string.equals("")) {
            AssessmentProfile assessmentProfile = Loader.loadAssessmentProfile((InputStreamCreator)ResourceHandler.getInstance(), (String)string, new ArrayList());
            return assessmentProfile;
        }
        return null;
    }

    public void processRules() {
        int n = 0;
        try {
            if (this.assessmentRules != null) {
                for (AssessmentRule assessmentRule : this.repeatedRules) {
                    if (!AssessmentEngine.isActive(assessmentRule)) continue;
                    this.triggerRule(assessmentRule);
                }
                while (n < this.assessmentRules.size()) {
                    if (AssessmentEngine.isActive(this.assessmentRules.get(n))) {
                        AssessmentRule assessmentRule = (AssessmentRule)this.assessmentRules.remove(n).clone();
                        if (assessmentRule.isRepeatRule().booleanValue()) {
                            this.repeatedRules.add(assessmentRule);
                        }
                        this.triggerRule(assessmentRule);
                        continue;
                    }
                    ++n;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    private void triggerRule(AssessmentRule assessmentRule) {
        assessmentRule.setConcept(Game.getInstance().processText(assessmentRule.getConcept()));
        assessmentRule.setText(Game.getInstance().processText(assessmentRule.getText()));
        ProcessedRule processedRule = new ProcessedRule(assessmentRule, Game.getInstance().getTime());
        if (Game.getInstance().isConnected()) {
            List<AssessmentProperty> list = this.checkProperties(assessmentRule.getAssessmentProperties());
            Game.getInstance().getComm().notifyRelevantState(list);
        }
        this.processedRules.add(processedRule);
    }

    private static boolean isActive(AssessmentRule assessmentRule) {
        return new FunctionalConditions(assessmentRule.getConditions()).allConditionsOk();
    }

    private List<AssessmentProperty> checkProperties(List<AssessmentProperty> list) {
        if (list != null) {
            for (AssessmentProperty assessmentProperty : list) {
                if (assessmentProperty.getVarName() == null) continue;
                if (Game.getInstance().getFlags().existFlag(assessmentProperty.getVarName())) {
                    if (Game.getInstance().getFlags().getFlagValue(assessmentProperty.getVarName())) {
                        assessmentProperty.setValue("true");
                        continue;
                    }
                    assessmentProperty.setValue("false");
                    continue;
                }
                if (Game.getInstance().getVars().existVar(assessmentProperty.getVarName())) {
                    assessmentProperty.setValue(Integer.toString(Game.getInstance().getVars().getValue(assessmentProperty.getVarName())));
                    continue;
                }
                if (!assessmentProperty.getVarName().equals("report")) continue;
                assessmentProperty.setValue(this.generateXMLReport());
            }
        }
        return list;
    }

    public TimedAssessmentRule getTimedAssessmentRule(int n) {
        return this.timedRules.get(new Integer(n));
    }

    public String generateXMLReport() {
        StringWriter stringWriter = null;
        try {
            Document document = this.generateDOM(false);
            stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        if (stringWriter != null) {
            System.out.println(stringWriter.toString());
            return stringWriter.toString();
        }
        return "";
    }

    public Document generateDOM(boolean bl) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElement("report");
            for (ProcessedRule processedRule : this.processedRules) {
                Element element2 = processedRule.getDOMStructure();
                document.adoptNode(element2);
                element.appendChild(element2);
            }
            document.appendChild(element);
            if (bl) {
                this.indentDOM(element, 0);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public void generateXMLReport(String string) {
        try {
            Document document = this.generateDOM(true);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public String getHTMLReportStringLAMS() {
        CommManagerLAMS commManagerLAMS = (CommManagerLAMS)Game.getInstance().getComm();
        return this.getHTMLReportString(": " + commManagerLAMS.getUserFName() + " " + commManagerLAMS.getUserLName(), false, 0);
    }

    public String getHTMLReportString() {
        return this.getHTMLReportString("", true, -5);
    }

    public String getHTMLReportString(String string, boolean bl, int n) {
        String string2 = new String();
        string2 = string2 + "<html>";
        string2 = string2 + "<title>";
        string2 = string2 + Game.getInstance().processText(Game.getInstance().getGameDescriptor().getTitle());
        string2 = string2 + "</title>";
        string2 = !bl ? string2 + "<body>" : string2 + "<body style=\"background: #" + HTML_REPORT_COLOR_0 + ";\">";
        string2 = string2 + "<br/><br/>";
        string2 = string2 + "<table width=\"80%\" align=\"center\" style=\"background : #" + HTML_REPORT_COLOR_1 + "; border : 1px solid #000000;\">";
        string2 = string2 + "<tr><td>";
        string2 = string2 + "<center><h1>";
        string2 = string2 + Game.getInstance().processText(Game.getInstance().getGameDescriptor().getTitle());
        string2 = string2 + " report" + string;
        string2 = string2 + "</h1></center>";
        string2 = string2 + "<br/><br/>";
        string2 = string2 + "<table width=\"95%\" align=\"center\" style=\"background : #" + HTML_REPORT_COLOR_2 + "; border : 1px solid #000000\">";
        string2 = string2 + "<tr><td>";
        for (ProcessedRule processedRule : this.processedRules) {
            if (processedRule.getImportance() < n) continue;
            string2 = string2 + Game.getInstance().processText(processedRule.getHTMLCode());
            string2 = string2 + "<br/><br/>";
        }
        string2 = string2 + "</td></tr>";
        string2 = string2 + "</table>";
        string2 = string2 + "<br/><br/>";
        string2 = string2 + "</td></tr>";
        string2 = string2 + "</table>";
        string2 = string2 + "</body>";
        string2 = string2 + "</html>";
        return string2;
    }

    public void generateHTMLReportFile(String string, int n) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.print(this.getHTMLReportString());
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private void indentDOM(Node node, int n) {
        Document document = node.getOwnerDocument();
        NodeList nodeList = node.getChildNodes();
        boolean bl = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            node.insertBefore(document.createTextNode("\n" + this.getTab(n + 1)), node2);
            this.indentDOM(node2, n + 1);
            bl = false;
            ++i;
        }
        if (!bl) {
            node.appendChild(document.createTextNode("\n" + this.getTab(n)));
        }
    }

    private String getTab(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string;
    }

    @Override
    public void cycleCompleted(int n, long l) {
    }

    @Override
    public void timerStarted(int n, long l) {
        TimedAssessmentRule timedAssessmentRule = this.timedRules.get(new Integer(n));
        timedAssessmentRule.ruleStarted(l);
    }

    @Override
    public void timerStopped(int n, long l) {
        TimedAssessmentRule timedAssessmentRule = this.timedRules.get(new Integer(n));
        timedAssessmentRule.ruleDone(l);
        TimerManager.getInstance().deleteTimer(n);
    }

    public boolean isEndOfChapterFeedbackDone() {
        if (this.assessmentProfile != null) {
            if (this.state == STATE_NONE && this.assessmentProfile.isShowReportAtEnd()) {
                this.state = STATE_STARTED;
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setContentType("text/html");
                jEditorPane.setText(this.getHTMLReportString());
                jEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 31);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jScrollPane, "Center");
                JPanel jPanel2 = new JPanel();
                if (!this.assessmentProfile.isSendByEmail()) {
                    JButton jButton = new JButton("OK");
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            GUI.getInstance().restoreFrame();
                            AssessmentEngine.this.state = STATE_DONE;
                        }
                    });
                    jPanel2.add(jButton);
                } else {
                    JComponent jComponent;
                    final JButton jButton = new JButton(TC.get((String)"Report.OKSend"));
                    if (this.playerName == null || this.playerName.equals("")) {
                        jButton.setEnabled(false);
                        jComponent = new JLabel(TC.get((String)"Report.Name"));
                        jComponent.setForeground(Color.white);
                        jPanel2.add(jComponent);
                        JTextField jTextField = new JTextField(30);
                        jTextField.getDocument().addDocumentListener(new DocumentListener(){

                            @Override
                            public void changedUpdate(DocumentEvent documentEvent) {
                                this.update(documentEvent);
                            }

                            @Override
                            public void insertUpdate(DocumentEvent documentEvent) {
                                this.update(documentEvent);
                            }

                            @Override
                            public void removeUpdate(DocumentEvent documentEvent) {
                                this.update(documentEvent);
                            }

                            private void update(DocumentEvent documentEvent) {
                                try {
                                    AssessmentEngine.this.playerName = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                                }
                                catch (BadLocationException badLocationException) {
                                    badLocationException.printStackTrace();
                                }
                                if (AssessmentEngine.this.playerName == null || AssessmentEngine.this.playerName.equals("")) {
                                    jButton.setEnabled(false);
                                } else {
                                    jButton.setEnabled(true);
                                }
                            }
                        });
                        jPanel2.add(jTextField);
                    }
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String[] stringArray = new String[]{AssessmentEngine.this.assessmentProfile.getEmail()};
                            String string = "Report eAdventure";
                            String string2 = "Report from: " + AssessmentEngine.this.playerName;
                            SendMail sendMail = new SendMail(AssessmentEngine.this.assessmentProfile.getSmtpServer(), AssessmentEngine.this.assessmentProfile.getSmtpUser(), AssessmentEngine.this.assessmentProfile.getSmtpPwd());
                            sendMail.setPort(Integer.parseInt(AssessmentEngine.this.assessmentProfile.getSmtpPort()));
                            sendMail.setRequiersSSL(AssessmentEngine.this.assessmentProfile.isSmtpSSL());
                            try {
                                File file = File.createTempFile("ead", ".html");
                                AssessmentEngine.this.generateHTMLReportFile(file.getAbsolutePath(), -5);
                                sendMail.postMailAttachements(stringArray, string, string2, null, file.getAbsolutePath());
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                string2 = string2 + AssessmentEngine.this.getHTMLReportString();
                                sendMail.postMail(stringArray, string, string2, null);
                            }
                            GUI.getInstance().restoreFrame();
                            AssessmentEngine.this.state = STATE_DONE;
                        }
                    });
                    jPanel2.add(jButton);
                    jComponent = new JButton(TC.get((String)"Report.OKDontSend"));
                    ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            GUI.getInstance().restoreFrame();
                            AssessmentEngine.this.state = STATE_DONE;
                        }
                    });
                    jPanel2.add(jComponent);
                }
                jPanel.add((Component)jPanel2, "South");
                GUI.getInstance().showComponent(jPanel);
                return false;
            }
            if (this.state == STATE_STARTED) {
                GUI.getInstance().componentRepaint();
                return false;
            }
            if (this.state == STATE_DONE) {
                return true;
            }
            return true;
        }
        return true;
    }

    public AssessmentProfile getAssessmentProfile() {
        return this.assessmentProfile;
    }

    public void setPlayerName(String string) {
        this.playerName = string;
    }
}

