/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.engine.adaptation.AdaptationClock;
import es.eucm.eadventure.engine.core.control.FlagSummary;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.VarSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdaptationEngine {
    public static final String INITIAL_STATE = "Initial";
    public static final String ADAPTATION_RULES = "Adaptation";
    private AdaptedState initialAdaptedState;
    private List<AdaptationRule> externalAdaptationRules;
    private Set<String> externalPropertyNames;
    private AdaptationClock adaptationClock;

    public AdaptedState init(AdaptationProfile adaptationProfile) {
        this.loadAdaptationProfile(adaptationProfile);
        if (this.externalAdaptationRules == null) {
            this.externalAdaptationRules = new ArrayList<AdaptationRule>();
        }
        if (Game.getInstance().isAppletMode()) {
            if (Game.getInstance().getComm().getCommType() == 2) {
                this.processLDRules();
            } else if (Game.getInstance().getComm().getCommType() == 0 || Game.getInstance().getComm().getCommType() == 1) {
                this.processSCORMRules();
            }
        }
        return this.initialAdaptedState;
    }

    private void loadAdaptationProfile(AdaptationProfile adaptationProfile) {
        if (adaptationProfile != null) {
            FlagSummary flagSummary = Game.getInstance().getFlags();
            VarSummary varSummary = Game.getInstance().getVars();
            for (String string : adaptationProfile.getFlags()) {
                flagSummary.addFlag(string);
            }
            for (String string : adaptationProfile.getVars()) {
                varSummary.addVar(string);
            }
            this.initialAdaptedState = adaptationProfile.getAdaptedState();
            this.externalAdaptationRules = adaptationProfile.getRules();
        }
    }

    private void processLDRules() {
        Game.getInstance().getComm().setAdaptationEngine(this);
        this.externalPropertyNames = new HashSet<String>();
        for (AdaptationRule adaptationRule : this.externalAdaptationRules) {
            for (String string : adaptationRule.getPropertyNames()) {
                this.externalPropertyNames.add(string);
            }
        }
        this.requestNewState();
        this.adaptationClock = new AdaptationClock(this);
        this.adaptationClock.start();
    }

    private void processSCORMRules() {
        HashSet<String> hashSet = new HashSet<String>();
        for (AdaptationRule adaptationRule : this.externalAdaptationRules) {
            Object object2;
            Set set = adaptationRule.getPropertyNames();
            for (Object object2 : set) {
                hashSet.add((String)object2);
            }
            Game.getInstance().getComm().getAdaptedState(hashSet);
            HashMap hashMap = Game.getInstance().getComm().getInitialStates();
            object2 = hashMap.keySet();
            boolean bl = true;
            Iterator iterator = set.iterator();
            while (bl && iterator.hasNext()) {
                String string = (String)iterator.next();
                bl = this.checkOperation((Set<String>)object2, hashMap, string, adaptationRule);
            }
            if (!bl) continue;
            Game.getInstance().setAdaptedStateToExecute(adaptationRule.getAdaptedState());
        }
    }

    private boolean checkOperation(Set<String> set, HashMap<String, String> hashMap, String string, AdaptationRule adaptationRule) {
        boolean bl = true;
        try {
            if (set.contains(string)) {
                String string2 = adaptationRule.getPropertyOp(string);
                if (string2.equals("eq")) {
                    if (!hashMap.get(string).equals(adaptationRule.getPropertyValue(string))) {
                        bl = false;
                    }
                } else if (string2.equals("gt")) {
                    if (Integer.parseInt(hashMap.get(string)) <= Integer.parseInt(adaptationRule.getPropertyValue(string))) {
                        bl = false;
                    }
                } else if (string2.equals("ge")) {
                    if (Integer.parseInt(hashMap.get(string)) < Integer.parseInt(adaptationRule.getPropertyValue(string))) {
                        bl = false;
                    }
                } else if (string2.equals("lt")) {
                    if (Integer.parseInt(hashMap.get(string)) >= Integer.parseInt(adaptationRule.getPropertyValue(string))) {
                        bl = false;
                    }
                } else if (string2.equals("le") && Integer.parseInt(hashMap.get(string)) > Integer.parseInt(adaptationRule.getPropertyValue(string))) {
                    bl = false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error:try to use numeric comparator with a non numeric field ");
            bl = false;
        }
        return bl;
    }

    void requestNewState() {
        Game.getInstance().getComm().getAdaptedState(this.externalPropertyNames);
    }

    public synchronized void processExternalState(Map<String, String> map) {
        for (AdaptationRule adaptationRule : this.externalAdaptationRules) {
            if (!AdaptationEngine.evaluate(adaptationRule, map)) continue;
            Game.getInstance().setAdaptedStateToExecute(adaptationRule.getAdaptedState());
            return;
        }
    }

    private static boolean evaluate(AdaptationRule adaptationRule, Map<String, String> map) {
        boolean bl = true;
        Iterator iterator = adaptationRule.getPropertyNames().iterator();
        while (bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                bl = map.get(string).equals(adaptationRule.getPropertyValue(string));
                if (!bl) continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("The external state does not reflect all relevant properties: Property " + string + " not found.");
            }
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    public void stopAdaptationClock() {
        if (this.adaptationClock != null) {
            this.adaptationClock.stopClock();
        }
    }
}

